/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.BigDecimalFormatter;
import controllers.util.DateFormatter;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBalance;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmCheck;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Conversion;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.SimpleTextFilter;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.mt940.PrintBaseAction;
import de.businesslogics.banking.mt940.StatementsPeriodProvider;
import de.businesslogics.banking.mt940.api.AutomaticExporterApi;
import de.businesslogics.banking.mt940.api.BalanceSumHandler;
import de.businesslogics.banking.mt940.api.CMAccount;
import de.businesslogics.banking.mt940.api.CmDeleter;
import de.businesslogics.banking.mt940.api.CmOverviewCsvExport;
import de.businesslogics.banking.mt940.api.CmReporterApi;
import de.businesslogics.banking.mt940.api.Converter;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.banking.mt940.api.StatementExporter;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.io.Streams;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import io.ebean.Expression;
import io.ebean.PagedList;
import io.ebean.Update;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.CmDateRangeForm;
import models.CmFolderIdForm;
import models.CmFolderNameForm;
import models.DeleteForm;
import models.ImportStatementsForm;
import models.SimpleTextForm;
import models.cm.BookingExportForm;
import models.cm.CmExportForm;
import models.cm.CmUtils;
import models.cm.MarkAsReadForm;
import play.data.Form;
import play.data.FormFactory;
import play.data.format.Formatters;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Files;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import play.twirl.api.Html;
import views.Utils;
import views.html.cm.cmOverview;
import views.html.cm.importstatementsform;

@Security.Authenticated(value=AuthenticatorFor.CM.class)
public class CmAccountOverview
extends Controller {
    private static final String PROPS_FOLDER = "folder";
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static String loadJsParameters(Form<CmFolderNameForm> newFolderForm, Form<CmFolderNameForm> renameFolderForm, Form<CmFolderIdForm> moveToFolderForm, Form<CmExportForm> exportForm) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("show_newfolderform", String.valueOf(newFolderForm != null && newFolderForm.hasErrors()));
        resultJson.put("show_renamefolderform", String.valueOf(renameFolderForm != null && renameFolderForm.hasErrors()));
        resultJson.put("show_movetofolderform", String.valueOf(moveToFolderForm != null && moveToFolderForm.hasErrors()));
        resultJson.put("show_exportform", String.valueOf(exportForm != null && exportForm.hasErrors()));
        resultJson.put("balanceSumsLink", routes.CmAccountOverview.getBalanceSums("999").toString());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    @Inject
    public CmAccountOverview(FormFactory formFactory, Formatters formatters, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        formatters.register(BigDecimal.class, (Formatters.SimpleFormatter)new BigDecimalFormatter());
        formatters.register(Date.class, (Formatters.SimpleFormatter)new DateFormatter());
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public Result index(Http.Request request) {
        return this.index(request, null, null, null, null, null);
    }

    private Result index(Http.Request request, Form<CmFolderNameForm> newFolderForm, Form<CmFolderNameForm> renameFolderForm, Form<CmFolderIdForm> moveToFolderForm, Form<CmExportForm> exportForm, Form<DeleteForm> deleteForm) {
        boolean userHasAnySchedulers;
        boolean userHasMultipleTenants;
        String filterText;
        List cmFolders;
        Set<CMAccount> accountsWithUnreadData;
        List<CMAccount> displayedAccounts;
        List<CMAccount> allAccounts;
        boolean extraLogs = Branding.getBranding().logCmLoadTimes();
        String requestId = String.valueOf(request.hashCode());
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: Start loading CM account overview page ...");
        }
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_STATEMENT);
        int folderId = Integer.parseInt(sorting.getProperty(PROPS_FOLDER, "-1"));
        CmFolder folder = this.getFolder(user, folderId);
        try {
            if (extraLogs) {
                BLLoggerPlay.info("[Request " + requestId + "]: ... start loading accounts from database ...");
            }
            allAccounts = this.loadAccounts(user, sorting, folder);
            displayedAccounts = sorting.computeForList(allAccounts);
            if (extraLogs) {
                BLLoggerPlay.info("[Request " + requestId + "]: ... finished loading accounts from database ...");
            }
            if (extraLogs) {
                BLLoggerPlay.info("[Request " + requestId + "]: ... start loading CM check infos from database ...");
            }
            accountsWithUnreadData = displayedAccounts.stream().filter(a -> CmCheck.isChecked((User)user, (Account)a.getAccount(), (Collection)CmStatement.StatementAndAdviceTypes)).collect(Collectors.toSet());
            if (extraLogs) {
                BLLoggerPlay.info("[Request " + requestId + "]: ... finished loading CM check infos from database ...");
            }
            if (extraLogs) {
                BLLoggerPlay.info("[Request " + requestId + "]: ... start loading folders from database ...");
            }
            cmFolders = CmFolder.findAll((User)user);
            if (extraLogs) {
                BLLoggerPlay.info("[Request " + requestId + "]: ... finished loading folders from database ...");
            }
        }
        catch (PersistenceException e) {
            if (extraLogs) {
                BLLoggerPlay.info("[Request " + requestId + "]: ... error while loading accounts from database.");
            }
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.CM_STATEMENT, (Call)routes.CmAccountOverview.index());
        }
        if (newFolderForm == null) {
            newFolderForm = this.formFactory.form(CmFolderNameForm.class);
        }
        if (renameFolderForm == null) {
            CmFolderNameForm f = new CmFolderNameForm();
            if (folder != null) {
                f.name = folder.getName();
                if (folder.getTenant() != null) {
                    f.tenantId = folder.getTenant().getId();
                }
            }
            renameFolderForm = this.formFactory.form(CmFolderNameForm.class).fill((Object)f);
        }
        if (moveToFolderForm == null) {
            moveToFolderForm = this.formFactory.form(CmFolderIdForm.class);
        }
        if (exportForm == null) {
            CmExportForm exportDateValues = new CmExportForm();
            exportDateValues.fromDate = Date.from(ZonedDateTime.now().minusMonths(1L).toInstant());
            exportDateValues.toDate = new Date();
            exportForm = this.formFactory.form(CmExportForm.class).fill((Object)exportDateValues);
        }
        if (deleteForm == null) {
            deleteForm = this.formFactory.form(DeleteForm.class);
        }
        CmDateRangeForm dateValues = new CmDateRangeForm();
        dateValues.fromDate = Date.from(ZonedDateTime.now().minusMonths(1L).toInstant());
        dateValues.toDate = new Date();
        Form printForm = this.formFactory.form(CmDateRangeForm.class).fill((Object)dateValues);
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.CM_OVERVIEW);
        SimpleTextForm filterValue = new SimpleTextForm();
        filterValue.text = filter.getFilterText();
        Form filterForm = this.formFactory.form(SimpleTextForm.class).fill((Object)filterValue);
        String string = filterText = filter.isFilterActive() ? filter.getFilterText() : null;
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: ... start loading tenants from database ...");
        }
        boolean bl = userHasMultipleTenants = user.getVisibleTenants().size() > 1;
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: ... finished loading tenants from database ...");
        }
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: ... start loading automatic exports from database ...");
        }
        boolean userHasAnyAutomaticExports = CmAccountOverview.areAnyAutomaticExports(user);
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: ... finished loading automatic exports from database ...");
        }
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: ... start loading schedulers from database ...");
        }
        boolean bl2 = userHasAnySchedulers = Scheduler.findForBanksOfUser((User)user).setMaxRows(1).findOne() != null;
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: ... finished loading schedulers from database ...");
        }
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: ... start loading balance sum handler ...");
        }
        DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
        BalanceSumHandler balanceSumHandler = new BalanceSumHandler(allAccounts, preferences2.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.BALANCES_WITH_ADVICE_INFO), messages.lang().locale());
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: ... finished loading balance sum handler ...");
        }
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: ... start rendering the CM account overview page ...");
        }
        Html page = cmOverview.render(allAccounts, displayedAccounts, accountsWithUnreadData, cmFolders, sorting, folder, balanceSumHandler, userHasMultipleTenants, userHasAnyAutomaticExports, userHasAnySchedulers, (Form<CmDateRangeForm>)printForm, (Form<CmFolderNameForm>)newFolderForm, (Form<CmFolderNameForm>)renameFolderForm, (Form<CmFolderIdForm>)moveToFolderForm, (Form<SimpleTextForm>)filterForm, filterText, (Form<CmExportForm>)exportForm, (Form<DeleteForm>)deleteForm, request, messages);
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: ... finished rendering the CM account overview page ...");
        }
        if (extraLogs) {
            BLLoggerPlay.info("[Request " + requestId + "]: Returning the finished CM account overview page to the browser.");
        }
        return CmAccountOverview.ok((Content)page);
    }

    public Result index_sort(Http.Request request, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.CM_STATEMENT);
        sorting.setSortingColumn(Integer.valueOf(sort));
        sorting.setSortAscending(asc);
        sorting.save();
        return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index());
    }

    public Result index_pageSize(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_STATEMENT).updatePage(page, pageSize);
        return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index());
    }

    public Result index_filter(Http.Request request, boolean active) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.CM_OVERVIEW);
        if (active) {
            Form filterForm = this.formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
            String filterText = ((SimpleTextForm)filterForm.get()).text;
            if (filterText != null && filterText.length() > 0) {
                filter.setFilterText(filterText);
                filter.setFilterActive(true);
            } else {
                filter.setFilterText(null);
                filter.setFilterActive(false);
            }
        } else {
            filter.setFilterActive(false);
        }
        filter.save();
        return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index());
    }

    public Result index_folder(Http.Request request, int folderId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_STATEMENT);
        sorting.setProperty(PROPS_FOLDER, String.valueOf(folderId));
        return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index());
    }

    public Result index_newFolder(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form<CmFolderNameForm> form = this.formFactory.form(CmFolderNameForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        CmFolder folder = new CmFolder();
        if (!form.hasErrors()) {
            form = ((CmFolderNameForm)form.get()).validateFolderChanges(form, folder, user, messages.lang().locale());
        }
        if (form.hasErrors()) {
            return this.index(request, form, null, null, null, null);
        }
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_STATEMENT);
        if (folder.getId() != null) {
            sorting.setProperty(PROPS_FOLDER, String.valueOf(folder.getId()));
        } else {
            sorting.setProperty(PROPS_FOLDER, null);
        }
        return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index());
    }

    public Result index_renameFolder(Http.Request request) {
        Form<CmFolderNameForm> form = this.formFactory.form(CmFolderNameForm.class).bindFromRequest(request, new String[0]);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_STATEMENT);
        CmFolder folder = this.getFolder(user, Integer.parseInt(sorting.getProperty(PROPS_FOLDER, "-1")));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (folder == null) {
            return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("error", messages.at("balancelists.error.noSuchGroup", new Object[0]));
        }
        if (!form.hasErrors()) {
            form = ((CmFolderNameForm)form.get()).validateFolderChanges(form, folder, User.getUser((String)((String)request.attrs().get(Security.USERNAME))), messages.lang().locale());
        }
        if (form.hasErrors()) {
            return this.index(request, null, form, null, null, null);
        }
        return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index());
    }

    public Result index_deleteFolder(Http.Request request) {
        SortingHandler sorting;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        CmFolder folder = this.getFolder(user, Integer.parseInt((sorting = new SortingHandler(user, Sorting.Table.CM_STATEMENT)).getProperty(PROPS_FOLDER, "-1")));
        if (folder == null) {
            return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("error", messages.at("balancelists.error.noSuchGroup", new Object[0]));
        }
        CmFolder.delete((CmFolder)folder);
        sorting.setProperty(PROPS_FOLDER, null);
        return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index());
    }

    private List<CMAccount> loadAccounts(User user, SortingHandler sorting, CmFolder folder) {
        DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
        boolean displayAllHTDAccounts = preferences2.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ALL_HTD_ACCOUNTS);
        boolean checkPermission = preferences2.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.CM_OVERVIEW);
        Expression filterExpression = null;
        if (filter.isFilterActive()) {
            filterExpression = Account.getFilterExpression((String)filter.getFilterText(), (boolean)true);
        }
        ArrayList<CMAccount> accounts2 = new ArrayList<CMAccount>();
        for (Account a : Account.findAccounts((User)user, (Expression)filterExpression, (CmFolder)folder, (boolean)checkPermission)) {
            int countStatements = CmStatement.findCountStatementsAndAdvices((Account)a, null, null);
            if (countStatements <= 0 && (!displayAllHTDAccounts || !a.isHTDAccount() && !a.getIgnoreAccountInformation())) continue;
            accounts2.add(new CMAccount(a, user));
        }
        boolean withAdvices = preferences2.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.BALANCES_WITH_ADVICE_INFO);
        Comparator comp = (o1, o2) -> {
            switch (sorting.getSortingColumn()) {
                case 1: {
                    return Account.getCmDisplayName((Account)o1.getAccount()).compareTo(Account.getCmDisplayName((Account)o2.getAccount()));
                }
                case 2: {
                    String desc1 = o1.getAccount().getDescription();
                    String desc2 = o2.getAccount().getDescription();
                    if (desc1 != null && desc2 != null) {
                        return desc1.compareTo(desc2);
                    }
                    if (desc1 == null) {
                        return -1;
                    }
                    return 1;
                }
                case 3: {
                    String accHolder1 = o1.getAccount().getAccountHolder();
                    String accHolder2 = o2.getAccount().getAccountHolder();
                    if (accHolder1 != null && accHolder2 != null) {
                        return accHolder1.compareTo(accHolder2);
                    }
                    if (accHolder1 == null) {
                        return -1;
                    }
                    return 1;
                }
                case 4: {
                    return this.compareDate(o1.getNewestStatement(), o2.getNewestStatement());
                }
                case 5: {
                    return this.compareAmount(o1.getNewestStatement(), o2.getNewestStatement());
                }
                case 6: {
                    return this.compareBigDecimal(o1.getAccount().getCreditLimit(), o2.getAccount().getCreditLimit());
                }
                case 7: {
                    return this.compareBigDecimal(o1.getFreeLiquidity(), o2.getFreeLiquidity());
                }
                case 8: {
                    return this.compareBalance(o1.getVbToday(), o2.getVbToday(), withAdvices);
                }
                case 9: {
                    return this.compareBalance(o1.getVbTomorrow(), o2.getVbTomorrow(), withAdvices);
                }
                case 10: {
                    return this.compareBalance(o1.getVbAfterTomorrow(), o2.getVbAfterTomorrow(), withAdvices);
                }
                case 11: {
                    return this.compareOpeningBalance(o1.getNewestStatement(), o2.getNewestStatement());
                }
                case 12: {
                    return this.compareSumDebit(o1.getNewestStatement(), o2.getNewestStatement());
                }
                case 13: {
                    return this.compareSumCredit(o1.getNewestStatement(), o2.getNewestStatement());
                }
                case 99: {
                    int compareBanks = o1.getAccount().getBank().getDisplayName().compareTo(o2.getAccount().getBank().getDisplayName());
                    if (compareBanks == 0) {
                        return o1.getAccount().getName().compareTo(o2.getAccount().getName());
                    }
                    return compareBanks;
                }
            }
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        };
        if (sorting.isSortingAscending()) {
            accounts2.sort(comp);
        } else {
            accounts2.sort(comp.reversed());
        }
        return accounts2;
    }

    private int compareBigDecimal(BigDecimal a, BigDecimal b) {
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null) {
            return 1;
        }
        return 0;
    }

    private int compareBalance(CmBalance b1, CmBalance b2, boolean withAdvices) {
        if (b1 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        return EclipseFreeHelper.getBalance((CmBalance)b1, (boolean)withAdvices).compareTo(EclipseFreeHelper.getBalance((CmBalance)b2, (boolean)withAdvices));
    }

    private int compareOpeningBalance(CmStatement b1, CmStatement b2) {
        if (b1 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        return EclipseFreeHelper.getOpeningBalance((CmStatement)b1).compareTo(EclipseFreeHelper.getOpeningBalance((CmStatement)b2));
    }

    private int compareSumDebit(CmStatement b1, CmStatement b2) {
        if (b1 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        return EclipseFreeHelper.getSumDebit((CmStatement)b1).compareTo(EclipseFreeHelper.getSumDebit((CmStatement)b2));
    }

    private int compareSumCredit(CmStatement b1, CmStatement b2) {
        if (b1 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        return EclipseFreeHelper.getSumCredit((CmStatement)b1).compareTo(EclipseFreeHelper.getSumCredit((CmStatement)b2));
    }

    private int compareDate(CmStatement stmt1, CmStatement stmt2) {
        if (stmt1 == null) {
            return stmt2 == null ? 0 : -1;
        }
        if (stmt2 == null) {
            return 1;
        }
        return stmt1.getClosingDate().compareTo(stmt2.getClosingDate());
    }

    private int compareAmount(CmStatement stmt1, CmStatement stmt2) {
        if (stmt1 == null) {
            return stmt2 == null ? 0 : -1;
        }
        if (stmt2 == null) {
            return 1;
        }
        return stmt1.getClosingBalance().compareTo(stmt2.getClosingBalance());
    }

    public Result markStatementsAsRead(Http.Request request) {
        List<Integer> ids;
        String referer = Utils.getHeaderValue(request, "referer");
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(MarkAsReadForm.class).bindFromRequest(request, new String[0]);
        String bookingIds = ((MarkAsReadForm)form.get()).bookingIds;
        String accountIds = ((MarkAsReadForm)form.get()).accountIds;
        String pageIds = ((MarkAsReadForm)form.get()).pageIds;
        HashSet pagesToCheck = new HashSet();
        HashSet statementsToCheck = new HashSet();
        String flashType = "warning";
        String flashMessage = messages.at("cm.markasread.failed", new Object[0]);
        if (pageIds != null && !pageIds.isEmpty()) {
            ids = GeneralUtils.getSelectionIds(pageIds);
            pagesToCheck.addAll(DB.find(CmPage.class).where().in("id", ids).findSet());
            flashType = "success";
            flashMessage = messages.at("cm.markasread.success.pages", new Object[]{ids.size()});
        }
        if (bookingIds != null && !bookingIds.isEmpty()) {
            ids = GeneralUtils.getSelectionIds(bookingIds);
            pagesToCheck.addAll(ids.stream().map(CmBooking::findById).filter(Objects::nonNull).map(CmBooking::getPage).filter(Objects::nonNull).collect(Collectors.toSet()));
            statementsToCheck.addAll(ids.stream().map(CmBooking::findById).filter(Objects::nonNull).filter(booking -> booking.getPage() == null).map(CmBooking::getStatement).collect(Collectors.toSet()));
            flashType = "success";
            flashMessage = messages.at("cm.markasread.success.bookings", new Object[]{ids.size()});
        }
        if (accountIds != null && !accountIds.isEmpty()) {
            ids = GeneralUtils.getSelectionIds(accountIds);
            HashSet statementTypes = new HashSet();
            statementTypes.addAll(CmStatement.StatementAndAdviceTypes);
            statementTypes.addAll(CmStatement.DtiTypes);
            statementsToCheck.addAll(this.getAccounts(ids, user).stream().filter(Objects::nonNull).map(account -> CmStatement.findByAccount((Account)account, (Set)statementTypes, (boolean)true, null, null)).flatMap(Collection::stream).collect(Collectors.toSet()));
            flashType = "success";
            flashMessage = messages.at("cm.markasread.success.accounts", new Object[]{ids.size()});
        }
        pagesToCheck.forEach(page -> CmCheck.deleteForUserAndPage((User)user, (CmPage)page));
        statementsToCheck.forEach(statement -> CmCheck.deleteForUserAndStatement((User)user, (CmStatement)statement));
        return CmAccountOverview.redirect((String)referer).flashing(flashType, flashMessage);
    }

    public Result delete(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean allowToDelete = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_DELETE_STATMENTS);
        if (!allowToDelete) {
            return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("cm.deletedAccounts.nopermission", new Object[0]));
        }
        String accountIds = ((DeleteForm)this.formFactory.form(DeleteForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).selectionIds;
        List<Integer> ids = GeneralUtils.getSelectionIds(accountIds);
        HashSet types = new HashSet();
        types.addAll(CmStatement.StatementAndAdviceTypes);
        types.addAll(CmStatement.DtiTypes);
        Update update = DB.createUpdate(CmBalance.class, (String)"DELETE FROM CmBalance WHERE account=:account");
        int counter = 0;
        for (Account account : this.getAccounts(ids, user)) {
            for (CmStatement stmt : CmStatement.findByAccount((Account)account, types, (boolean)true, null, null)) {
                CmDeleter.delete((CmStatement)stmt);
            }
            update.setParameter("account", (Object)account.getId());
            update.execute();
            if (Account.Type.CASH_MANAGEMENT.equals((Object)account.getType()) && CmStatement.findTotalCountForAccount((Account)account) == 0 && Account.canBeDeleted((Account)account)) {
                Logger.logAccountDeleted((User)user, (Account)account);
                Account.delete((Account)account);
            }
            ++counter;
        }
        String flashKey = counter == 0 ? "warning" : "success";
        return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing(flashKey, this.messagesApi.preferred((Http.RequestHeader)request).at("cm.deletedAccounts", new Object[]{counter}));
    }

    private CmFolder getFolder(User user, int folderId) {
        if (folderId == -1) {
            return null;
        }
        if (folderId == -2) {
            return CmFolder.NULL_FOLDER;
        }
        return CmFolder.findById((Integer)folderId, (User)user);
    }

    public Result moveToFolderPost(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form<CmFolderIdForm> form = this.formFactory.form(CmFolderIdForm.class).bindFromRequest(request, new String[0]);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!form.hasErrors()) {
            form = ((CmFolderIdForm)form.get()).validate(form, user);
        }
        if (form.hasErrors()) {
            return this.index(request, null, null, form, null, null);
        }
        String referer = Utils.getHeaderValue(request, "referer");
        CmFolder folder = ((CmFolderIdForm)form.get()).getFolder();
        boolean isNullFolder = CmFolder.NULL_FOLDER.equals(folder);
        String accountIds = ((CmFolderIdForm)form.get()).accountIds;
        List<Integer> ids = GeneralUtils.getSelectionIds(accountIds);
        List<Account> selectedAccounts = this.getAccounts(ids, user);
        ArrayList<String> failedAccounts = new ArrayList<String>();
        int counter = 0;
        for (Account a : selectedAccounts) {
            if (isNullFolder || a.getBank().getTenant().equals(folder.getTenant())) {
                a.setFolder(folder);
                ++counter;
                a.save();
                continue;
            }
            failedAccounts.add(Account.getCmDisplayName((Account)a));
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        String flashKey = counter > 0 ? "success" : "warning";
        String messageKey = isNullFolder ? "cm.movetofolder.done.nullFolder" : "cm.movetofolder.done";
        flashMap.put(flashKey, messages.at(messageKey, new Object[]{counter, folder.getName()}));
        if (!failedAccounts.isEmpty()) {
            StringBuilder failedAccountsString = new StringBuilder();
            for (String account : failedAccounts) {
                if (failedAccountsString.length() > 0) {
                    failedAccountsString.append(", ");
                }
                failedAccountsString.append(account);
            }
            Utils.addToFlash(flashMap, "warning", messages.at("cm.movetofolder.wrongtenant", new Object[]{failedAccounts.size(), failedAccountsString.toString()}));
        }
        return CmAccountOverview.redirect((String)referer).flashing(flashMap);
    }

    public CompletionStage<Result> runExports(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(CmDateRangeForm.class).bindFromRequest(request, new String[0]);
        String referer = Utils.getHeaderValue(request, "referer");
        return CompletableFuture.supplyAsync(() -> {
            if (form.hasErrors()) {
                return CmAccountOverview.redirect((String)referer);
            }
            List<Integer> ids = GeneralUtils.getSelectionIds(((CmDateRangeForm)form.get()).accountIds);
            List<Account> accounts2 = this.getAccounts(ids, user);
            java.sql.Date start = ((CmDateRangeForm)form.get()).fromDate == null ? null : new java.sql.Date(((CmDateRangeForm)form.get()).fromDate.getTime());
            java.sql.Date end = ((CmDateRangeForm)form.get()).toDate == null ? null : new java.sql.Date(((CmDateRangeForm)form.get()).toDate.getTime());
            HashSet statements = new HashSet();
            for (Account account : accounts2) {
                statements.addAll(CmStatement.findByAccount((Account)account, (Set)CmStatement.StatementTypes, (boolean)false, (java.sql.Date)start, (java.sql.Date)end));
            }
            if (statements.isEmpty()) {
                return CmAccountOverview.redirect((String)referer).flashing("info", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.noStatementsFound", (Object[])new Object[0]));
            }
            ArrayList exports = new ArrayList();
            for (Tenant tenant : user.getTenants()) {
                exports.addAll(AutomaticExport.findActive((Tenant)tenant));
            }
            if (exports.isEmpty()) {
                return CmAccountOverview.redirect((String)referer).flashing("info", messages.at("cm.runexports.noexports", new Object[0]));
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                AutomaticExporterApi exporter = new AutomaticExporterApi(exports, new ArrayList(statements), Collections.emptyList(), "", BLLoggerPlay.getLogger(), EncryptData.getInstance(), user);
                exporter.doExport(true);
                if (exporter.getExceptions() != null && !exporter.getExceptions().isEmpty()) {
                    for (Exception e : exporter.getExceptions()) {
                        Utils.addToFlash(hashMap, "error", e.toString());
                    }
                } else {
                    hashMap.put("success", messages.at("cm.runexports.success", new Object[]{statements.size(), exports.size()}));
                }
            }
            catch (Exception e) {
                return CmAccountOverview.redirect((String)referer).flashing("error", e.toString()).flashing(hashMap);
            }
            return CmAccountOverview.redirect((String)referer).flashing(hashMap);
        }, this.executionContext.current());
    }

    public static boolean areAnyAutomaticExports(User user) {
        for (Tenant tenant : user.getTenants()) {
            if (AutomaticExport.findActive((Tenant)tenant).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompletionStage<Result> print(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(CmDateRangeForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            if (form.hasErrors()) {
                return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index());
            }
            List<Account> accounts2 = this.getAccounts(GeneralUtils.getSelectionIds(((CmDateRangeForm)form.get()).accountIds), user);
            Date start = ((CmDateRangeForm)form.get()).fromDate;
            Date end = ((CmDateRangeForm)form.get()).toDate;
            return this.directStatementPdfExport(accounts2, start, end, user, messages);
        }, this.executionContext.current());
    }

    public CompletionStage<Result> printOverview(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
        String accountIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        return CompletableFuture.supplyAsync(() -> {
            List<CMAccount> accountsToPrint;
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_STATEMENT);
            CmFolder folder = this.getFolder(user, Integer.parseInt(sorting.getProperty(PROPS_FOLDER, "-1")));
            if (accountIds == null || accountIds.isEmpty()) {
                accountsToPrint = this.loadAccounts(user, sorting, folder);
            } else {
                accountsToPrint = new ArrayList<CMAccount>();
                for (Account a : this.getAccounts(GeneralUtils.getSelectionIds(accountIds), user)) {
                    accountsToPrint.add(new CMAccount(a, user));
                }
            }
            String accountGroupName = folder != null ? folder.getName() : null;
            HashMap<String, String> flashMap = new HashMap<String, String>();
            try {
                File temp = Util.createTempFile((String)"cm_acc_overview", (String)".pdf", (boolean)true);
                FileOutputStream fos = new FileOutputStream(temp);
                boolean printLogo = GeneralUtils.printLogo(user);
                String[] additionalFooter = Branding.getBranding().getPrintedStatementFooter();
                BLDocument document = Util.createBLDocument((OutputStream)fos, (BLDocument.PageLayout)BLDocument.PageLayout.A4_LANDSCAPE, (String)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountOverview", (Object[])new Object[0]), (boolean)printLogo, (Locale)messages.lang().locale(), (additionalFooter != null ? 1 : 0) != 0);
                PrintBaseAction.addAccountTable((BLDocument)document, accountsToPrint, (String)accountGroupName, (Locale)messages.lang().locale(), (DatabasePreferenceStore)store);
                document.close();
                fos.close();
                String footer1 = additionalFooter != null && additionalFooter.length > 0 ? additionalFooter[0] : null;
                String footer2 = additionalFooter != null && additionalFooter.length > 1 ? additionalFooter[1] : null;
                Util.applyPreferencesToPdf((File)temp, (User)user, null, (Locale)messages.lang().locale(), (String)footer1, (String)footer2, (boolean)printLogo);
                return GeneralUtils.supplyWorkspaceFile(temp, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountOverview", (Object[])new Object[0]) + ".pdf"));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.warning("An exception occurred while trying to print cm overview!", e);
                flashMap.put("error", messages.at("cm.error.printUnsuccessful", new Object[0]));
                return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing(flashMap);
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> exportOverview(Http.Request request) {
        String accountIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<CMAccount> accountsToExport;
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            if (accountIds == null || accountIds.isEmpty()) {
                SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_STATEMENT);
                int folderId = Integer.parseInt(sorting.getProperty(PROPS_FOLDER, "-1"));
                accountsToExport = this.loadAccounts(user, sorting, this.getFolder(user, folderId));
            } else {
                List<Integer> ids = GeneralUtils.getSelectionIds(accountIds);
                List<Account> accounts2 = this.getAccounts(ids, user);
                accountsToExport = new ArrayList();
                for (Account a : accounts2) {
                    accountsToExport.add(new CMAccount(a, user));
                }
            }
            return this.createCSV(request, accountsToExport);
        }, this.executionContext.current());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result createCSV(Http.Request request, Collection<CMAccount> accountsToExport) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        try {
            File tmpFile = Util.createTempFile((String)"cm_acc_overview", (String)".csv", (boolean)true);
            OutputStream outputStream = EncryptData.getInstance().openOutputStream(tmpFile);
            try {
                new CmOverviewCsvExport(messages.lang().locale()).write(outputStream, accountsToExport);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    BLLoggerPlay.warning("Failed to close output stream on temporary file " + tmpFile.getAbsolutePath() + "!", e);
                }
            }
            return GeneralUtils.supplyWorkspaceFile(tmpFile, false, true).as("text/comma-separated-values").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountOverview", (Object[])new Object[0]) + ".csv"));
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.warning("CSV export of statement(s) failed!", e);
            flashMap.put("error", messages.at("cm.error.exportUnsuccessful", new Object[0]));
            return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing(flashMap);
        }
    }

    private List<Account> getAccounts(List<Integer> accountIds, User user) {
        boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        return Account.findAllowedAccountsByIds(accountIds, (User)user, (boolean)checkPermission);
    }

    private Map<BankSettings, Set<Account>> splitPerBank(Collection<Account> accounts2) {
        HashMap<BankSettings, Set<Account>> map = new HashMap<BankSettings, Set<Account>>();
        if (accounts2 != null) {
            for (Account account : accounts2) {
                BankSettings bank = account.getBank();
                Set set = map.computeIfAbsent(bank, k -> new HashSet());
                set.add(account);
            }
        }
        return map;
    }

    public Result importStatementsForm(Http.Request request) {
        return CmAccountOverview.ok((Content)importstatementsform.render((Form<ImportStatementsForm>)this.formFactory.form(ImportStatementsForm.class), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public CompletionStage<Result> importStatements(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(ImportStatementsForm.class).bindFromRequest(request, new String[0]);
        Http.MultipartFormData fileFormData = request.body().asMultipartFormData();
        List fileParts = fileFormData.getFiles();
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            if (form.hasErrors()) {
                return CmAccountOverview.ok((Content)importstatementsform.render((Form<ImportStatementsForm>)form, request, messages));
            }
            ImportStatementsForm importObject = (ImportStatementsForm)form.get();
            ArrayList<File> files = new ArrayList<File>();
            for (Http.MultipartFormData.FilePart part : fileParts) {
                File file2 = ((Files.TemporaryFile)part.getRef()).path().toFile();
                if (file2.length() <= 0L) continue;
                files.add(file2);
            }
            String error = importObject.importAll(user, files, messages);
            if (error != null) {
                return CmAccountOverview.ok((Content)importstatementsform.render((Form<ImportStatementsForm>)form.withGlobalError(error), request, messages));
            }
            CmReporterApi reporter = importObject.getReporter();
            return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("success", messages.at("cm.import.success", new Object[]{files.size(), reporter.getNewStatementsCount()}));
        }, this.executionContext.current());
    }

    public CompletionStage<Result> exportAccounts(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(CmExportForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            Form formWithoutErrors = form;
            if (form.hasErrors()) {
                if (((CmExportForm)form.discardingErrors().get()).isExportAll()) {
                    boolean hasRealErrors = false;
                    for (ValidationError error : form.errors()) {
                        if (error.key().equals("toDate") || error.key().equals("fromDate")) continue;
                        hasRealErrors = true;
                        break;
                    }
                    if (!hasRealErrors) {
                        formWithoutErrors = form.discardingErrors();
                    }
                }
                if (formWithoutErrors.hasErrors()) {
                    return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("warning", messages.at("cm.export.exported", new Object[]{0}));
                }
            }
            Conversion conversion = ((CmExportForm)formWithoutErrors.get()).getConversion(user);
            try {
                if (conversion != null) {
                    File tmpFile = Util.createTempFile((String)"export", (String)"tmp", (boolean)true);
                    Converter converter = new Converter(conversion, tmpFile, true, new DatabasePreferenceStore(Preference.ApplicationId.CM, user), messages.lang().toLocale());
                    for (Account account : Account.findAllowedAccountsByIds(GeneralUtils.getSelectionIds(((CmExportForm)formWithoutErrors.get()).exportIds), (User)user, (boolean)true)) {
                        converter.convert(new CMAccount(account, user), (StatementsPeriodProvider)formWithoutErrors.get());
                    }
                    return CmAccountOverview.ok((File)tmpFile).as("text/csv").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(conversion.getName()));
                }
                List accounts2 = Account.findAllowedAccountsByIds(GeneralUtils.getSelectionIds(((CmExportForm)formWithoutErrors.get()).exportIds), (User)user, (boolean)true);
                java.sql.Date fromDate = ((CmExportForm)formWithoutErrors.get()).getStatementsPeriodStartDate();
                java.sql.Date toDate = ((CmExportForm)formWithoutErrors.get()).getStatementsPeriodEndDate();
                if (((CmExportForm)formWithoutErrors.get()).isPdfExport()) {
                    Date start = null;
                    if (fromDate != null) {
                        start = new Date(fromDate.getTime());
                    }
                    Date end = null;
                    if (toDate != null) {
                        end = new Date(toDate.getTime());
                    }
                    return this.directStatementPdfExport(accounts2, start, end, user, messages);
                }
                ArrayList<CmStatement> statementsToExport = new ArrayList<CmStatement>();
                for (Account account : accounts2) {
                    PagedList list;
                    int page = 0;
                    do {
                        list = CmStatement.findStatements((Account)account, (int)page++, (int)100, (boolean)true, (java.sql.Date)fromDate, (java.sql.Date)toDate);
                        statementsToExport.addAll(list.getList());
                    } while (list.hasNext());
                }
                if (statementsToExport.size() == 0) {
                    return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("warning", messages.at("cm.export.exported", new Object[]{0}));
                }
                return this.directStatementExport(statementsToExport, user);
            }
            catch (InvalidPasswordException | IOException e) {
                BLLoggerPlay.warning("CSV export of statement(s) failed!", e);
                Utils.addToFlash(flashMap, "error", messages.at("cm.error.exportUnsuccessful", new Object[0]));
                Utils.addToFlash(flashMap, "warning", messages.at("cm.export.exported", new Object[]{0}));
                return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing(flashMap);
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> exportStatements(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(BookingExportForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            if (form.hasErrors()) {
                return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("warning", messages.at("cm.export.exported", new Object[]{0}));
            }
            Conversion conversion = ((BookingExportForm)form.get()).getConversion(user);
            List<Integer> ids = GeneralUtils.getSelectionIds(((BookingExportForm)form.get()).exportIds);
            List statementsToExport = DB.find(CmStatement.class).where().in("id", ids).findList();
            if (statementsToExport.size() == 0) {
                return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("warning", messages.at("cm.export.exported", new Object[]{0}));
            }
            try {
                if (conversion != null) {
                    File tmpFile = Util.createTempFile((String)"export", (String)"tmp", (boolean)true);
                    Converter converter = new Converter(conversion, tmpFile, true, new DatabasePreferenceStore(Preference.ApplicationId.CM, user), messages.lang().toLocale());
                    for (CmStatement statement : statementsToExport) {
                        converter.convert(statement);
                    }
                    return CmAccountOverview.ok((File)tmpFile).as("text/csv").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(conversion.getName()));
                }
                if (((BookingExportForm)form.get()).isPdfExport()) {
                    Integer accountId = GeneralUtils.getSingleSelectionId(((BookingExportForm)form.get()).accountId);
                    Integer statementId = GeneralUtils.getSingleSelectionId(((BookingExportForm)form.get()).exportIds);
                    Integer cmPageId = null;
                    if (((BookingExportForm)form.get()).cmPageId != null && !((BookingExportForm)form.get()).cmPageId.isEmpty()) {
                        cmPageId = GeneralUtils.getSingleSelectionId(((BookingExportForm)form.get()).cmPageId);
                    }
                    if (cmPageId != null) {
                        return CmAccountOverview.redirect((Call)routes.Bookings.printPage(accountId, null, statementId, cmPageId));
                    }
                    return CmAccountOverview.redirect((Call)routes.Bookings.printStatement(accountId, null, statementId));
                }
                return this.directStatementExport(statementsToExport, user);
            }
            catch (InvalidPasswordException | IOException e) {
                BLLoggerPlay.warning("Export of booking(s) failed!", e);
                return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("error", messages.at("cm.error.exportUnsuccessful", new Object[0]));
            }
        }, this.executionContext.current());
    }

    private Result directStatementPdfExport(List<Account> accounts2, Date start, Date end, User user, Messages messages) {
        HashMap<String, String> flashMap = new HashMap<String, String>();
        try {
            if (new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.PRINT_SEPARATELY_PER_BANK)) {
                ArrayList<File> fileList = new ArrayList<File>();
                for (Set<Account> s : this.splitPerBank(accounts2).values()) {
                    File file2 = CmUtils.printAccounts(s, start, end, user, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatement", (Object[])new Object[0]), messages.lang().locale());
                    if (file2 == null) continue;
                    fileList.add(file2);
                }
                if (fileList.size() == 0) {
                    return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("warning", messages.at("cm.print.nothingtoprint", new Object[0]));
                }
                if (fileList.size() == 1) {
                    return GeneralUtils.supplyWorkspaceFile((File)fileList.get(0), true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatement", (Object[])new Object[0]) + ".pdf"));
                }
                return GeneralUtils.supplyZipFile(fileList, true, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatement", (Object[])new Object[0]) + ".zip"));
            }
            File temp = CmUtils.printAccounts(accounts2, start, end, user, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatement", (Object[])new Object[0]), messages.lang().locale());
            if (temp == null) {
                return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing("warning", messages.at("cm.print.nothingtoprint", new Object[0]));
            }
            return GeneralUtils.supplyWorkspaceFile(temp, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatement", (Object[])new Object[0]) + ".pdf"));
        }
        catch (Exception e) {
            if (e.getMessage().contains("The document has no pages.")) {
                flashMap.put("warning", messages.at("cm.print.nopages", new Object[]{accounts2.size()}));
            } else {
                flashMap.put("error", messages.at("cm.error.printUnsuccessful", new Object[0]));
            }
            BLLoggerPlay.warning("An exception occurred during printing", e);
            return CmAccountOverview.redirect((Call)routes.CmAccountOverview.index()).flashing(flashMap);
        }
    }

    private Result directStatementExport(List<CmStatement> statementsToExport, User user) throws InvalidPasswordException, IOException {
        File stmtFile;
        ArrayList<File> filesToExport = new ArrayList<File>();
        boolean batchedTransactionFiles = false;
        boolean allFilesAreMT940 = true;
        for (CmStatement statement : statementsToExport) {
            if (statement.getFile() == null) {
                for (CmPage page : CmPage.findByStatement((CmStatement)statement, (boolean)false)) {
                    filesToExport.add(WorkspaceFileSystem.getFile((WorkspaceFile)page.getFile()));
                }
            } else {
                filesToExport.add(WorkspaceFileSystem.getFile((WorkspaceFile)statement.getFile()));
            }
            batchedTransactionFiles |= statement.isDtiFile();
            allFilesAreMT940 = allFilesAreMT940 && statement.isStatement() && statement.isMT94xFormat();
        }
        if (filesToExport.size() == 1) {
            stmtFile = (File)filesToExport.get(0);
            String originalFileName = stmtFile.getName();
            String[] fileNameParts = originalFileName.split("\\.");
            String fileExtension = fileNameParts[fileNameParts.length - 1];
            return CmAccountOverview.ok((InputStream)EncryptData.getInstance().openInputStream(stmtFile)).as("text/" + fileExtension).withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(originalFileName));
        }
        if (allFilesAreMT940) {
            stmtFile = Util.createTempFile((String)"MT940", (String)".STA", (boolean)true);
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(stmtFile));
            for (File file2 : filesToExport) {
                InputStream in = EncryptData.getInstance().openInputStream(file2);
                Streams.copy((InputStream)in, (OutputStream)bout, (boolean)false);
                in.close();
            }
            bout.close();
            return CmAccountOverview.ok((File)stmtFile).as("text/mt940").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("MT940.STA"));
        }
        EncryptData encrypt = EncryptData.getInstance();
        File zipFile = Util.createTempFile((String)"export", (String)"tmp", (boolean)true);
        boolean convertEbcdicToAscii = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.CONVERT_EBCDIC_TO_ASCII);
        BLLogger logger = BLLoggerPlay.getLogger();
        StatementExporter.doZipExport((EncryptData)encrypt, (File)zipFile, (boolean)false, filesToExport, (boolean)batchedTransactionFiles, (boolean)convertEbcdicToAscii, (BLLogger)logger);
        return CmAccountOverview.ok((File)zipFile).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("statements.zip"));
    }

    public Result getBalanceSums(Http.Request request, String selectedAccountIds) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (selectedAccountIds == null || user == null) {
            return CmAccountOverview.badRequest();
        }
        try {
            ObjectNode resultJson = Json.newObject();
            List<Integer> accountIds = GeneralUtils.getSelectionIds(selectedAccountIds);
            List accounts2 = Account.findAllowedAccountsByIds(accountIds, (User)user, (boolean)true);
            if (accounts2.isEmpty()) {
                return CmAccountOverview.ok((String)Json.asciiStringify((JsonNode)resultJson));
            }
            ArrayList<CMAccount> cmaccounts = new ArrayList<CMAccount>();
            for (Account account : accounts2) {
                int countStatements = CmStatement.findCountStatementsAndAdvices((Account)account, null, null);
                if (countStatements <= 0) continue;
                cmaccounts.add(new CMAccount(account, user));
            }
            if (cmaccounts.isEmpty()) {
                return CmAccountOverview.ok((String)Json.asciiStringify((JsonNode)resultJson));
            }
            DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
            BalanceSumHandler balanceSumHandler = new BalanceSumHandler(cmaccounts, preferences2.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.BALANCES_WITH_ADVICE_INFO), messages.lang().locale());
            for (Currency currency : balanceSumHandler.getCurrencies()) {
                ObjectNode currencyNode = resultJson.putObject(currency.getCurrencyCode());
                currencyNode.put("valueBalance", balanceSumHandler.getVbBalanceString(currency));
                currencyNode.put("bookingBalance", balanceSumHandler.getBookingBalanceString(currency));
            }
            return CmAccountOverview.ok((String)Json.asciiStringify((JsonNode)resultJson));
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Failed to calculate balance sums for account IDs '" + selectedAccountIds + "'", e);
            return CmAccountOverview.badRequest();
        }
    }
}

