/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.Banks;
import controllers.util.BLLoggerPlay;
import controllers.util.EbicsUtil;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.ClusterNode;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.transfer.api.FetchScheduler;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.stream.Collectors;
import play.i18n.Messages;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import play.libs.ws.WSResponse;
import views.Utils;

public class ClusterFetchScheduler {
    private final WSClient wsClient;

    public ClusterFetchScheduler(WSClient wsClient) {
        this.wsClient = wsClient;
    }

    public Map<String, String> fetchNow(List<Integer> ids, Messages messages) {
        int nSuccessful = 0;
        int nFailedNoUser = 0;
        int nFailedDeactivated = 0;
        int nFailedErrors = 0;
        HashMap<Integer, ScheduledFuture> futures = new HashMap<Integer, ScheduledFuture>();
        HashMap<String, String> flashMap = new HashMap<String, String>();
        StringBuilder errorMessages = new StringBuilder();
        for (int i : ids) {
            BankUser bankUser;
            Scheduler scheduler = Scheduler.findById((int)i);
            if (FetchScheduler.assignActiveBankUser((Scheduler)scheduler) == null) {
                List iniBankUsers = BankUser.findForBankAndStates((BankSettings)scheduler.getBank(), (BankUser.UserState[])new BankUser.UserState[]{BankUser.UserState.CREATED}).stream().filter(u -> !u.isDeactivated()).collect(Collectors.toList());
                for (BankUser iniUser : iniBankUsers) {
                    try {
                        Future<Boolean> future = Banks.updateHTD(iniUser, null);
                        future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        continue;
                    }
                    if (FetchScheduler.assignActiveBankUser((Scheduler)scheduler) == null) continue;
                    break;
                }
            }
            if ((bankUser = scheduler.getBankUser()) == null) {
                ++nFailedNoUser;
                continue;
            }
            if (!BankUtils.isReady((BankUser)bankUser)) {
                ++nFailedDeactivated;
                continue;
            }
            try {
                futures.put(scheduler.getId(), FetchScheduler.fetchNow((Scheduler)scheduler, (EbicsWorker)EbicsUtil.getEbicsWorker(scheduler.getBankUser())));
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("An error occurred while trying to fetch data from bank", e);
                Utils.addToFlash(flashMap, "HTMLerror", messages.at("fetchschedule.error.fetched", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }
        for (Integer schedulerId : futures.keySet()) {
            try {
                List result = (List)((ScheduledFuture)futures.get(schedulerId)).get();
                if (result != null && !result.isEmpty()) {
                    ++nSuccessful;
                    continue;
                }
                Scheduler s = Scheduler.findById((int)schedulerId);
                if (s.getError() != null) {
                    errorMessages.append(s.getError());
                    errorMessages.append("\n");
                    ++nFailedErrors;
                    continue;
                }
                ++nSuccessful;
            }
            catch (InterruptedException | RuntimeException | ExecutionException e) {
                ++nFailedErrors;
                Throwable t = e instanceof ExecutionException ? e.getCause() : e;
                BLLoggerPlay.error("An error occurred while trying to fetch data from bank", t);
                Utils.addToFlash(flashMap, "HTMLerror", messages.at("fetchschedule.error.fetched", new Object[]{Utils.getLocalizedMessage(t, messages)}));
            }
        }
        if (nSuccessful > 0) {
            flashMap.put("success", messages.at("fetchschedule.success.fetched", new Object[]{nSuccessful}));
        }
        if (nFailedErrors > 0) {
            Utils.addToFlash(flashMap, "warning", messages.at("fetchschedule.warning.notFetched", new Object[]{nFailedErrors, errorMessages}));
        }
        if (nFailedNoUser > 0) {
            Utils.addToFlash(flashMap, "warning", messages.at("fetchschedule.warning.notFetched", new Object[]{nFailedNoUser, messages.at("fetchschedule.warning.notFetched.noUser", new Object[0])}));
        }
        if (nFailedDeactivated > 0) {
            Utils.addToFlash(flashMap, "warning", messages.at("fetchschedule.warning.notFetched", new Object[]{nFailedNoUser, messages.at("fetchschedule.warning.notFetched.bankUserDeactivated", new Object[0])}));
        }
        return flashMap;
    }

    public void updateScheduler(Scheduler scheduler) {
        if (WorkspaceFileSystem.MY_NODE == null || WorkspaceFileSystem.MY_NODE.isPrimary()) {
            FetchScheduler.fetch((Scheduler)scheduler, EbicsUtil::silentGetEbicsWorker);
        } else {
            ClusterNode primary = ClusterNode.getPrimary();
            String url = primary.getBaseURL();
            WSRequest request = this.wsClient.url(url + "/cluster/scheduler/update/" + scheduler.getId());
            request.addHeader("secret", primary.getSecret());
            request.execute("GET").toCompletableFuture();
        }
    }

    public void remove(List<Scheduler> schedulers) {
        for (Scheduler s : schedulers) {
            FetchScheduler.remove((int)s.getId());
            s.delete();
        }
        if (WorkspaceFileSystem.MY_NODE != null && !WorkspaceFileSystem.MY_NODE.isPrimary()) {
            ClusterNode primary = ClusterNode.getPrimary();
            String url = primary.getBaseURL();
            StringBuilder ids = new StringBuilder();
            for (Scheduler s : schedulers) {
                ids.append(s.getId());
                ids.append(',');
            }
            WSRequest request = this.wsClient.url(url + "/cluster/scheduler/remove");
            request.addHeader("secret", primary.getSecret());
            request.addHeader("ids", ids.toString());
            request.execute("GET").toCompletableFuture();
        }
    }

    public Map<Scheduler, Date> buildNextScheduleMap(List<Scheduler> list) {
        if (WorkspaceFileSystem.MY_NODE == null || WorkspaceFileSystem.MY_NODE.isPrimary()) {
            HashMap<Scheduler, Date> toReturn = new HashMap<Scheduler, Date>();
            for (Scheduler s : list) {
                toReturn.put(s, FetchScheduler.nextFetch((int)s.getId()));
            }
            return toReturn;
        }
        try {
            HashMap<Integer, Scheduler> map = new HashMap<Integer, Scheduler>();
            StringBuilder ids = new StringBuilder();
            for (Scheduler s : list) {
                ids.append(s.getId());
                ids.append(',');
                map.put(s.getId(), s);
            }
            ClusterNode primary = ClusterNode.getPrimary();
            String url = primary.getBaseURL();
            WSRequest request = this.wsClient.url(url + "/cluster/scheduler");
            request.addHeader("secret", primary.getSecret());
            request.addHeader("ids", ids.toString());
            WSResponse response = (WSResponse)request.execute("GET").toCompletableFuture().get();
            HashMap<Scheduler, Date> toReturn = new HashMap<Scheduler, Date>();
            if (response.getStatus() == 200) {
                String dates = response.getBody();
                Scanner s = new Scanner(dates);
                s.useDelimiter(";");
                while (s.hasNext()) {
                    Scheduler scheduler = (Scheduler)map.get(Integer.parseInt(s.next()));
                    long d = Long.parseLong(s.next());
                    if (d == 0L) {
                        toReturn.put(scheduler, null);
                        continue;
                    }
                    toReturn.put(scheduler, new Date(d));
                }
            }
            return toReturn;
        }
        catch (Exception e) {
            BLLoggerPlay.error("Can not get NextScheduleDates from primary server", e);
            HashMap<Scheduler, Date> toReturn = new HashMap<Scheduler, Date>();
            for (Scheduler s : list) {
                toReturn.put(s, new Date(0L));
            }
            return toReturn;
        }
    }

    public FetchScheduler.QueueStatistics getFetchSchedulerQueueStatistics() {
        if (WorkspaceFileSystem.MY_NODE == null || WorkspaceFileSystem.MY_NODE.isPrimary()) {
            return FetchScheduler.getQueueStatistics();
        }
        ClusterNode primary = ClusterNode.getPrimary();
        String url = primary.getBaseURL();
        WSRequest request = this.wsClient.url(url + "/cluster/scheduler/statistics");
        request.addHeader("secret", primary.getSecret());
        try {
            WSResponse response = (WSResponse)request.execute("GET").toCompletableFuture().get();
            return FetchScheduler.QueueStatistics.fromString((String)response.getBody());
        }
        catch (Exception e) {
            BLLoggerPlay.error("Can not get NumberOfQueued from primary server", e);
            return null;
        }
    }
}

