/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.Setup;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.EbicsUtil;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.ClusterNode;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.banking.transfer.api.FetchScheduler;
import io.ebean.Query;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import models.preferences.EncryptionPreferenceChangedOperation;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import play.libs.ws.WSResponse;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;

public class Cluster
extends Controller {
    private final WSClient wsClient;

    @Inject
    public Cluster(WSClient wsClient) {
        this.wsClient = wsClient;
    }

    private boolean checkSecret(Http.Request request) {
        Optional secret = request.header("secret");
        return secret.isPresent() && WorkspaceFileSystem.MY_NODE.getSecret().equals(secret.get());
    }

    public Result getFile(Http.Request request, int id) {
        File file2;
        WorkspaceFile workspaceFile;
        if (this.checkSecret(request) && (workspaceFile = (WorkspaceFile)DB.find(WorkspaceFile.class, (Object)id)) != null && (file2 = WorkspaceFileSystem.toFile((WorkspaceFile)workspaceFile)).isFile()) {
            return Cluster.ok((File)file2);
        }
        return Cluster.notFound();
    }

    public Result changeEncryption(Http.Request request, Boolean flag) {
        if (this.checkSecret(request)) {
            EncryptionPreferenceChangedOperation.updateEncryption(flag.toString());
            return Cluster.ok((String)"Updated encryption state of all local files.");
        }
        return Cluster.notFound();
    }

    public Result updatePasswordRequirements(Http.Request request) {
        if (this.checkSecret(request)) {
            PasswordRequirement.reloadRequirements();
            User.LIMIT_ERROR_COUNTER = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null).getInt((DatabasePreferenceConstant)PreferenceConstants.PASSWORD_USER_LOCKED);
            return Cluster.ok();
        }
        return Cluster.notFound();
    }

    public Result updateScheduler(Http.Request request, int id) {
        Scheduler scheduler;
        if (this.checkSecret(request) && (scheduler = Scheduler.findById((int)id)) != null) {
            FetchScheduler.fetch((Scheduler)scheduler, EbicsUtil::silentGetEbicsWorker);
            return Cluster.ok();
        }
        return Cluster.notFound();
    }

    public Result removeScheduler(Http.Request request) {
        Optional ids;
        if (this.checkSecret(request) && (ids = request.header("ids")).isPresent()) {
            List<Integer> schedulerIds = GeneralUtils.getSelectionIds((String)ids.get());
            for (Integer id : schedulerIds) {
                FetchScheduler.remove((int)id);
            }
            DB.deleteAll(Scheduler.class, schedulerIds);
            return Cluster.ok();
        }
        return Cluster.notFound();
    }

    public Result getNextSchedulerDates(Http.Request request) {
        Optional ids;
        if (this.checkSecret(request) && (ids = request.header("ids")).isPresent()) {
            List<Integer> schedulerIds = GeneralUtils.getSelectionIds((String)ids.get());
            StringBuilder b = new StringBuilder();
            for (Integer id : schedulerIds) {
                b.append(id);
                b.append(';');
                Date d = FetchScheduler.nextFetch((int)id);
                if (d == null) {
                    b.append("0");
                } else {
                    b.append(d.getTime());
                }
                b.append(';');
            }
            return Cluster.ok((String)b.toString());
        }
        return Cluster.noContent();
    }

    public Result updateCheck(Http.Request request, String newVersion) {
        if (this.checkSecret(request)) {
            Setup.NEW_VERSION = newVersion;
            return Cluster.ok();
        }
        return Cluster.noContent();
    }

    public Result syncWorkspace(Http.Request request, boolean all) throws ExecutionException, InterruptedException {
        ClusterNode myNode = ClusterNode.getThisNode();
        if (myNode == null) {
            new WorkspaceFileSystem.CleanUpScheduler().run();
            BLLoggerPlay.error("only deleted local files that are to be deleted, no cluster found.");
            return Cluster.redirect((Call)routes.Application.index());
        }
        ArrayList<CompletionStage> otherNodes = new ArrayList<CompletionStage>();
        if (all) {
            for (ClusterNode node : DB.find(ClusterNode.class).findList()) {
                if (node.getId().equals(myNode.getId())) continue;
                WSRequest wsRequest = this.wsClient.url(node.getBaseURL() + "/cluster/sync");
                wsRequest.addHeader("secret", node.getSecret());
                otherNodes.add(wsRequest.execute());
            }
        }
        new WorkspaceFileSystem.CleanUpScheduler().run();
        int[] copied = new int[2];
        Query list = WorkspaceFile.findFilesMissingOnNode((ClusterNode)myNode);
        list.findStream().forEach(wf -> {
            if (WorkspaceFileSystem.getFile((WorkspaceFile)wf).isFile()) {
                copied[0] = copied[0] + 1;
            } else {
                copied[1] = copied[1] + 1;
            }
        });
        String msg = "node " + myNode.getBaseURL() + " synchronized " + copied[0] + " files, having " + copied[1] + " errors.";
        BLLoggerPlay.error(msg);
        for (CompletionStage response : otherNodes) {
            WSResponse wsResponse = (WSResponse)response.toCompletableFuture().get();
            BLLoggerPlay.error(wsResponse.getStatus() + " " + wsResponse.getBody());
        }
        if (all) {
            return Cluster.redirect((Call)routes.Application.index());
        }
        return Cluster.ok((String)msg);
    }

    public Result getSchedulerStatistics(Http.Request request) {
        if (this.checkSecret(request)) {
            return Cluster.ok((String)FetchScheduler.getQueueStatistics().toString());
        }
        return Cluster.noContent();
    }
}

