/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmCheck;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.User;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class CheckedState {
    private final User user;
    private final HashSet<Integer> statementIds = new HashSet();
    private final HashSet<Integer> pageIds = new HashSet();
    private final Integer accountId;
    private final boolean markAccountAsRead;

    public CheckedState(User user, CmStatement statement, CmPage page, List<CmBooking> bookings2, Integer accountId) {
        this.user = user;
        this.markAccountAsRead = statement == null && accountId != null && accountId > 0;
        this.accountId = accountId;
        HashMap<Integer, CmStatement> statementIds = new HashMap<Integer, CmStatement>();
        HashMap<Integer, CmPage> pageIds = new HashMap<Integer, CmPage>();
        if (statement != null) {
            statementIds.put(statement.getId(), statement);
        }
        if (page != null) {
            pageIds.put(page.getId(), page);
        }
        for (CmBooking booking : bookings2) {
            CmPage bookingPage = booking.getPage();
            if (bookingPage != null) {
                pageIds.put(bookingPage.getId(), bookingPage);
            }
            statementIds.put(booking.getStatement().getId(), booking.getStatement());
        }
        for (CmStatement s : statementIds.values()) {
            if (!CmCheck.isChecked((User)user, (CmStatement)s)) continue;
            this.statementIds.add(s.getId());
        }
        for (CmPage p : pageIds.values()) {
            if (!CmCheck.isChecked((User)user, (CmPage)p)) continue;
            this.pageIds.add(p.getId());
        }
    }

    public boolean isNewBooking(CmBooking b) {
        if (b.getPage() != null) {
            return this.pageIds.contains(b.getPage().getId());
        }
        return this.statementIds.contains(b.getStatement().getId());
    }

    public void markAsRead() {
        if (!this.statementIds.isEmpty()) {
            CmCheck.deleteForUserAndStatement((User)this.user, this.statementIds);
        }
        if (!this.pageIds.isEmpty()) {
            CmCheck.deleteForUserAndPage((User)this.user, this.pageIds);
        }
        if (this.accountId != null && this.accountId > 0 && this.markAccountAsRead) {
            CmCheck.deleteForUserAndAccountId((User)this.user, (Integer)this.accountId);
        }
    }
}

