/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.pekko.stream.Materializer;
import play.mvc.Filter;
import play.mvc.Http;
import play.mvc.Result;

public class CacheFilter
extends Filter {
    public static String prefixToIgnore = "/assets";

    @Inject
    public CacheFilter(Materializer mat) {
        super(mat);
    }

    public CompletionStage<Result> apply(Function<Http.RequestHeader, CompletionStage<Result>> next, Http.RequestHeader rh) {
        if (rh.uri().startsWith(prefixToIgnore)) {
            return next.apply(rh).thenApply(result -> result.withHeader("Cache-Control", "max-age=86400"));
        }
        return next.apply(rh).thenApply(result -> result.withHeader("Cache-Control", "no-cache, no-store, must-revalidate, pre-check=0, post-check=0, max-age=0, s-maxage=0"));
    }
}

