/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Authenticator;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.FetchParameterUtil;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.sepa.SepaSchemeHandler;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;

@Security.Authenticated(value=Authenticator.class)
public class BtfUtils
extends Controller {
    public static final String INVALID_BTF = "invalidBtf";
    public static final String INVALID_PMT_TYPES = "Invalid payment types";
    public static final String NO_PMT_TYPES = "No payment types provided";
    public static final String DEFAULT_BTF_FOR_PMT_TYPE = "DEFAULT";
    public static final String FETCH_TYPE_STATEMENTS = "statements";
    public static final String FETCH_TYPE_ADVICES = "advices";
    public static final String FETCH_TYPE_CREDIT_ADVICES = "creditAdvicesForInstantTransfers";
    public static final String FETCH_TYPE_BATCHED = "batchedTransactions";
    public static final String FETCH_TYPE_BKA = "bka";
    public static final String FETCH_TYPE_BKI = "bki";
    public static final String FETCH_TYPE_NOTIFICATIONS = "notificationsSepa";
    public static final String FETCH_TYPE_NOTIFICATIONS_INSTANT = "notificationsSepaInstant";
    public static final String FETCH_TYPE_NOTIFICATIONS_DEBIT = "notificationsSepaDEBIT";
    public static final String FETCH_TYPE_NOTIFICATIONS_CALLBACK = "notificationsSepaCallback";
    public static final String FETCH_TYPE_NOTIFICATIONS_FOREIGN = "notificationsSepaForeign";
    public static final String FETCH_TYPE_NOTIFICATIONS_VOP = "notificationsVop";
    private static final Pattern ALPHANUMERIC_UPPER = Pattern.compile("[\\p{Upper}\\p{Digit}]");
    public static final Pattern SERVICE_NAME_PATTERN = Pattern.compile("(" + String.valueOf(ALPHANUMERIC_UPPER) + "{3})");
    public static final Pattern MESSAGE_PATTERN = Pattern.compile("([\\p{Lower}\\p{Digit}.]{1,10})");
    public static final Pattern SCOPE_PATTERN = Pattern.compile("(" + String.valueOf(ALPHANUMERIC_UPPER) + "{2,3})");
    public static final Pattern SERVICE_OPTION_PATTERN = Pattern.compile("(" + String.valueOf(ALPHANUMERIC_UPPER) + "{3,10})");
    public static final Pattern VARIANT_PATTERN = Pattern.compile("(\\d{3})");
    public static final Pattern VERSION_PATTERN = Pattern.compile("(\\d{2})");
    public static final Pattern FORMAT_PATTERN = Pattern.compile("(" + String.valueOf(ALPHANUMERIC_UPPER) + "{1,4})");

    private static String getDefaultBtfString(String forType, BankSettings bank) {
        if (forType == null || forType.isEmpty()) {
            return "";
        }
        boolean isVopType = forType.endsWith("_VOP");
        if (isVopType) {
            forType = forType.substring(0, forType.length() - 4);
        }
        return switch (forType) {
            case FETCH_TYPE_STATEMENTS -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)CMBank.getStatementType((CMBank.StatementFormat)CMBank.get((BankSettings)bank).getStatementFormat()), (boolean)true, (String)bank.getCountryCode());
            case FETCH_TYPE_ADVICES -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)CMBank.getStatementType((CMBank.AdviceFormat)CMBank.get((BankSettings)bank).getAdviceFormat()), (boolean)true, (String)bank.getCountryCode());
            case FETCH_TYPE_CREDIT_ADVICES -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.camt054CreditAdvice, (boolean)true, (String)bank.getCountryCode());
            case FETCH_TYPE_BATCHED -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.camt054, (boolean)true, (String)bank.getCountryCode());
            case FETCH_TYPE_BKA -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.pdfStatement, (boolean)true, (String)bank.getCountryCode());
            case FETCH_TYPE_BKI -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.otherPdfDocument, (boolean)true, (String)bank.getCountryCode());
            case FETCH_TYPE_NOTIFICATIONS -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.pain002ReportSCT, (boolean)true, (String)bank.getCountryCode());
            case FETCH_TYPE_NOTIFICATIONS_INSTANT -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.pain002ReportSCI, (boolean)true, (String)bank.getCountryCode());
            case FETCH_TYPE_NOTIFICATIONS_DEBIT -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.pain002ReportSDD, (boolean)true, (String)bank.getCountryCode());
            case FETCH_TYPE_NOTIFICATIONS_CALLBACK -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.camt029Report, (boolean)true, (String)bank.getCountryCode());
            case FETCH_TYPE_NOTIFICATIONS_FOREIGN -> FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.pain002ReportAXS, (boolean)true, (String)bank.getCountryCode());
            default -> isVopType ? SendParameters.getBTFVop((BankSettings)bank, (PaymentTransferType.PmtType)PaymentTransferType.PmtType.valueOf((String)forType)) : SendParameters.getBTF((BankSettings)bank, (PaymentTransferType.PmtType)PaymentTransferType.PmtType.valueOf((String)forType));
        };
    }

    private static String getDefaultOrderType(String pmtTypeName) {
        if (pmtTypeName == null || pmtTypeName.isEmpty()) {
            return "";
        }
        return SendParameters.getOrderType(null, (PaymentTransferType.PmtType)PaymentTransferType.PmtType.valueOf((String)pmtTypeName));
    }

    public Result getDefaultSendParams(Http.Request request) {
        ArrayList<String> pmtTypeNames = new ArrayList<String>();
        try {
            JsonNode j = request.body().asJson();
            String countryCode = null;
            JsonNode bankNode = j.get("data");
            if (bankNode != null) {
                if (bankNode.get("country") != null) {
                    countryCode = bankNode.get("country").asText();
                }
                if (bankNode.get("pmtTypes") != null && bankNode.get("pmtTypes").isArray()) {
                    Iterator datelinesIterator = bankNode.get("pmtTypes").elements();
                    while (datelinesIterator.hasNext()) {
                        JsonNode json = (JsonNode)datelinesIterator.next();
                        pmtTypeNames.add(json.get("name").asText());
                    }
                }
            }
            if (pmtTypeNames.isEmpty()) {
                return BtfUtils.badRequest((String)NO_PMT_TYPES);
            }
            ObjectNode resultJson = Json.newObject();
            for (String pmtTypeName : pmtTypeNames) {
                pmtTypeName = pmtTypeName.trim();
                PaymentTransferType.PmtType pmtType = PaymentTransferType.PmtType.valueOf((String)pmtTypeName);
                String defaultOrderType = SendParameters.getDefaultOrderType((PaymentTransferType.PmtType)pmtType, (String)countryCode);
                String defaultOrderTypeVop = SendParameters.getDefaultOrderTypeVop((PaymentTransferType.PmtType)pmtType, (String)countryCode);
                String defaultBtf = SendParameters.getDefaultBTF((PaymentTransferType.PmtType)pmtType, (String)countryCode);
                String defaultBtfVop = SendParameters.getDefaultBTFVop((PaymentTransferType.PmtType)pmtType, (String)countryCode);
                PaymentTransferType.Scheme defaultScheme = SepaSchemeHandler.getDefaultScheme((PaymentTransferType.PmtType)pmtType, (String)countryCode);
                String defaultSchemeName = defaultScheme == null ? "" : defaultScheme.name();
                ObjectNode pmtTypeNode = resultJson.putObject(pmtTypeName);
                pmtTypeNode.put("orderType", defaultOrderType);
                pmtTypeNode.put("orderTypeVop", defaultOrderTypeVop);
                pmtTypeNode.put("btf", defaultBtf);
                pmtTypeNode.put("btfVop", defaultBtfVop);
                pmtTypeNode.put("sepaScheme", defaultSchemeName);
            }
            return BtfUtils.ok((String)Json.asciiStringify((JsonNode)resultJson));
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Failed to determine default send parameters for pmt types '" + Arrays.toString(pmtTypeNames.toArray()) + "'", e);
            return BtfUtils.badRequest((String)("Invalid payment types: " + e.getLocalizedMessage()));
        }
    }

    public Result changeDefaultSendParams(Http.Request request) {
        try {
            JsonNode j = request.body().asJson();
            String oldCountryCode = null;
            String newCountryCode = null;
            ObjectNode resultJson = Json.newObject();
            JsonNode bankNode = j.get("bank");
            if (bankNode != null) {
                if (bankNode.get("oldCountryCode") != null) {
                    oldCountryCode = bankNode.get("oldCountryCode").asText();
                }
                if (bankNode.get("countryCode") != null) {
                    newCountryCode = bankNode.get("countryCode").asText();
                }
                if (bankNode.get("sendParams") != null && bankNode.get("sendParams").isArray()) {
                    Iterator datelinesIterator = bankNode.get("sendParams").elements();
                    while (datelinesIterator.hasNext()) {
                        String defaultBtf;
                        JsonNode json = (JsonNode)datelinesIterator.next();
                        JsonNode param = json.get("sendParam");
                        if (param == null || param.get("pmtType") == null || param.get("orderType") == null || param.get("btf") == null) continue;
                        String type = param.get("pmtType").asText();
                        PaymentTransferType.PmtType pmtType = PaymentTransferType.PmtType.valueOf((String)type);
                        String ot = param.get("orderType").asText();
                        String btf = param.get("btf").asText();
                        String otVop = param.get("orderTypeVop") != null ? param.get("orderTypeVop").asText() : null;
                        String btfVop = param.get("btfVop") != null ? param.get("btfVop").asText() : null;
                        String defaultOrderType = SendParameters.getDefaultOrderType((PaymentTransferType.PmtType)pmtType, (String)oldCountryCode);
                        if (ot.equals(defaultOrderType)) {
                            ot = SendParameters.getDefaultOrderType((PaymentTransferType.PmtType)pmtType, (String)newCountryCode);
                        }
                        String defaultOrderTypeVop = SendParameters.getDefaultOrderTypeVop((PaymentTransferType.PmtType)pmtType, (String)oldCountryCode);
                        if (otVop != null && otVop.equals(defaultOrderTypeVop)) {
                            otVop = SendParameters.getDefaultOrderTypeVop((PaymentTransferType.PmtType)pmtType, (String)newCountryCode);
                        }
                        if (btf.equals(defaultBtf = SendParameters.getDefaultBTF((PaymentTransferType.PmtType)pmtType, (String)oldCountryCode))) {
                            btf = SendParameters.getDefaultBTF((PaymentTransferType.PmtType)pmtType, (String)newCountryCode);
                        }
                        String defaultBtfVop = SendParameters.getDefaultBTFVop((PaymentTransferType.PmtType)pmtType, (String)oldCountryCode);
                        if (btfVop != null && btfVop.equals(defaultBtfVop)) {
                            btfVop = SendParameters.getDefaultBTFVop((PaymentTransferType.PmtType)pmtType, (String)newCountryCode);
                        }
                        ObjectNode pmtTypeNode = resultJson.putObject(type);
                        pmtTypeNode.put("btf", btf);
                        pmtTypeNode.put("btfVop", btfVop);
                        pmtTypeNode.put("orderType", ot);
                        pmtTypeNode.put("orderTypeVop", otVop);
                    }
                }
            }
            return BtfUtils.ok((String)Json.asciiStringify((JsonNode)resultJson));
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Failed to determine default send parameters", e);
            return BtfUtils.badRequest((String)("Invalid payment types: " + e.getLocalizedMessage()));
        }
    }

    public Result mergeBtfString(String serviceName, String serviceOption, String scope, String container, String message, String variant, String version, String format, String emptyAllowed) {
        try {
            StringBuilder errorResponse = new StringBuilder(INVALID_BTF);
            boolean hasError = false;
            if (!(!Boolean.parseBoolean(emptyAllowed) || serviceName != null && !serviceName.trim().isEmpty() || serviceOption != null && !serviceOption.trim().isEmpty() || scope != null && !scope.trim().isEmpty() || container != null && !container.trim().isEmpty() || message != null && !message.trim().isEmpty() || variant != null && !variant.trim().isEmpty() || version != null && !version.trim().isEmpty() || format != null && !format.trim().isEmpty())) {
                return BtfUtils.ok((String)"");
            }
            if (serviceName == null || !SERVICE_NAME_PATTERN.matcher(serviceName = serviceName.toUpperCase(Locale.ROOT)).matches()) {
                hasError = true;
                errorResponse.append("_serviceName");
            }
            if (message == null || !MESSAGE_PATTERN.matcher(message = message.toLowerCase(Locale.ROOT)).matches()) {
                hasError = true;
                errorResponse.append("_message");
            }
            if (scope != null && !scope.isEmpty() && !SCOPE_PATTERN.matcher(scope = scope.toUpperCase(Locale.ROOT)).matches()) {
                hasError = true;
                errorResponse.append("_scope");
            }
            if (serviceOption != null && !serviceOption.isEmpty() && !SERVICE_OPTION_PATTERN.matcher(serviceOption = serviceOption.toUpperCase(Locale.ROOT)).matches()) {
                hasError = true;
                errorResponse.append("_serviceOption");
            }
            if (variant != null && !variant.isEmpty() && !VARIANT_PATTERN.matcher(variant).matches()) {
                hasError = true;
                errorResponse.append("_variant");
            }
            if (version != null && !version.isEmpty() && !VERSION_PATTERN.matcher(version).matches()) {
                hasError = true;
                errorResponse.append("_version");
            }
            if (format != null && !format.isEmpty() && !FORMAT_PATTERN.matcher(format = format.toUpperCase(Locale.ROOT)).matches()) {
                hasError = true;
                errorResponse.append("_format");
            }
            if (hasError) {
                return BtfUtils.badRequest((String)errorResponse.toString());
            }
            return BtfUtils.ok((String)BTFTranslator.convert((String)serviceName, (String)scope, (String)serviceOption, (String)message, (String)variant, (String)version, (String)format, (String)container));
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Failed to generate BTF string for BTF components serviceName='" + serviceName + "' serviceOption='" + serviceOption + "' scope='" + scope + "' container='" + container + "' message='" + message + "' variant='" + variant + "' version='" + version + "' format='" + format + "' ", e);
            return BtfUtils.badRequest((String)INVALID_BTF);
        }
    }

    public Result splitBtfString(String btfString, String fetchTypeOrPmtTypeName, int bankId) {
        if (btfString == null) {
            return BtfUtils.badRequest((String)INVALID_BTF);
        }
        try {
            boolean hasError = false;
            String serviceName = "";
            String serviceOption = "";
            String scope = "";
            String container = "";
            String message = "";
            String variant = "";
            String version = "";
            String format = "";
            BankSettings bank = BankSettings.getById((Integer)bankId);
            if (DEFAULT_BTF_FOR_PMT_TYPE.equals(btfString)) {
                btfString = BtfUtils.getDefaultBtfString(fetchTypeOrPmtTypeName, bank);
            } else if (!btfString.isEmpty() && !BTFTranslator.isBTFString((String)btfString)) {
                BLLoggerPlay.warning("Attempt to split invalid BTF string '" + btfString + "' for type '" + fetchTypeOrPmtTypeName + "', will use default BTF instead.");
                hasError = true;
                btfString = BtfUtils.getDefaultBtfString(fetchTypeOrPmtTypeName, bank);
            }
            if (BTFTranslator.isBTFString((String)btfString)) {
                RestrictedServiceType restrictedServiceType = BTFTranslator.convertFrom((String)btfString);
                if (restrictedServiceType.getServiceName() == null || restrictedServiceType.getMsgName() == null) {
                    return BtfUtils.badRequest((String)INVALID_BTF);
                }
                serviceName = restrictedServiceType.getServiceName().getValue();
                serviceOption = restrictedServiceType.getServiceOption() == null ? "" : restrictedServiceType.getServiceOption().getValue();
                scope = restrictedServiceType.getScope() == null ? "" : restrictedServiceType.getScope().getValue();
                container = restrictedServiceType.getContainer() == null ? "" : restrictedServiceType.getContainer().getContainerType().getValue();
                message = restrictedServiceType.getMsgName().getValue();
                variant = restrictedServiceType.getMsgName().getVariant() == null ? "" : restrictedServiceType.getMsgName().getVariant().getValue();
                version = restrictedServiceType.getMsgName().getVersion() == null ? "" : restrictedServiceType.getMsgName().getVersion().getValue();
                format = restrictedServiceType.getMsgName().getFormat() == null ? "" : restrictedServiceType.getMsgName().getFormat().getValue();
            }
            ObjectNode resultJson = Json.newObject();
            resultJson.put("serviceName", serviceName);
            resultJson.put("serviceOption", serviceOption);
            resultJson.put("scope", scope);
            resultJson.put("container", container);
            resultJson.put("message", message);
            resultJson.put("variant", variant);
            resultJson.put("version", version);
            resultJson.put("format", format);
            if (hasError) {
                return BtfUtils.badRequest((String)Json.asciiStringify((JsonNode)resultJson));
            }
            return BtfUtils.ok((String)Json.asciiStringify((JsonNode)resultJson));
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Failed to split BTF string '" + btfString + "' for type '" + fetchTypeOrPmtTypeName + "'", e);
            return BtfUtils.badRequest((String)INVALID_BTF);
        }
    }
}

