/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.google.common.collect.ImmutableSet;
import controllers.AuthenticatorFor;
import controllers.CheckedState;
import controllers.DatabaseConnection;
import controllers.DtiView;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.BigDecimalFormatter;
import controllers.util.DateFormatter;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmBookingFilter;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Conversion;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.BookingSQLBuilder;
import de.businesslogics.banking.mt940.api.CMAccount;
import de.businesslogics.banking.mt940.api.CMCollection;
import de.businesslogics.banking.mt940.api.CmDeleter;
import de.businesslogics.banking.mt940.api.Converter;
import de.businesslogics.banking.mt940.api.ValueBalanceCalculator;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.persistence.DBType;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.sql.Date;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.BookingFilterForm;
import models.CmDateRangeForm;
import models.CmFolderIdForm;
import models.DeleteForm;
import models.SimpleTextForm;
import models.cm.BookingExportForm;
import models.cm.CmUtils;
import play.data.Form;
import play.data.FormFactory;
import play.data.format.Formatters;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.cm.bookings;

@Security.Authenticated(value=AuthenticatorFor.CM.class)
public class Bookings
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    @Inject
    public Bookings(FormFactory formFactory, Formatters formatters, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        formatters.register(BigDecimal.class, (Formatters.SimpleFormatter)new BigDecimalFormatter());
        formatters.register(java.util.Date.class, (Formatters.SimpleFormatter)new DateFormatter());
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public Result bookings(Http.Request request, Integer accountId, Integer year, Integer statementId, Integer pageId, Integer folderId, String selectedIds) {
        return this.bookingsInternal(request, accountId, year, statementId, pageId, folderId, null, null, null, null, selectedIds);
    }

    private Result bookingsInternal(Http.Request request, Integer accountId, Integer year, Integer statementId, Integer pageId, Integer folderId, Form<BookingFilterForm> bookingFilterForm, Form<CmDateRangeForm> dateRangeForm, Form<CmFolderIdForm> moveToFolderForm, Form<DeleteForm> deleteForm, String selectedIds) {
        ArrayList<CmBooking> cmBookings;
        Object values;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_BOOKING_TREE);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        ArrayList<Account> accs = Account.findAccounts((User)user, null, null, (boolean)checkPermission);
        Account acc = this.checkAccounts(accountId, (List<Account>)accs);
        if (acc == null && accountId != -1) {
            return Bookings.redirect((Call)routes.Bookings.bookings(-1, year, null, null, null, null)).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
        }
        List statements = null;
        CmStatement statement = null;
        List years = null;
        if (acc != null) {
            years = CmStatement.findStatementAndAdvicesYears((Account)acc);
            if (statementId != null && (statement = this.statementForAccountAndId(acc, statementId)) == null) {
                return Bookings.redirect((Call)routes.Bookings.bookings(acc.getId(), year, null, null, null, null)).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
            }
            if (year != null) {
                Calendar c = Calendar.getInstance();
                c.set(year, 0, 1);
                Date fromDate = new Date(c.getTimeInMillis());
                c.set(year, 11, 31);
                Date toDate = new Date(c.getTimeInMillis());
                statements = CmStatement.findStatementsAndAdvices((Account)acc, (int)0, (int)Integer.MAX_VALUE, (boolean)true, (Date)fromDate, (Date)toDate).getList();
            } else {
                statements = CmStatement.findStatementsAndAdvices((Account)acc, (int)0, (int)100, (boolean)true, null, null).getList();
            }
        }
        CmPage cmPage = null;
        List cmPages = null;
        if (statement != null && statement.isHasPages()) {
            cmPages = CmPage.findByStatement((CmStatement)statement, (boolean)false);
            if (pageId != null && (cmPage = this.pageForStmtAndId(statement, pageId)) == null) {
                return Bookings.redirect((Call)routes.Bookings.bookings(acc.getId(), year, statement.getId(), null, null, null)).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
            }
        }
        ArrayList<Account> accsToShow = accs;
        if (folderId != null) {
            CmFolder folder = CmFolder.findById((Integer)folderId, (User)user);
            if (folder == null) {
                return Bookings.redirect((Call)routes.Bookings.bookings(-1, year, null, null, null, null)).flashing("warning", messages.at("balancelists.error.noSuchGroup", new Object[0]));
            }
            accsToShow = new ArrayList<Account>();
            for (Account a : accs) {
                if (!folder.equals(a.getFolder())) continue;
                accsToShow.add(a);
            }
        }
        CmBookingFilter filter = CmBookingFilter.getFilter((User)user);
        if (bookingFilterForm == null) {
            BookingFilterForm data = BookingFilterForm.getData(filter);
            bookingFilterForm = this.formFactory.form(BookingFilterForm.class).fill((Object)data);
        }
        if (!filter.isFilterActive()) {
            filter = null;
        }
        if (dateRangeForm == null) {
            values = new CmDateRangeForm();
            ((CmDateRangeForm)values).fromDate = java.util.Date.from(ZonedDateTime.now().minusMonths(1L).toInstant());
            ((CmDateRangeForm)values).toDate = new java.util.Date();
            ((CmDateRangeForm)values).accountIds = "" + accountId;
            dateRangeForm = this.formFactory.form(CmDateRangeForm.class).fill(values);
        }
        if (moveToFolderForm == null) {
            values = new CmFolderIdForm();
            ((CmFolderIdForm)values).accountIds = "" + accountId;
            moveToFolderForm = this.formFactory.form(CmFolderIdForm.class).fill(values);
        }
        if (deleteForm == null) {
            values = new DeleteForm();
            ((DeleteForm)values).selectionIds = "" + accountId;
            deleteForm = this.formFactory.form(DeleteForm.class).fill(values);
        }
        Form exportForm = this.formFactory.form(BookingExportForm.class).fill((Object)new BookingExportForm());
        Query<CmBooking> q = this.sortedPagedBookings(user, cmPage, statement, acc, accsToShow, filter, sorting.getSortingColumn(-1), sorting.isSortingAscending(false));
        if (year != null && statement == null && statements != null) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (CmStatement s : statements) {
                ids.add(s.getId());
            }
            q.where().in("statement", (Collection)statements);
        }
        if (q != null) {
            sorting.computeForQuery(q);
            try {
                cmBookings = q.findList();
            }
            catch (PersistenceException e) {
                return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.CM_BOOKING_TREE, (Call)routes.Bookings.bookings(accountId, year, statementId, pageId, folderId, selectedIds));
            }
        } else {
            cmBookings = new ArrayList();
            sorting.computeForList(cmBookings);
        }
        CheckedState checkedState = new CheckedState(user, statement, cmPage, cmBookings, accountId);
        return Bookings.ok((Content)bookings.render(acc, accs, year, years, statement, statements, cmPage, cmPages, folderId, cmBookings, sorting, (Form<BookingFilterForm>)bookingFilterForm, filter, (Form<CmDateRangeForm>)dateRangeForm, (Form<CmFolderIdForm>)moveToFolderForm, (Form<DeleteForm>)deleteForm, (Form<BookingExportForm>)exportForm, selectedIds, checkedState, request, messages));
    }

    public Result bookings_sort(Http.Request request, Integer accountId, Integer year, Integer statementId, Integer pageId, Integer folderId, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_BOOKING_TREE).updateSort(sort, asc);
        return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, statementId, pageId, folderId, null));
    }

    public Result bookings_pageSize(Http.Request request, Integer accountId, Integer year, Integer statementId, Integer pageId, Integer folderId, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_BOOKING_TREE).updatePage(page, pageSize);
        return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, statementId, pageId, folderId, null));
    }

    public Result bookings_filterForm(Http.Request request, Integer accountId, Integer year, Integer statementId, Integer pageId, Integer folderId, boolean filterActive, String selectedIds) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        CmBookingFilter filter = CmBookingFilter.getFilter((User)user);
        if (!filterActive) {
            filter.setFilterActive(Boolean.valueOf(false));
            filter.save();
        } else {
            filter.setFilterActive(Boolean.valueOf(true));
            Form filterForm = this.formFactory.form(BookingFilterForm.class).bindFromRequest(request, new String[0]);
            if (filterForm.hasErrors()) {
                Form dateRangeForm = this.formFactory.form(CmDateRangeForm.class).bindFromRequest(request, new String[0]);
                Form moveToFolderForm = this.formFactory.form(CmFolderIdForm.class).bindFromRequest(request, new String[0]);
                Form deleteForm = this.formFactory.form(DeleteForm.class).bindFromRequest(request, new String[0]);
                return this.bookingsInternal(request, accountId, year, statementId, pageId, folderId, (Form<BookingFilterForm>)filterForm, (Form<CmDateRangeForm>)dateRangeForm, (Form<CmFolderIdForm>)moveToFolderForm, (Form<DeleteForm>)deleteForm, selectedIds);
            }
            BookingFilterForm data = (BookingFilterForm)filterForm.get();
            data.saveData(filter);
        }
        return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, statementId, pageId, folderId, null));
    }

    private CmStatement statementForAccountAndId(Account acc, Integer statementId) {
        Expression expr = Expr.eq((String)"account", (Object)acc);
        expr = Expr.and((Expression)expr, (Expression)Expr.eq((String)"id", (Object)statementId));
        return (CmStatement)DB.find(CmStatement.class).where(expr).findOne();
    }

    private CmPage pageForStmtAndId(CmStatement stmt, Integer pageId) {
        Expression expr = Expr.eq((String)"statement", (Object)stmt);
        expr = Expr.and((Expression)expr, (Expression)Expr.eq((String)"id", (Object)pageId));
        return (CmPage)DB.find(CmPage.class).where(expr).findOne();
    }

    private Account checkAccounts(Integer accountId, List<Account> accs) {
        ArrayList<Account> remAccs = new ArrayList<Account>();
        Account acc = null;
        for (Account a : accs) {
            int countStatements;
            if (a.getId().equals(accountId)) {
                acc = a;
            }
            if ((countStatements = CmStatement.findCountStatementsAndAdvices((Account)a, null, null)) != 0) continue;
            remAccs.add(a);
        }
        accs.removeAll(remAccs);
        accs.sort(Comparator.comparing(Account::getDefaultDisplayName));
        return acc;
    }

    private Query<CmBooking> sortedPagedBookings(User user, CmPage cmPage, CmStatement statement, Account acc, List<Account> accsToShow, CmBookingFilter filter, int sort, boolean asc) {
        BookingSQLBuilder sqlBuilder = new BookingSQLBuilder();
        sqlBuilder.setSingleBookingsOnly(new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_SINGLE_BOOKINGS));
        if (cmPage != null) {
            sqlBuilder.addCmPage(cmPage);
        } else if (statement != null) {
            sqlBuilder.addCmStatement(statement);
        } else if (acc != null) {
            sqlBuilder.addCMAccount(new CMAccount(acc, user));
        } else {
            for (Account a : accsToShow) {
                sqlBuilder.addCMAccount(new CMAccount(a, user));
            }
        }
        Expression expr = sqlBuilder.getExpression(filter == null);
        if (expr != null) {
            Expression filterExpr;
            if (filter != null && (filterExpr = filter.getExpression()) != null) {
                expr = Expr.and((Expression)expr, (Expression)filterExpr);
            }
            Query q = DB.find(CmBooking.class).where(expr);
            q.setMaxRows(Sorting.MAX_RESULT_SIZE);
            String dateSortDirection = DBType.PSQL.equals((Object)DatabaseConnection.getInstance().getDbType()) ? (asc ? "ASC NULLS FIRST" : "DESC NULLS LAST") : (asc ? "ASC" : "DESC");
            switch (sort) {
                case 1: {
                    if (asc) {
                        q = q.order("valueDate " + dateSortDirection + ", account.name asc, page.pageNumber asc, pos asc");
                        break;
                    }
                    q = q.order("valueDate " + dateSortDirection + ", account.name desc, page.pageNumber desc, pos desc");
                    break;
                }
                case 2: {
                    if (asc) {
                        q = q.order("counterParty asc, localParty asc");
                        break;
                    }
                    q = q.order("counterParty desc, localParty desc");
                    break;
                }
                case 0: {
                    if (asc) {
                        q = q.order("counterPartyAccountNumber asc, counterPartyBankCode asc");
                        break;
                    }
                    q = q.order("counterPartyAccountNumber desc, counterPartyBankCode desc");
                    break;
                }
                case 3: {
                    if (asc) {
                        q = q.order("purposeOverview asc");
                        break;
                    }
                    q = q.order("purposeOverview desc");
                    break;
                }
                case 9: {
                    if (asc) {
                        q = q.order("additionalInformation asc, additionalInformation asc");
                        break;
                    }
                    q = q.order("additionalInformation desc, additionalInformation desc");
                    break;
                }
                case 4: {
                    if (asc) {
                        q = q.order("amount asc");
                        break;
                    }
                    q = q.order("amount desc");
                    break;
                }
                case 5: {
                    if (asc) {
                        q = q.order("balance asc");
                        break;
                    }
                    q = q.order("balance desc");
                    break;
                }
                case 6: {
                    if (asc) {
                        q = q.order("bookingDate " + dateSortDirection + ", account.name asc, page.pageNumber asc, pos asc");
                        break;
                    }
                    q = q.order("bookingDate " + dateSortDirection + ", account.name desc, page.pageNumber desc, pos desc");
                    break;
                }
                case 7: {
                    if (asc) {
                        q = q.order("account.accountHolder asc, account.name asc, page.pageNumber asc, pos asc");
                        break;
                    }
                    q = q.order("account.accountHolder desc, account.name asc, page.pageNumber asc, pos asc");
                    break;
                }
                case 8: {
                    if (asc) {
                        q = q.order("account.name asc, statement.statementNumber asc, page.pageNumber asc, pos asc, id asc");
                        break;
                    }
                    q = q.order("account.name desc, statement.statementNumber desc, page.pageNumber desc, pos desc, id desc");
                    break;
                }
                default: {
                    q = asc ? q.order("statement.creationDate " + dateSortDirection + ", page.creationDate " + dateSortDirection + ", account.name asc, statement.statementNumber asc, page.pageNumber asc, pos asc, id asc") : q.order("statement.creationDate " + dateSortDirection + ", page.creationDate " + dateSortDirection + ", account.name desc, statement.statementNumber desc, page.pageNumber desc, pos desc, id desc");
                }
            }
            return q;
        }
        return null;
    }

    public CompletionStage<Result> printAllBookings(Http.Request request, boolean printDtiOnly, Integer accountId, Integer year, Integer statementId, Integer pageId, Integer folderId, Integer bookingId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String referer = Utils.getHeaderValue(request, "referer");
        CmDateRangeForm form = (CmDateRangeForm)this.formFactory.form(CmDateRangeForm.class).bindFromRequest(request, new String[0]).get();
        return CompletableFuture.supplyAsync(() -> {
            boolean filterByTimePeriod = form.printradio.equals("timerange");
            java.util.Date bookingsPeriodStartDate = null;
            java.util.Date bookingsPeriodEndDate = null;
            if (filterByTimePeriod) {
                bookingsPeriodStartDate = form.fromDate;
                bookingsPeriodEndDate = form.toDate;
            }
            return this.printBookingsToPdf(messages, user, referer, bookingsPeriodStartDate, bookingsPeriodEndDate, printDtiOnly, accountId, year, statementId, pageId, folderId, bookingId);
        }, this.executionContext.current());
    }

    public Result printBookingsToPdf(Messages messages, User user, String referer, java.util.Date bookingsPeriodStartDate, java.util.Date bookingsPeriodEndDate, boolean printDtiOnly, Integer accountId, Integer year, Integer statementId, Integer pageId, Integer folderId, Integer bookingId) {
        Query<CmBooking> q;
        CmBooking parentBooking;
        CmPage cmPage;
        CmStatement statement;
        CmFolder folder;
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
        boolean printSeparatelyPerBank = store.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.PRINT_SEPARATELY_PER_BANK);
        if (folderId != null && folderId >= 0) {
            folder = CmFolder.findById((Integer)folderId, (User)user);
            if (folder == null) {
                return Bookings.redirect((Call)routes.Bookings.bookings(-1, year, null, null, null, null)).flashing("warning", messages.at("balancelists.error.noSuchGroup", new Object[0]));
            }
        } else {
            folder = null;
        }
        ArrayList<Account> accountsToPrint = new ArrayList();
        Account accountToPrint = null;
        List accountsWithPermission = Account.findAccounts((User)user, null, (CmFolder)folder, (boolean)store.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS));
        if (printDtiOnly) {
            for (Account account : accountsWithPermission) {
                if (CmStatement.findCountDtiFiles((Account)account, null, null) <= 0) continue;
                accountsToPrint.add(account);
                if (!account.getId().equals(accountId)) continue;
                accountToPrint = account;
            }
            accountsToPrint.sort(Comparator.comparing(Account::getDefaultDisplayName));
        } else {
            accountsToPrint = accountsWithPermission;
            accountToPrint = this.checkAccounts(accountId, accountsToPrint);
        }
        if (accountToPrint == null && accountId != null && accountId != -1) {
            return Bookings.redirect((String)referer).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
        }
        CmBookingFilter filter = CmBookingFilter.getFilter((User)user);
        if (bookingsPeriodStartDate != null) {
            if (!filter.isFilterActive()) {
                filter = new CmBookingFilter(user);
            }
            filter.setBookingDateFrom(new Date(bookingsPeriodStartDate.getTime()));
            filter.setBookingDateTo(new Date(bookingsPeriodEndDate.getTime()));
            filter.setBookingDateComparator(FilterComparator.Date.BETWEEN);
            filter.setFilterActive(Boolean.valueOf(true));
        } else if (!filter.isFilterActive()) {
            filter = null;
        }
        if (accountToPrint != null && statementId != null) {
            statement = this.statementForAccountAndId(accountToPrint, statementId);
            if (statement == null) {
                return Bookings.redirect((String)referer).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
            }
        } else {
            statement = null;
        }
        if (statement != null && statement.isHasPages() && pageId != null) {
            cmPage = this.pageForStmtAndId(statement, pageId);
            if (cmPage == null) {
                return Bookings.redirect((Call)routes.Bookings.bookings(accountToPrint.getId(), year, statement.getId(), null, null, null)).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
            }
        } else {
            cmPage = null;
        }
        if (!(bookingId == null || (parentBooking = CmBooking.findById((int)bookingId)) != null && accountsWithPermission.contains(parentBooking.getAccount()))) {
            return Bookings.redirect((String)referer).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
        }
        if (printDtiOnly) {
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_DTI);
            q = DtiView.sortedPagedBookings(accountToPrint, statement, bookingId, accountsToPrint, filter, sorting.getSortingColumn(-1), sorting.isSortingAscending());
        } else {
            q = this.sortedPagedBookings(user, cmPage, statement, accountToPrint, accountsToPrint, filter, 6, true);
        }
        if (q == null || q.findCount() == 0) {
            return Bookings.redirect((String)referer).flashing("warning", messages.at(bookingsPeriodStartDate != null ? "cm.print.nothingtoprint.forDates" : "cm.print.nothingtoprint", new Object[0]));
        }
        if (year != null && accountToPrint != null) {
            Calendar c = Calendar.getInstance();
            c.set(year, 0, 1);
            Date fromDate = new Date(c.getTimeInMillis());
            c.set(year, 11, 31);
            Date toDate = new Date(c.getTimeInMillis());
            List statements = CmStatement.findStatementsAndAdvices((Account)accountToPrint, (int)0, (int)Integer.MAX_VALUE, (boolean)true, (Date)fromDate, (Date)toDate).getList();
            q.where().in("statement", (Collection)statements);
        }
        q.setMaxRows(Sorting.MAX_RESULT_SIZE);
        LinkedHashMap<CmStatement, Collection<CmBooking>> bookings2 = new LinkedHashMap<CmStatement, Collection<CmBooking>>();
        for (CmBooking booking : q.findList()) {
            Collection statementBookings = bookings2.computeIfAbsent(booking.getStatement(), k -> new LinkedHashSet());
            statementBookings.add(booking);
        }
        try {
            if (printSeparatelyPerBank) {
                ArrayList<File> files = new ArrayList<File>();
                for (CMCollection c : CMCollection.splitPerBank(null, null, null, null, bookings2).values()) {
                    File file2 = CmUtils.printBookings(c.getStatementBookingMap(), user, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bookings", (Object[])new Object[0]), bookingsPeriodStartDate, bookingsPeriodEndDate, messages.lang().locale());
                    if (file2 == null) continue;
                    files.add(file2);
                }
                if (files.isEmpty()) {
                    return Bookings.redirect((String)referer).flashing("error", messages.at("cm.print.nothingtoprint", new Object[0]));
                }
                if (files.size() == 1) {
                    return GeneralUtils.supplyWorkspaceFile((File)files.get(0), true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bookings", (Object[])new Object[0]) + ".pdf"));
                }
                return GeneralUtils.supplyZipFile(files, true, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bookings", (Object[])new Object[0]) + ".zip"));
            }
            File temp = CmUtils.printBookings(bookings2, user, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bookings", (Object[])new Object[0]), bookingsPeriodStartDate, bookingsPeriodEndDate, messages.lang().locale());
            if (temp == null) {
                return Bookings.redirect((String)referer).flashing("error", messages.at("cm.print.nothingtoprint", new Object[0]));
            }
            return GeneralUtils.supplyWorkspaceFile(temp, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bookings", (Object[])new Object[0]) + ".pdf"));
        }
        catch (PDFException | IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Printing CM bookings failed!", e);
            return Bookings.redirect((String)referer).flashing("error", messages.at("cm.error.printUnsuccessful", new Object[0]));
        }
    }

    public CompletionStage<Result> exportDtiBookings(Http.Request request, Integer accountId, Integer statementId, Integer bookingId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String referer = Utils.getHeaderValue(request, "referer");
        Form form = this.formFactory.form(BookingExportForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            if (form.hasErrors()) {
                return Bookings.redirect((String)referer).flashing("warning", messages.at("bookings.export.exported", new Object[]{0}));
            }
            Conversion conversion = ((BookingExportForm)form.get()).getConversion(user);
            if (conversion != null) {
                try {
                    List bookingsToExport;
                    if (((BookingExportForm)form.get()).exportIds == null || ((BookingExportForm)form.get()).exportIds.isEmpty()) {
                        SortingHandler sorting;
                        Query<CmBooking> q;
                        CmBooking parentBooking;
                        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
                        ArrayList<Account> accs = new ArrayList<Account>();
                        Account acc = null;
                        boolean checkPermission = store.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
                        List allAccounts = Account.findAccounts((User)user, null, null, (boolean)checkPermission);
                        for (Account a : allAccounts) {
                            if (CmStatement.findCountDtiFiles((Account)a, null, null) <= 0) continue;
                            accs.add(a);
                            if (!a.getId().equals(accountId)) continue;
                            acc = a;
                        }
                        if (acc == null && accountId != -1) {
                            return Bookings.redirect((String)referer).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
                        }
                        accs.sort(Comparator.comparing(Account::getDefaultDisplayName));
                        CmStatement statement = null;
                        if (acc != null && statementId != null && (statement = this.statementForAccountAndId(acc, statementId)) == null) {
                            return Bookings.redirect((String)referer).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
                        }
                        if (!(bookingId == null || (parentBooking = CmBooking.findById((int)bookingId)) != null && allAccounts.contains(parentBooking.getAccount()))) {
                            return Bookings.redirect((String)referer).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
                        }
                        CmBookingFilter filter = CmBookingFilter.getFilter((User)user);
                        if (filter != null && !filter.isFilterActive()) {
                            filter = null;
                        }
                        if ((q = DtiView.sortedPagedBookings(acc, statement, bookingId, accs, filter, (sorting = new SortingHandler(user, Sorting.Table.CM_DTI)).getSortingColumn(-1), sorting.isSortingAscending())) == null || q.findCount() == 0) {
                            return Bookings.redirect((String)referer).flashing("warning", messages.at("bookings.export.exported", new Object[]{0}));
                        }
                        bookingsToExport = q.findList();
                    } else {
                        List<Integer> ids = GeneralUtils.getSelectionIds(((BookingExportForm)form.get()).exportIds);
                        bookingsToExport = DB.find(CmBooking.class).where().in("id", ids).findList();
                    }
                    File tmpFile = Util.createTempFile((String)"export", (String)"tmp", (boolean)true);
                    try (Converter converter = new Converter(conversion, tmpFile, true, new DatabasePreferenceStore(Preference.ApplicationId.CM, user), messages.lang().toLocale());){
                        for (CmBooking booking : bookingsToExport) {
                            converter.convert(booking);
                        }
                    }
                    return Bookings.ok((File)tmpFile).as("text/csv").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(conversion.getName() + ".csv"));
                }
                catch (IOException io) {
                    Bookings.redirect((String)referer).flashing("HTMLerror", messages.at("bookings.export.error", new Object[0]) + " " + Utils.getLocalizedMessage(io, messages));
                }
            } else {
                return this.printBookingsToPdf(messages, user, referer, null, null, ((BookingExportForm)form.get()).isDTI(), accountId, null, statementId, null, null, ((BookingExportForm)form.get()).getBookingId());
            }
            return Bookings.redirect((String)referer).flashing("warning", messages.at("bookings.export.exported", new Object[]{0}));
        }, this.executionContext.current());
    }

    public CompletionStage<Result> printBookings(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String referer = Utils.getHeaderValue(request, "referer");
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
        boolean checkPermission = store.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        return CompletableFuture.supplyAsync(() -> {
            LinkedHashMap<CmStatement, Collection<CmBooking>> bookings2 = new LinkedHashMap<CmStatement, Collection<CmBooking>>();
            for (String id : ids.split(",")) {
                try {
                    CmBooking b = CmBooking.findById((int)Integer.parseInt(id));
                    if (b == null || !Account.isAccountAllowed((Account)b.getAccount(), (User)user, (boolean)checkPermission)) continue;
                    Collection set = bookings2.computeIfAbsent(b.getStatement(), k -> new LinkedHashSet());
                    set.add(b);
                }
                catch (NumberFormatException nfx) {
                    BLLoggerPlay.warning(nfx.toString());
                }
            }
            if (bookings2.isEmpty()) {
                return Bookings.redirect((String)referer).flashing("error", messages.at("cm.print.nothingtoprint", new Object[0]));
            }
            try {
                if (store.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.PRINT_SEPARATELY_PER_BANK)) {
                    ArrayList<File> fileList = new ArrayList<File>();
                    for (CMCollection c : CMCollection.splitPerBank(null, null, null, null, bookings2).values()) {
                        File file2 = CmUtils.printBookings(c.getStatementBookingMap(), user, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bookings", (Object[])new Object[0]), null, null, messages.lang().locale());
                        if (file2 == null) continue;
                        fileList.add(file2);
                    }
                    if (fileList.isEmpty()) {
                        return Bookings.redirect((String)referer).flashing("error", messages.at("cm.print.nothingtoprint", new Object[0]));
                    }
                    if (fileList.size() == 1) {
                        return GeneralUtils.supplyWorkspaceFile((File)fileList.get(0), true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bookings", (Object[])new Object[0]) + ".pdf"));
                    }
                    return GeneralUtils.supplyZipFile(fileList, true, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bookings", (Object[])new Object[0]) + ".zip"));
                }
                File temp = CmUtils.printBookings(bookings2, user, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bookings", (Object[])new Object[0]), null, null, messages.lang().locale());
                if (temp == null) {
                    return Bookings.redirect((String)referer).flashing("error", messages.at("cm.print.nothingtoprint", new Object[0]));
                }
                return GeneralUtils.supplyWorkspaceFile(temp, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bookings", (Object[])new Object[0]) + ".pdf"));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Printing CM bookings failed!", e);
                return Bookings.redirect((String)referer).flashing("error", messages.at("cm.error.printUnsuccessful", new Object[0]));
            }
        }, this.executionContext.current());
    }

    public Result deleteStatement(Http.Request request, int accountId, Integer year, int statementId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean allowToDelete = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_DELETE_STATMENTS);
        if (!allowToDelete) {
            return Bookings.redirect((Call)routes.CmAccountOverview.index()).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("cm.deletedAccounts.nopermission", new Object[0]));
        }
        boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Account acc = Account.findById((int)accountId);
        if (acc == null || !Account.isAccountAllowed((Account)acc, (User)user, (boolean)checkPermission)) {
            return Bookings.redirect((Call)routes.Bookings.bookings(-1, year, null, null, null, null)).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
        }
        CmStatement stmt = this.statementForAccountAndId(acc, statementId);
        if (stmt == null) {
            return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, null, null, null, null)).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
        }
        CmDeleter.delete((CmStatement)stmt);
        ValueBalanceCalculator.delete((Set)ImmutableSet.of((Object)stmt), (Set)ImmutableSet.of());
        return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, null, null, null, null));
    }

    public Result deletePage(Http.Request request, int accountId, Integer year, int statementId, int pageId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean allowToDelete = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_DELETE_STATMENTS);
        if (!allowToDelete) {
            return Bookings.redirect((Call)routes.CmAccountOverview.index()).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("cm.deletedAccounts.nopermission", new Object[0]));
        }
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        Account acc = Account.findById((int)accountId);
        if (acc == null || !Account.isAccountAllowed((Account)acc, (User)user, (boolean)checkPermission)) {
            return Bookings.redirect((Call)routes.Bookings.bookings(-1, year, null, null, null, null)).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
        }
        CmStatement stmt = this.statementForAccountAndId(acc, statementId);
        if (stmt == null) {
            return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, null, null, null, null)).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
        }
        CmPage page = this.pageForStmtAndId(stmt, pageId);
        if (page == null) {
            return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, statementId, null, null, null)).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
        }
        CmDeleter.delete((CmPage)page);
        if (CmPage.findCountForStatement((CmStatement)stmt) == 0) {
            CmDeleter.delete((CmStatement)stmt);
            ValueBalanceCalculator.delete((Set)ImmutableSet.of((Object)stmt), (Set)ImmutableSet.of((Object)page));
            return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, null, null, null, null));
        }
        ValueBalanceCalculator.delete((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)page));
        return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, statementId, null, null, null));
    }

    public CompletionStage<Result> printStatement(Http.Request request, int accountId, Integer year, int statementId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String referer = Utils.getHeaderValue(request, "referer");
        boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        return CompletableFuture.supplyAsync(() -> {
            Account acc = Account.findById((int)accountId);
            if (acc == null || !Account.isAccountAllowed((Account)acc, (User)user, (boolean)checkPermission)) {
                return Bookings.redirect((Call)routes.Bookings.bookings(-1, year, null, null, null, null)).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
            }
            CmStatement stmt = this.statementForAccountAndId(acc, statementId);
            if (stmt == null) {
                return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, null, null, null, null)).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
            }
            try {
                File temp = CmUtils.printStatement(stmt, user, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatement", (Object[])new Object[0]), messages.lang().locale());
                return GeneralUtils.supplyWorkspaceFile(temp, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatement", (Object[])new Object[0]) + ".pdf"));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Printing CM statement(s) failed!", e);
                return Bookings.redirect((String)referer).flashing("error", messages.at("cm.error.printUnsuccessful", new Object[0]));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> printPage(Http.Request request, int accountId, Integer year, int statementId, int pageId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String referer = Utils.getHeaderValue(request, "referer");
        boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        return CompletableFuture.supplyAsync(() -> {
            Account acc = Account.findById((int)accountId);
            if (acc == null || !Account.isAccountAllowed((Account)acc, (User)user, (boolean)checkPermission)) {
                return Bookings.redirect((Call)routes.Bookings.bookings(-1, year, null, null, null, null)).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
            }
            CmStatement stmt = this.statementForAccountAndId(acc, statementId);
            if (stmt == null) {
                return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, null, null, null, null)).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
            }
            CmPage page = this.pageForStmtAndId(stmt, pageId);
            if (page == null) {
                return Bookings.redirect((Call)routes.Bookings.bookings(accountId, year, statementId, null, null, null)).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
            }
            try {
                File temp = CmUtils.printPage(page, user, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatement", (Object[])new Object[0]), messages.lang().locale());
                return GeneralUtils.supplyWorkspaceFile(temp, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatement", (Object[])new Object[0]) + ".pdf"));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Printing CM page(s) failed!", e);
                return Bookings.redirect((String)referer).flashing("error", messages.at("cm.error.printUnsuccessful", new Object[0]));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> exportBookings(Http.Request request, Integer accountId, Integer year, Integer statementId, Integer pageId, Integer folderId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String referer = Utils.getHeaderValue(request, "referer");
        Form form = this.formFactory.form(BookingExportForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            if (form.hasErrors() || ((BookingExportForm)form.get()).getConversion(user) == null && !((BookingExportForm)form.get()).isPdfExport()) {
                return Bookings.redirect((String)referer).flashing("warning", messages.at("bookings.export.exported", new Object[]{0}));
            }
            try {
                List bookingsToExport;
                if (((BookingExportForm)form.get()).exportIds == null || ((BookingExportForm)form.get()).exportIds.isEmpty()) {
                    Query<CmBooking> q;
                    CmPage cmPage;
                    CmStatement statement;
                    List accs;
                    Account acc;
                    CmFolder folder;
                    DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
                    if (folderId != null && folderId >= 0) {
                        folder = CmFolder.findById((Integer)folderId, (User)user);
                        if (folder == null) {
                            return Bookings.redirect((String)referer).flashing("warning", messages.at("balancelists.error.noSuchGroup", new Object[0]));
                        }
                    } else {
                        folder = null;
                    }
                    if ((acc = this.checkAccounts(accountId, accs = Account.findAccounts((User)user, null, (CmFolder)folder, (boolean)store.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS)))) == null && accountId != -1) {
                        return Bookings.redirect((String)referer).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
                    }
                    CmBookingFilter filter = CmBookingFilter.getFilter((User)user);
                    if (filter != null && !filter.isFilterActive()) {
                        filter = null;
                    }
                    if (acc != null && statementId != null) {
                        statement = this.statementForAccountAndId(acc, statementId);
                        if (statement == null) {
                            return Bookings.redirect((String)referer).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
                        }
                    } else {
                        statement = null;
                    }
                    if (statement != null && statement.isHasPages() && pageId != null) {
                        cmPage = this.pageForStmtAndId(statement, pageId);
                        if (cmPage == null) {
                            return Bookings.redirect((String)referer).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
                        }
                    } else {
                        cmPage = null;
                    }
                    if ((q = this.sortedPagedBookings(user, cmPage, statement, acc, accs, filter, 6, true)) == null || q.findCount() == 0) {
                        return Bookings.redirect((String)referer).flashing("warning", messages.at("bookings.export.exported", new Object[]{0}));
                    }
                    bookingsToExport = q.findList();
                } else {
                    List<Integer> ids = GeneralUtils.getSelectionIds(((BookingExportForm)form.get()).exportIds);
                    bookingsToExport = DB.find(CmBooking.class).where().in("id", ids).findList();
                }
                Conversion conversion = ((BookingExportForm)form.get()).getConversion(user);
                if (conversion != null) {
                    File tmpFile = Util.createTempFile((String)"export", (String)"tmp", (boolean)true);
                    Converter converter = new Converter(conversion, tmpFile, true, new DatabasePreferenceStore(Preference.ApplicationId.CM, user), messages.lang().toLocale());
                    for (CmBooking booking : bookingsToExport) {
                        converter.convert(booking);
                    }
                    return Bookings.ok((File)tmpFile).as("text/csv").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(conversion.getName() + ".csv"));
                }
                return this.printBookingsToPdf(messages, user, referer, null, null, ((BookingExportForm)form.get()).isDTI(), accountId, year, statementId, pageId, folderId, ((BookingExportForm)form.get()).getBookingId());
            }
            catch (IOException io) {
                Bookings.redirect((String)referer).flashing("HTMLerror", messages.at("bookings.export.error", new Object[0]) + " " + Utils.getLocalizedMessage(io, messages));
                return Bookings.redirect((String)referer).flashing("warning", messages.at("bookings.export.exported", new Object[]{0}));
            }
        }, this.executionContext.current());
    }
}

