/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.google.common.collect.ImmutableList;
import controllers.AuthenticatorFor;
import controllers.BLSyncCache;
import controllers.ClusterFetchScheduler;
import controllers.FetchSchedule;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import controllers.util.EbicsUtil;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankIcons;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Ebics30Migrator;
import de.businesslogics.banking.api.HTDPrinter;
import de.businesslogics.banking.api.HTDProcessing;
import de.businesslogics.banking.api.KeyUtil;
import de.businesslogics.banking.api.ProgressMonitorDummy;
import de.businesslogics.banking.api.SendParameterUtil;
import de.businesslogics.banking.api.SignatureVersionChanger;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.mt940.api.StatementsPreScheduler;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.banking.transfer.api.NotificationSettings;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.client.DifferingKeyDigestException;
import de.businesslogics.ebics.client.EbicsHttpEngine;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.schema.h000.EbicsHEVResponse;
import de.businesslogics.ebics.schema.orders.HPDProtocolParams;
import de.businesslogics.ebics.schema.orders.HPDResponseOrderData;
import de.businesslogics.ebics.schema.response.BankPubKeyUpdateRequiredException;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.types.AuthenticationVersion;
import de.businesslogics.ebics.schema.types.EncryptionVersion;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.io.Streams;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.IProgressMonitorWrapper;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.SimplePasswordCallback;
import io.ebean.Query;
import io.ebean.Transaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import models.BankDetailsForm;
import models.BankUserActivationForm;
import models.KnownBank;
import models.NewBankForm;
import models.PasswordForm;
import models.ProtocolVersionForm;
import models.ReIniForm;
import models.RenewKeysForm;
import models.SimpleTextForm;
import models.WebAuthnData;
import models.banks.AcceptHashesHandler;
import models.banks.BankDeleteHandler;
import models.banks.UpdateBankKeysForm;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import play.data.Form;
import play.data.FormFactory;
import play.data.format.Formatters;
import play.data.validation.ValidationError;
import play.i18n.MessagesApi;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.libs.ws.WSClient;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.banks.bankUserActivationQuestion;
import views.html.banks.banks;
import views.html.banks.deleteBankQuestion;
import views.html.banks.iniComplete;
import views.html.banks.lockBank;
import views.html.banks.newbank;
import views.html.banks.protocolversion;
import views.html.banks.reIni;
import views.html.banks.renewKeys;
import views.html.banks.updateBankKeys;

@Security.Authenticated(value=AuthenticatorFor.BanksAndAccounts.class)
public class Banks
extends Controller {
    public static final boolean H005_ALLOWED = true;
    private static final ExecutorService HTD_SERVICE = Executors.newFixedThreadPool(Integer.parseInt(System.getProperty("controllers.Banks.HTDThreads", "3")));
    private static final Map<String, String> BANK_ICONS = new HashMap<String, String>();
    private static BankIcons bankIcons;
    private static List<KnownBank> knownBanks;
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;
    private final ClusterFetchScheduler clusterFetchScheduler;

    public static void updateHTD(User login) {
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, login);
        if (store.getBoolean((DatabasePreferenceConstant)PreferenceConstants.REFRESH_HTD)) {
            List banks2 = BankUser.findBanksForUser((User)login);
            for (BankUser bankUser : banks2) {
                if (!BankUtils.isReady((BankUser)bankUser) && !BankUtils.isCreated((BankUser)bankUser)) continue;
                Banks.updateHTD(bankUser, null);
            }
            BLSyncCache.resetCacheFor(login.getName());
        }
    }

    public static Future<Boolean> updateHKD(BankUser bankUser, EbicsWorker.IAcceptHashes acceptHashes) {
        return HTD_SERVICE.submit(() -> {
            EbicsWorker w = EbicsUtil.getEbicsWorker(bankUser, DatabaseToken.getInstance((BankUser)bankUser, null), acceptHashes);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            w.fetchFile((OutputStream)bout, "HKD", null, null);
            Banks.ready(bankUser);
            HTDProcessing p = new HTDProcessing();
            p.handleHkdFromInputStream(bankUser.getBank(), (InputStream)new ByteArrayInputStream(bout.toByteArray()));
            return null;
        });
    }

    public static Future<Boolean> updateHTD(BankUser bankUser, EbicsWorker.IAcceptHashes acceptHashes) {
        return HTD_SERVICE.submit(() -> {
            EbicsWorker w = EbicsUtil.getEbicsWorker(bankUser, DatabaseToken.getInstance((BankUser)bankUser, null), acceptHashes);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            w.fetchFile((OutputStream)bout, "HTD", null, null);
            Banks.ready(bankUser);
            HTDProcessing p = new HTDProcessing();
            p.handleHtdFromInputStream(bankUser, (InputStream)new ByteArrayInputStream(bout.toByteArray()));
            return null;
        });
    }

    public static void ready(BankUser bankUser) {
        if (BankUtils.isCreated((BankUser)bankUser)) {
            bankUser.setState(BankUser.UserState.READY);
            bankUser.save();
        }
    }

    public static String getBankIcon(BankSettings bank) {
        String result = Banks.getBankIcons().getBankIcon(bank);
        int separatorLocation = result.lastIndexOf(47);
        if (separatorLocation < 0) {
            separatorLocation = result.lastIndexOf(92);
        }
        if (separatorLocation >= 0 && separatorLocation < result.length() - 1) {
            result = result.substring(separatorLocation + 1);
        }
        return result;
    }

    public static void setBankIcon(BankSettings bank, String icon) {
        for (String knownIcon : Banks.getBankIcons().getIcons()) {
            File iconFile = new File(knownIcon);
            if (!iconFile.isFile() || !icon.endsWith(iconFile.getName())) continue;
            Banks.getBankIcons().setBankIcon(bank, knownIcon);
            return;
        }
        Banks.getBankIcons().setBankIcon(bank, icon);
    }

    public static String defaultIcon() {
        return Banks.getBankIcons().getDefaultIcon();
    }

    public static List<String> icons() {
        return Banks.getBankIcons().getIcons();
    }

    public static String getIcon(String icon) {
        String result = Banks.getBankIcons().getBankIcon(icon);
        if (result == null) {
            result = Banks.defaultIcon();
        }
        return result;
    }

    public static Seq<Tuple2<String, String>> getBankCountries(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        HashMap<String, String> countries = new HashMap<String, String>();
        CountriesLoader countriesLoader = CountriesLoader.getInstance((Locale)locale);
        for (String countryCode : SendParameterUtil.BANK_COUNTRIES) {
            countries.put(countriesLoader.getCountryName(countryCode), countryCode);
        }
        Object[] sortedCountryCodes = countries.keySet().toArray(new String[0]);
        Arrays.sort(sortedCountryCodes);
        for (Object s : sortedCountryCodes) {
            result.add(Scala.Tuple((Object)((String)countries.get(s)), (Object)s));
        }
        return Scala.toSeq(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getB64BankIcon(String icon) {
        Object b64Icon = BANK_ICONS.get(icon);
        if (b64Icon != null) {
            return b64Icon;
        }
        String bankicon2 = Banks.getBankIcons().getBankIcon(icon);
        if (bankicon2 == null) {
            return "";
        }
        File iconFile = new File(bankicon2);
        InputStream inputStream = null;
        try {
            int pathSeparator;
            inputStream = iconFile.isFile() ? Files.newInputStream(iconFile.toPath(), new OpenOption[0]) : ((pathSeparator = bankicon2.lastIndexOf(47)) >= 0 && pathSeparator < bankicon2.length() - 1 ? Banks.class.getResourceAsStream("/bank/" + bankicon2.substring(pathSeparator + 1)) : Banks.class.getResourceAsStream("/bank/" + bankicon2));
            if (inputStream != null) {
                byte[] rawIcon = Streams.readAll((InputStream)inputStream);
                b64Icon = "data:image/x-icon;base64," + Base64.getEncoder().encodeToString(rawIcon);
            }
        }
        catch (IOException e) {
            String string;
            try {
                BLLoggerPlay.error("Failed to load bank icon " + bankicon2, e);
                string = "";
            }
            catch (Throwable throwable) {
                Util.closeStream(inputStream);
                throw throwable;
            }
            Util.closeStream((Closeable)inputStream);
            return string;
        }
        Util.closeStream((Closeable)inputStream);
        BANK_ICONS.put(icon, (String)b64Icon);
        return b64Icon;
    }

    private static BankIcons getBankIcons() {
        if (bankIcons == null) {
            bankIcons = new BankIcons(Util.WORKSPACEDIR, BLLoggerPlay.getLogger());
            for (KnownBank knownBank : Banks.getKnownBanks()) {
                bankIcons.register(knownBank.icon);
            }
            bankIcons.register("z_black.ico");
            bankIcons.register("z_brown.ico");
            bankIcons.register("z_red.ico");
            bankIcons.register("z_orange.ico");
            bankIcons.register("z_green.ico");
            bankIcons.register("z_blue.ico");
        }
        return bankIcons;
    }

    public static synchronized List<KnownBank> getKnownBanks() {
        block7: {
            if (knownBanks != null) break block7;
            InputStream in = null;
            try {
                in = Objects.requireNonNull(Banks.class.getResource("/plugin.xml")).openStream();
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
                NodeList nodes = doc.getElementsByTagName("bank");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    int lastPathSeparator;
                    NamedNodeMap attributes = nodes.item(i).getAttributes();
                    KnownBank knownBank = new KnownBank();
                    knownBank.bankname = Banks.getElement(attributes.getNamedItem("name"));
                    knownBank.countryCode = Banks.getElement(attributes.getNamedItem("countryCode"));
                    if (knownBank.countryCode == null) {
                        knownBank.countryCode = "DE";
                    }
                    knownBank.e002Cert = Banks.getElement(attributes.getNamedItem("e002_cert"));
                    knownBank.e002Hash = Banks.getElement(attributes.getNamedItem("e002"));
                    knownBank.hostId = Banks.getElement(attributes.getNamedItem("hostId"));
                    knownBank.icon = Banks.getElement(attributes.getNamedItem("icon"));
                    knownBank.url = Banks.getElement(attributes.getNamedItem("url"));
                    knownBank.x002Cert = Banks.getElement(attributes.getNamedItem("x002_cert"));
                    knownBank.x002Hash = Banks.getElement(attributes.getNamedItem("x002"));
                    if (knownBanks == null) {
                        knownBanks = new ArrayList<KnownBank>();
                    }
                    knownBanks.add(knownBank);
                    if (knownBank.icon == null || knownBank.icon.isEmpty() || (lastPathSeparator = knownBank.icon.lastIndexOf(47)) < 0 || lastPathSeparator >= knownBank.icon.length() - 1) continue;
                    knownBank.icon = knownBank.icon.substring(lastPathSeparator + 1);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    Util.closeStream(in);
                    throw throwable;
                }
            }
            Util.closeStream((Closeable)in);
            Collator collator = Collator.getInstance();
            knownBanks.sort((b1, b2) -> {
                if ("Business-Logics Testsystem".equals(b1.bankname)) {
                    return -10;
                }
                if ("Business-Logics Testsystem".equals(b2.bankname)) {
                    return 10;
                }
                if ("Business-Logics Banque".equals(b1.bankname)) {
                    return -9;
                }
                if ("Business-Logics Banque".equals(b2.bankname)) {
                    return 9;
                }
                return collator.compare(b1.bankname, b2.bankname);
            });
        }
        return knownBanks;
    }

    private static String getElement(Node node) {
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public static Seq<Tuple2<String, String>> protocolVersions() {
        return Banks.protocolVersions(false);
    }

    public static Seq<Tuple2<String, String>> protocolVersions(boolean onlyAllowed) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        Map<String, String> map = Banks.protocolVersionsMap(onlyAllowed);
        for (String version : map.keySet()) {
            result.add(Scala.Tuple((Object)version, (Object)map.get(version)));
        }
        return Scala.toSeq(result);
    }

    public static Map<String, String> protocolVersionsMap(boolean onlyAllowed) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (!onlyAllowed) {
            result.put(ProtocolVersion.H003.getValue(), "EBICS 2.4 (H003)");
        }
        result.put(ProtocolVersion.H004.getValue(), "EBICS 2.5 (H004)");
        result.put(ProtocolVersion.H005.getValue(), "EBICS 3.0 (H005)");
        return result;
    }

    public static String getProtocolVersionsText(String protocolVersion) {
        if (protocolVersion.equals(ProtocolVersion.H003.getValue())) {
            return "EBICS 2.4 (H003)";
        }
        if (protocolVersion.equals(ProtocolVersion.H004.getValue())) {
            return "EBICS 2.5 (H004)";
        }
        if (protocolVersion.equals(ProtocolVersion.H005.getValue())) {
            return "EBICS 3.0 (H005)";
        }
        return "";
    }

    public static String getProtocolVersionsEbicsText(String protocolVersion) {
        if (protocolVersion.equals(ProtocolVersion.H003.getValue())) {
            return "EBICS 2.4";
        }
        if (protocolVersion.equals(ProtocolVersion.H004.getValue())) {
            return "EBICS 2.5";
        }
        if (protocolVersion.equals(ProtocolVersion.H005.getValue())) {
            return "EBICS 3.0";
        }
        return "";
    }

    public static boolean canUserSeeBank(User user, BankSettings bank) {
        if (bank == null) {
            return false;
        }
        if (user.isAdmin()) {
            return true;
        }
        if (user.getManagedTenants().contains(bank.getTenant())) {
            return true;
        }
        return BankUser.findBankUser((BankSettings)bank, (User)user) != null;
    }

    public static boolean canUserCreateBanks(User user) {
        return user.isAdminOrTenantAdmin();
    }

    public static boolean canUserModifyAnyBanks(User user) {
        return Banks.canUserModifyBank(user, null);
    }

    public static boolean canUserModifyBank(User user, BankSettings bank) {
        if (user.isAdmin()) {
            return true;
        }
        if (bank == null && user.isAdminOrTenantAdmin()) {
            return true;
        }
        if (bank != null && user.getManagedTenants().contains(bank.getTenant())) {
            return true;
        }
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_EDIT_BANK_SETTINGS);
    }

    public static boolean canUserDeleteBanks(User user) {
        return user.isAdminOrTenantAdmin();
    }

    public static Seq<Tuple2<String, String>> getBankActivationOptions(boolean activate, play.i18n.Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (activate) {
            result.add(Scala.Tuple((Object)String.valueOf(false), (Object)messages.at("bank.activate.mine", new Object[0])));
            result.add(Scala.Tuple((Object)String.valueOf(true), (Object)messages.at("bank.activate.all", new Object[0])));
        } else {
            result.add(Scala.Tuple((Object)String.valueOf(false), (Object)messages.at("bank.deactivate.mine", new Object[0])));
            result.add(Scala.Tuple((Object)String.valueOf(true), (Object)messages.at("bank.deactivate.all", new Object[0])));
        }
        return Scala.toSeq(result);
    }

    @Inject
    public Banks(FormFactory formFactory, Formatters formatters, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext, WSClient wsClient) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
        this.clusterFetchScheduler = new ClusterFetchScheduler(wsClient);
        formatters.register(ProtocolVersion.class, (Formatters.SimpleFormatter)new Formatters.SimpleFormatter<ProtocolVersion>(this){

            public ProtocolVersion parse(String arg0, Locale arg1) {
                return ProtocolVersion.getInstance((String)arg0);
            }

            public String print(ProtocolVersion arg0, Locale arg1) {
                return arg0.getValue();
            }
        });
        formatters.register(SignatureVersion.class, (Formatters.SimpleFormatter)new Formatters.SimpleFormatter<SignatureVersion>(this){

            public SignatureVersion parse(String arg0, Locale arg1) {
                return SignatureVersion.getInstance((String)arg0);
            }

            public String print(SignatureVersion arg0, Locale arg1) {
                return arg0.getValue();
            }
        });
    }

    public Result index(Http.Request request) {
        List list;
        Tenant tenant;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        play.i18n.Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sort = new SortingHandler(user, Sorting.Table.BANK_LIST);
        try {
            int tenantId = Integer.parseInt(sort.getProperty("TENANT", "-1"));
            tenant = Tenant.findById((int)tenantId, (User)user, (boolean)false);
        }
        catch (NumberFormatException e) {
            tenant = null;
        }
        Query<BankSettings> query = this.bankQuery(user, sort.getSortingColumn(), sort.isSortingAscending(), tenant);
        sort.computeForQuery(query);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.BANK_LIST, (Call)routes.Banks.index());
        }
        return Banks.ok((Content)banks.render(list, sort, tenant, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private Query<BankSettings> bankQuery(User user, int sort, boolean asc, Tenant tenant) {
        Query query = DB.find(BankSettings.class);
        if (!user.isAdmin()) {
            query = query.where().or().eq("users.user", (Object)user).eq("tenant.managingUsers", (Object)user).query();
        }
        if (tenant != null) {
            query = query.where().eq("tenant", (Object)tenant).query();
        }
        switch (sort) {
            case 1: {
                if (asc) {
                    query = query.order("customerId asc");
                    break;
                }
                query = query.order("customerId desc");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (asc) {
                    query = query.order("tenant.name asc");
                    break;
                }
                query = query.order("tenant.name desc");
                break;
            }
            case 5: {
                if (asc) {
                    query = query.order("prot_version asc");
                    break;
                }
                query = query.order("prot_version desc");
                break;
            }
            default: {
                query = asc ? query.order("displayName asc") : query.order("displayName desc");
            }
        }
        return query;
    }

    public Result index_sort(Http.Request request, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.BANK_LIST).updateSort(sort, asc);
        return Banks.redirect((Call)routes.Banks.index());
    }

    public Result index_pageSize(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.BANK_LIST).updatePage(page, pageSize);
        return Banks.redirect((Call)routes.Banks.index());
    }

    public Result index_tenant(Http.Request request, Integer tenant) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.BANK_LIST).setProperty("TENANT", tenant != null ? String.valueOf(tenant) : null);
        return Banks.redirect((Call)routes.Banks.index());
    }

    public CompletionStage<Result> runHTDUpdate(Http.Request request) {
        play.i18n.Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String bankIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Integer> ids = GeneralUtils.getSelectionIds(bankIds);
        return CompletableFuture.supplyAsync(() -> Banks.runHTDUpdate(request, user, messages, ids, null, this.formFactory, routes.Banks.index()), this.executionContext.current());
    }

    protected static Result runHTDUpdate(Http.Request request, User user, play.i18n.Messages messages, List<Integer> ids, Map<String, String> flashMap, FormFactory formFactory, play.api.mvc.Call redirectTo) {
        boolean redirectToSchedulerCreation;
        boolean inDetails;
        boolean bl = inDetails = !redirectTo.equals((Object)routes.Banks.index());
        if (flashMap == null) {
            flashMap = new HashMap<String, String>();
        }
        int numberOfSuccessfulUpdates = 0;
        String successMsg = null;
        ArrayList<Integer> idsOfFreshReadyBanks = new ArrayList<Integer>();
        HashMap<BankSettings, AcceptHashesHandler> banksWithChangedKeys = new HashMap<BankSettings, AcceptHashesHandler>();
        for (int bankId : ids) {
            BankSettings bank = BankSettings.getById((Integer)bankId);
            BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
            if (bankUser == null) {
                Object message;
                String flashKey;
                if (user.isAdminOrTenantAdmin()) {
                    flashKey = "warning";
                    message = messages.at("bank.error.bankUserOnly", new Object[0]);
                } else {
                    flashKey = "error";
                    message = messages.at("bank.error.noSuchBank", new Object[0]);
                }
                if (ids.size() > 1 && bank != null && bank.getDisplayName() != null && !bank.getDisplayName().isEmpty()) {
                    message = bank.getDisplayName() + ": " + (String)message;
                }
                Utils.addToFlash(flashMap, flashKey, (String)message);
                continue;
            }
            if (!BankUtils.isReady((BankUser)bankUser) && !BankUtils.isCreated((BankUser)bankUser)) {
                Object message = messages.at("bank.error.notReadyOrCreated", new Object[0]);
                if (ids.size() > 1 && bank != null && bank.getDisplayName() != null && !bank.getDisplayName().isEmpty()) {
                    message = bank.getDisplayName() + ": " + (String)message;
                }
                Utils.addToFlash(flashMap, "warning", (String)message);
                continue;
            }
            boolean isReadyBeforeUpdate = BankUtils.isReady((BankUser)bankUser);
            AcceptHashesHandler acceptHashes = new AcceptHashesHandler();
            Future<Boolean> future = Banks.updateHTD(bankUser, acceptHashes);
            try {
                future.get();
                ++numberOfSuccessfulUpdates;
                boolean isReadyAfterUpdate = BankUtils.isReady((BankUser)bankUser);
                if (isReadyAfterUpdate && !isReadyBeforeUpdate) {
                    idsOfFreshReadyBanks.add(bankId);
                }
                successMsg = messages.at("bank.updateSuccessful", new Object[]{numberOfSuccessfulUpdates});
            }
            catch (InterruptedException | ExecutionException e) {
                Throwable t = e;
                if (e instanceof ExecutionException) {
                    t = e.getCause();
                }
                if (t instanceof BankPubKeyUpdateRequiredException) {
                    try {
                        Banks.updateHPB(bankUser, acceptHashes);
                    }
                    catch (Exception e2) {
                        t = e2;
                    }
                }
                if (t instanceof DifferingKeyDigestException) {
                    BLLoggerPlay.error(t.getMessage());
                    banksWithChangedKeys.put(bank, acceptHashes);
                }
                Object error = messages.at("bank.error.whileFetchingHTD", new Object[]{bank.getDisplayName()}) + " " + t.toString();
                String flashKey = "error";
                if (t instanceof EbicsException) {
                    error = BankingApiMessages.getErrorMessageWeb((Exception)((Exception)t), (Locale)messages.lang().locale());
                    flashKey = "HTMLerror";
                }
                BLLoggerPlay.error("An error occurred while updating bank access " + bank.getDisplayName() + ":", t);
                Utils.addToFlash(flashMap, flashKey, (String)error);
            }
        }
        if (successMsg != null) {
            Utils.addToFlash(flashMap, "success", successMsg);
        }
        BLSyncCache.resetCacheFor(user.getName());
        if (!banksWithChangedKeys.isEmpty()) {
            UpdateBankKeysForm formValues = new UpdateBankKeysForm();
            for (BankSettings bank : banksWithChangedKeys.keySet()) {
                formValues.setHandlerForBank(bank.getBankId(), (AcceptHashesHandler)banksWithChangedKeys.get(bank));
            }
            Form form = formFactory.form(UpdateBankKeysForm.class).fill((Object)formValues);
            List<BankSettings> banks2 = banksWithChangedKeys.keySet().stream().sorted(Comparator.comparingInt(BankSettings::getBankId)).toList();
            String bankIds = String.join((CharSequence)",", banks2.stream().map(b -> b.getBankId().toString()).toList());
            return Banks.ok((Content)updateBankKeys.render(banks2, bankIds, (Form<UpdateBankKeysForm>)form, inDetails, flashMap, BankDetailsForm.Tab.BANK.label, request, messages));
        }
        boolean bl2 = redirectToSchedulerCreation = !Utils.hasErrorFlash(flashMap) && !idsOfFreshReadyBanks.isEmpty() && !FetchSchedule.getMissingSchedules(user, idsOfFreshReadyBanks, null).isEmpty();
        if (redirectToSchedulerCreation) {
            return Banks.redirect((Call)routes.FetchSchedule.createMissingSchedulesPage(idsOfFreshReadyBanks.stream().map(Objects::toString).collect(Collectors.joining(",")), null)).flashing(flashMap);
        }
        return Banks.redirect((Call)redirectTo).flashing(flashMap);
    }

    public Result updateBankKeys(Http.Request request, String bankIds) {
        return Banks.updateBankKeys(request, bankIds, this.messagesApi, this.formFactory, routes.Banks.index());
    }

    protected static Result updateBankKeys(Http.Request request, String bankIds, MessagesApi messagesApi, FormFactory formFactory, play.api.mvc.Call redirect) {
        boolean inDetails = !redirect.equals((Object)routes.Banks.index());
        AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        List<Integer> bankIdsList = GeneralUtils.getSelectionIds(bankIds);
        List<BankSettings> banks2 = bankIdsList.stream().map(id -> BankSettings.getByIdAndUser((Integer)id, (User)user)).toList();
        if (banks2.isEmpty()) {
            return Banks.redirect((Call)routes.Banks.index()).flashing("error", messages.at("bank.error.noSuchBank", new Object[0]));
        }
        Form form = formFactory.form(UpdateBankKeysForm.class).bindFromRequest(request, new String[0]);
        if (form.hasErrors()) {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("error", messages.at("general.formerror", new Object[0]));
            return Banks.ok((Content)updateBankKeys.render(banks2, bankIds, (Form<UpdateBankKeysForm>)form, inDetails, flashMap, BankDetailsForm.Tab.BANK.label, request, messages));
        }
        for (BankSettings bank : banks2) {
            AcceptHashesHandler handler = ((UpdateBankKeysForm)form.get()).getHandlerForBank(bank.getBankId());
            String eHashChanged = null;
            String xHashChanged = null;
            if (EncryptionVersion.E001.getValue().equals(handler.getEVersion())) {
                if (bank.getE001Key() != null) {
                    bank.getE001Key().setExponent(null);
                    bank.getE001Key().save();
                }
                bank.setExpectedDigestE001(handler.getEFound());
                if (!Objects.equals(handler.getEFound(), handler.getEExpected())) {
                    eHashChanged = "E001";
                }
            } else if (EncryptionVersion.E002.getValue().equals(handler.getEVersion())) {
                if (bank.getE002Key() != null) {
                    bank.getE002Key().setExponent(null);
                    bank.getE002Key().save();
                }
                bank.setExpectedDigestE002(handler.getEFound());
                if (!Objects.equals(handler.getEFound(), handler.getEExpected())) {
                    eHashChanged = "E002";
                }
            }
            if (AuthenticationVersion.X001.getValue().equals(handler.getXVersion())) {
                if (bank.getX001Key() != null) {
                    bank.getX001Key().setExponent(null);
                    bank.getX001Key().save();
                }
                bank.setExpectedDigestX001(handler.getXFound());
                if (!Objects.equals(handler.getXFound(), handler.getXExpected())) {
                    xHashChanged = "X001";
                }
            } else if (AuthenticationVersion.X002.getValue().equals(handler.getXVersion())) {
                if (bank.getX002Key() != null) {
                    bank.getX002Key().setExponent(null);
                    bank.getX002Key().save();
                }
                bank.setExpectedDigestX002(handler.getXFound());
                if (!Objects.equals(handler.getXFound(), handler.getXExpected())) {
                    xHashChanged = "X002";
                }
            }
            bank.save();
            if (eHashChanged != null) {
                logger.logBankDigestModified(user, eHashChanged, bank, handler.getEFound());
            }
            if (xHashChanged == null) continue;
            logger.logBankDigestModified(user, xHashChanged, bank, handler.getXFound());
        }
        return Banks.runHTDUpdate(request, user, messages, bankIdsList, null, formFactory, redirect);
    }

    public CompletionStage<Result> activateQuestion(Http.Request request) {
        return CompletableFuture.supplyAsync(() -> Banks.toggleActivateBanksQuestion(request, true, null, this.messagesApi, this.formFactory), this.executionContext.current());
    }

    public CompletionStage<Result> deactivateQuestion(Http.Request request) {
        return CompletableFuture.supplyAsync(() -> Banks.toggleActivateBanksQuestion(request, false, null, this.messagesApi, this.formFactory), this.executionContext.current());
    }

    public static Result toggleActivateBanksQuestion(Http.Request request, boolean activate, Integer bankId, MessagesApi messagesApi, FormFactory formFactory) {
        boolean inDetails;
        String ids;
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (bankId != null) {
            ids = bankId.toString();
            inDetails = true;
        } else {
            ids = ((SimpleTextForm)formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            inDetails = false;
        }
        ArrayList<BankSettings> banks2 = new ArrayList<BankSettings>();
        HashMap<String, String> flashMap = new HashMap<String, String>();
        for (Integer id : GeneralUtils.getSelectionIds(ids)) {
            BankSettings bank = (BankSettings)DB.find(BankSettings.class).where().eq("bankId", (Object)id).findOne();
            if (Banks.canUserSeeBank(operatingUser, bank)) {
                if (operatingUser.isAdminOrTenantAdmin()) {
                    List bankUsers = BankUser.findActiveBankUsersForBank((BankSettings)bank);
                    if (bankUsers.isEmpty()) {
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.activate.noBankUsers", new Object[]{bank.getDisplayName()}));
                        continue;
                    }
                    if (activate && bankUsers.stream().noneMatch(BankUtils::isDeactivated)) {
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.activate.alreadyActiveAll", new Object[]{bank.getDisplayName()}));
                        continue;
                    }
                    if (!activate && bankUsers.stream().allMatch(BankUtils::isDeactivated)) {
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.activate.alreadyDeactivatedAll", new Object[]{bank.getDisplayName()}));
                        continue;
                    }
                    banks2.add(bank);
                    continue;
                }
                BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)operatingUser);
                if (activate) {
                    if (!BankUtils.isDeactivated((BankUser)bankUser)) {
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.activate.alreadyActive", new Object[]{bank.getDisplayName(), bankUser.getUser().getName()}));
                        continue;
                    }
                    banks2.add(bank);
                    continue;
                }
                if (BankUtils.isDeactivated((BankUser)bankUser)) {
                    Utils.addToFlash(flashMap, "warning", messages.at("bank.activate.alreadyDeactivated", new Object[]{bank.getDisplayName(), bankUser.getUser().getName()}));
                    continue;
                }
                if (!BankUtils.isReady((BankUser)bankUser) && !BankUtils.isCreated((BankUser)bankUser)) {
                    Utils.addToFlash(flashMap, "warning", bank.getDisplayName() + ": " + messages.at("bank.error.notReadyOrCreated", new Object[0]));
                    continue;
                }
                banks2.add(bank);
                continue;
            }
            if (bank == null) continue;
            Utils.addToFlash(flashMap, "error", messages.at("bank.edit.error.cantEdit", new Object[]{bank.getDisplayName()}));
        }
        if (banks2.isEmpty()) {
            Utils.addToFlash(flashMap, "warning", messages.at("bank.edit.error.nothingToEdit", new Object[0]));
            return Banks.redirect((Call)routes.Banks.index()).flashing(flashMap);
        }
        BankUserActivationForm formValues = new BankUserActivationForm();
        formValues.loadDefaults(banks2);
        Form form = formFactory.form(BankUserActivationForm.class).fill((Object)formValues);
        return Banks.ok((Content)bankUserActivationQuestion.render(banks2, (Form<BankUserActivationForm>)form, activate, inDetails, flashMap, request, messages));
    }

    public CompletionStage<Result> deactivate(Http.Request request) {
        play.i18n.Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(BankUserActivationForm.class).bindFromRequest(request, new String[0]);
        List<Integer> ids = GeneralUtils.getSelectionIds(((BankUserActivationForm)form.get()).bankIDs);
        return CompletableFuture.supplyAsync(() -> this.toggleActivate(false, messages, operatingUser, ids, ((BankUserActivationForm)form.get()).forAllUsers), this.executionContext.current());
    }

    public CompletionStage<Result> activate(Http.Request request) {
        play.i18n.Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(BankUserActivationForm.class).bindFromRequest(request, new String[0]);
        List<Integer> ids = GeneralUtils.getSelectionIds(((BankUserActivationForm)form.get()).bankIDs);
        return CompletableFuture.supplyAsync(() -> this.toggleActivate(true, messages, operatingUser, ids, ((BankUserActivationForm)form.get()).forAllUsers), this.executionContext.current());
    }

    private Result toggleActivate(boolean activate, play.i18n.Messages messages, User operatingUser, List<Integer> bankIds, Map<Integer, Boolean> forAllUsers) {
        HashMap<String, String> flashMap = new HashMap<String, String>();
        ArrayList<BankUser> bankUsers = new ArrayList<BankUser>();
        for (Integer n : bankIds) {
            BankSettings bank = operatingUser.isAdminOrTenantAdmin() ? (BankSettings)DB.find(BankSettings.class).where().eq("bankId", (Object)n).findOne() : BankSettings.getByIdAndUser((Integer)n, (User)operatingUser);
            if (bank == null) continue;
            if (operatingUser.isAdminOrTenantAdmin() && forAllUsers != null && forAllUsers.containsKey(bank.getBankId()) && forAllUsers.get(bank.getBankId()).booleanValue()) {
                List bankUsersToAdd = BankUser.findActiveBankUsersForBank((BankSettings)bank);
                bankUsers.addAll(bankUsersToAdd);
                continue;
            }
            BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)operatingUser);
            if (bankUser == null) {
                Object flashMessage = messages.at("bank.error.bankUserOnly", new Object[0]);
                String bankName = bank.getDisplayName();
                if (bankName != null && !bankName.isEmpty()) {
                    flashMessage = bankName + ": " + (String)flashMessage;
                }
                Utils.addToFlash(flashMap, "warning", (String)flashMessage);
                continue;
            }
            if (activate && BankUtils.isReady((BankUser)bankUser)) {
                Utils.addToFlash(flashMap, "warning", messages.at("bank.activate.alreadyActive", new Object[]{bank.getDisplayName(), bankUser.getUser().getName()}));
                continue;
            }
            if (!activate && BankUtils.isDeactivated((BankUser)bankUser)) {
                Utils.addToFlash(flashMap, "warning", messages.at("bank.activate.alreadyDeactivated", new Object[]{bank.getDisplayName(), bankUser.getUser().getName()}));
                continue;
            }
            bankUsers.add(bankUser);
        }
        if (bankUsers.isEmpty()) {
            Utils.addToFlash(flashMap, "warning", messages.at("bank.edit.error.nothingToEdit", new Object[0]));
            return Banks.redirect((Call)routes.Banks.index()).flashing(flashMap);
        }
        try {
            String successMsgKey = activate ? "bank.activate.forUser.success" : "bank.deactivate.forUser.success";
            for (BankUser bankUser : bankUsers) {
                if (bankUser.isDeactivated() != activate) continue;
                bankUser.setDeactivated(!activate);
                bankUser.save();
                Utils.addToFlash(flashMap, "success", messages.at(successMsgKey, new Object[]{bankUser.getBank().getDisplayName(), bankUser.getUser().getName()}));
            }
        }
        catch (Exception e) {
            String string = activate ? "Error activating bank(s): " : "Error deactivating bank(s): ";
            BLLoggerPlay.error(string, e);
            String errorKey = activate ? "bank.activate.error" : "bank.deactivate.error";
            Utils.addToFlash(flashMap, "error", messages.at(errorKey, new Object[0]));
            return Banks.redirect((Call)routes.Banks.index()).flashing(flashMap);
        }
        return Banks.redirect((Call)routes.Banks.index()).flashing(flashMap);
    }

    public CompletionStage<Result> deleteQuestion(Http.Request request) {
        return CompletableFuture.supplyAsync(() -> Banks.deleteBanksQuestion(request, null, this.messagesApi, this.formFactory), this.executionContext.current());
    }

    public static Result deleteBanksQuestion(Http.Request request, Integer bankId, MessagesApi messagesApi, FormFactory formFactory) {
        boolean inDetails;
        String ids;
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (bankId != null) {
            ids = bankId.toString();
            inDetails = true;
        } else {
            ids = ((SimpleTextForm)formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            inDetails = false;
        }
        if (!Banks.canUserDeleteBanks(operatingUser)) {
            return Banks.redirect((Call)routes.Banks.index()).flashing("warning", messages.at("bank.delete.error.noAdmin", new Object[0]));
        }
        ArrayList<BankSettings> banksToBeDeleted = new ArrayList<BankSettings>();
        HashMap<String, String> flashMap = new HashMap<String, String>();
        for (Integer id : GeneralUtils.getSelectionIds(ids)) {
            BankSettings bank = (BankSettings)DB.find(BankSettings.class).where().eq("bankId", (Object)id).findOne();
            if (Banks.canUserSeeBank(operatingUser, bank)) {
                List<BankUser> activeUsers = BankUser.findActiveBankUsersForBank((BankSettings)bank).stream().filter(bu -> bu.getState() == BankUser.UserState.READY).toList();
                List<BankUser> activeOtherUsers = activeUsers.stream().filter(bu -> !bu.getUser().getId().equals(operatingUser.getId())).toList();
                if (!activeOtherUsers.isEmpty()) {
                    Utils.addToFlash(flashMap, "error", messages.at("bank.delete.error.cantDeleteActiveUsers", new Object[]{bank.getDisplayName(), activeOtherUsers.size()}));
                    continue;
                }
                banksToBeDeleted.add(bank);
                if (activeUsers.isEmpty()) continue;
                Utils.addToFlash(flashMap, "warning", messages.at("bank.delete.warning.activeUser", new Object[]{operatingUser.getName(), bank.getDisplayName()}));
                continue;
            }
            if (bank == null) continue;
            Utils.addToFlash(flashMap, "error", messages.at("bank.delete.error.cantDelete", new Object[]{bank.getDisplayName()}));
        }
        if (banksToBeDeleted.isEmpty()) {
            Utils.addToFlash(flashMap, "warning", messages.at("bank.delete.error.nothingToDelete", new Object[0]));
            return Banks.redirect((Call)routes.Banks.index()).flashing(flashMap);
        }
        HashMap<BankSettings, List<String>> bankInfo = new HashMap<BankSettings, List<String>>();
        for (BankSettings b : banksToBeDeleted) {
            List<String> info = BankDeleteHandler.prepareDeleteQuestion(Collections.singletonList(b), messages.lang().toLocale());
            bankInfo.put(b, info);
        }
        return Banks.ok((Content)deleteBankQuestion.render(banksToBeDeleted, bankInfo, inDetails, flashMap, request, messages));
    }

    public CompletionStage<Result> delete(Http.Request request) {
        play.i18n.Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        return CompletableFuture.supplyAsync(() -> {
            if (!Banks.canUserDeleteBanks(operatingUser)) {
                return Banks.redirect((Call)routes.Banks.index()).flashing("error", messages.at("bank.delete.error.noAdmin", new Object[0]));
            }
            ArrayList<BankSettings> banks2 = new ArrayList<BankSettings>();
            for (Integer id : GeneralUtils.getSelectionIds(ids)) {
                BankSettings bank = operatingUser.isAdmin() ? (BankSettings)DB.find(BankSettings.class).where().eq("bankId", (Object)id).findOne() : BankSettings.getByIdForManagedTenants((Integer)id, (User)operatingUser);
                if (bank == null) continue;
                banks2.add(bank);
            }
            if (banks2.isEmpty()) {
                return Banks.redirect((Call)routes.Banks.index()).flashing("warning", messages.at("bank.delete.error.nothingToDelete", new Object[0]));
            }
            try {
                BankDeleteHandler.deleteBanks(banks2, operatingUser);
            }
            catch (Exception e) {
                BLLoggerPlay.error("Error deleting bank(s):", e);
                return Banks.redirect((Call)routes.Banks.index()).flashing("error", e.toString());
            }
            return Banks.redirect((Call)routes.Banks.index()).flashing("success", messages.at("bank.delete.success", new Object[]{banks2.size()}));
        }, this.executionContext.current());
    }

    public Result changeSignatureVersionGet(Http.Request request, int id) {
        return Banks.changeSignatureVersion(request, id, routes.Banks.index(), this.messagesApi, this.formFactory);
    }

    public static Result changeSignatureVersion(Http.Request request, int id, play.api.mvc.Call redirect, MessagesApi messagesApi, FormFactory formFactory) {
        User user;
        boolean inDetails = !redirect.equals((Object)routes.Banks.index());
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        BankSettings bank = BankSettings.getById((Integer)id);
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)(user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)))));
        if (bankUser == null) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.bankUserOnly", new Object[0]));
        }
        if (!BankUtils.isReady((BankUser)bankUser)) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.readyOnly", new Object[0]));
        }
        Form form = formFactory.form(RenewKeysForm.class).fill((Object)RenewKeysForm.fill(bankUser));
        return Banks.ok((Content)renewKeys.render(bankUser, (Form<RenewKeysForm>)form, WebAuthnData.build(user), inDetails, BankDetailsForm.Tab.BANK.label, request, messages));
    }

    public CompletionStage<Result> changeSignatureVersionPost(Http.Request request, int id) {
        return CompletableFuture.supplyAsync(() -> Banks.changeSignatureVersionPost(request, id, routes.Banks.index(), this.messagesApi, this.formFactory), this.executionContext.current());
    }

    protected static Result changeSignatureVersionPost(Http.Request request, int id, play.api.mvc.Call redirect, MessagesApi messagesApi, FormFactory formFactory) {
        boolean inDetails = !redirect.equals((Object)routes.Banks.index());
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = formFactory.form(RenewKeysForm.class).bindFromRequest(request, new String[0]);
        BankSettings bank = BankSettings.getById((Integer)id);
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        if (bankUser == null) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.bankUserOnly", new Object[0]));
        }
        if (!BankUtils.isReady((BankUser)bankUser)) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.readyOnly", new Object[0]));
        }
        Form passwordResultForm = Banks.checkPassword(form, user, messages.lang().locale());
        if (passwordResultForm.hasErrors()) {
            if (passwordResultForm.value().isPresent() && ((RenewKeysForm)passwordResultForm.value().get()).isUserLocked()) {
                BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                return Banks.redirect((Call)redirect).flashing("error", messages.at("login.locked.user", new Object[0]));
            }
            return Banks.ok((Content)renewKeys.render(bankUser, passwordResultForm, WebAuthnData.build(user), inDetails, BankDetailsForm.Tab.BANK.label, request, messages));
        }
        RenewKeysForm data = (RenewKeysForm)form.get();
        SimplePasswordCallback passwordCallback = new SimplePasswordCallback(data.password.toCharArray());
        SignatureVersionChanger changer = new SignatureVersionChanger(bankUser, SignatureVersion.getInstance((String)data.getSignatureVersion()), data.getSigKeyLength(), data.getEncKeyLength(), data.getAuthKeyLength(), ProtocolVersion.getInstance((String)bank.getProtocolVersion())){

            protected void addSignature(byte[] arg0, PasswordCallback arg1) {
            }
        };
        try {
            EbicsWorker worker = EbicsUtil.getEbicsWorker(bankUser, passwordCallback.getPassword());
            changer.createNewKeys((IProgressMonitorWrapper)ProgressMonitorDummy.getInstance(), worker, false);
            changer.changeSignatureVersion((PasswordCallback)passwordCallback, (PasswordCallback)passwordCallback, worker);
            return Banks.redirect((Call)redirect).flashing("success", messages.at("bank.renewkeys.success.keysRenewed", new Object[]{bank.getDisplayName()}));
        }
        catch (Exception e) {
            String error = messages.at("bank.renewkeys.error.server", new Object[]{bank.getDisplayName(), e.toString()});
            String flashKey = "error";
            if (e instanceof EbicsException) {
                error = BankingApiMessages.getErrorMessageWeb((Exception)e, (Locale)messages.lang().locale());
                flashKey = "HTMLerror";
            }
            BLLoggerPlay.error(e.toString(), e);
            return Banks.redirect((Call)redirect).flashing(flashKey, error);
        }
    }

    public Result lockBankGet(Http.Request request, int id) {
        return Banks.lockBankGet(request, id, routes.Banks.index(), this.messagesApi, this.formFactory);
    }

    protected static Result lockBankGet(Http.Request request, int id, play.api.mvc.Call redirect, MessagesApi messagesApi, FormFactory formFactory) {
        boolean inDetails = !redirect.equals((Object)routes.Banks.index());
        BankSettings bank = BankSettings.getById((Integer)id);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        if (bankUser == null) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.bankUserOnly", new Object[0]));
        }
        if (!BankUtils.isReady((BankUser)bankUser)) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.readyOnly", new Object[0]));
        }
        Form form = formFactory.form(PasswordForm.class);
        return Banks.ok((Content)lockBank.render(bankUser, (Form<PasswordForm>)form, WebAuthnData.build(user), inDetails, BankDetailsForm.Tab.BANK.label, request, messagesApi.preferred((Http.RequestHeader)request)));
    }

    public CompletionStage<Result> lockBankPost(Http.Request request, int id) {
        return CompletableFuture.supplyAsync(() -> Banks.lockBankPost(request, id, routes.Banks.index(), this.messagesApi, this.formFactory), this.executionContext.current());
    }

    protected static Result lockBankPost(Http.Request request, int id, play.api.mvc.Call redirect, MessagesApi messagesApi, FormFactory formFactory) {
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = formFactory.form(PasswordForm.class).bindFromRequest(request, new String[0]);
        boolean inDetails = !redirect.equals((Object)routes.Banks.index());
        BankSettings bank = BankSettings.getById((Integer)id);
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        if (bankUser == null) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.bankUserOnly", new Object[0]));
        }
        if (!BankUtils.isReady((BankUser)bankUser)) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.readyOnly", new Object[0]));
        }
        Form passwordResultForm = Banks.checkPassword(form, user, messages.lang().locale());
        if (passwordResultForm.hasErrors()) {
            if (passwordResultForm.value().isPresent() && ((PasswordForm)passwordResultForm.value().get()).isUserLocked()) {
                BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                return Banks.redirect((Call)redirect).flashing("error", messages.at("login.locked.user", new Object[0]));
            }
            return Banks.ok((Content)lockBank.render(bankUser, passwordResultForm, WebAuthnData.build(user), inDetails, BankDetailsForm.Tab.BANK.label, request, messages));
        }
        try {
            EbicsWorker worker = EbicsUtil.getEbicsWorker(bankUser, ((PasswordForm)form.get()).password.toCharArray());
            worker.lockUser();
            return Banks.redirect((Call)redirect).flashing("success", messages.at("bank.lockbank.success.bankLocked", new Object[]{bank.getDisplayName()}));
        }
        catch (EbicsException | IOException | GeneralSecurityException e) {
            BLLoggerPlay.error(e.toString(), e);
            String error = BankingApiMessages.getErrorMessageWeb((Exception)e, (Locale)messages.lang().locale());
            return Banks.redirect((Call)redirect).flashing("HTMLerror", messages.at("bank.lockbank.error.server", new Object[]{bank.getDisplayName(), error}));
        }
    }

    public Result reIniGet(Http.Request request, int id) {
        return Banks.reIni(request, id, this.messagesApi, this.formFactory, routes.Banks.index());
    }

    protected static Result reIni(Http.Request request, int id, MessagesApi messagesApi, FormFactory formFactory, play.api.mvc.Call redirect) {
        boolean inDetails = !redirect.equals((Object)routes.Banks.index());
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (user.isLocalUser()) {
            return Banks.redirect((Call)redirect).flashing("error", messages.at("bank.error.localUser", new Object[0]));
        }
        BankSettings bank = BankSettings.getById((Integer)id);
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        if (bankUser == null || BankUtils.isDeactivated((BankUser)bankUser)) {
            String message;
            String flashKey;
            if (user.isAdminOrTenantAdmin()) {
                flashKey = "warning";
                message = messages.at("bank.error.bankUserOnly", new Object[0]);
            } else {
                flashKey = "error";
                message = messages.at("bank.error.deactivated", new Object[0]);
            }
            return Banks.redirect((Call)redirect).flashing(flashKey, message);
        }
        Form form = formFactory.form(ReIniForm.class).fill((Object)ReIniForm.fill(bankUser));
        return Banks.ok((Content)reIni.render(bank, (Form<ReIniForm>)form, WebAuthnData.build(user), inDetails, BankDetailsForm.Tab.BANK.label, request, messages));
    }

    public CompletionStage<Result> reIniPost(Http.Request request, int id) {
        return CompletableFuture.supplyAsync(() -> Banks.reIniPost(request, id, this.messagesApi, this.formFactory, routes.Banks.index()), this.executionContext.current());
    }

    protected static Result reIniPost(Http.Request request, int id, MessagesApi messagesApi, FormFactory formFactory, play.api.mvc.Call redirect) {
        boolean inDetails = !redirect.equals((Object)routes.Banks.index());
        Form form = formFactory.form(ReIniForm.class).bindFromRequest(request, new String[0]);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        BankSettings bank = BankSettings.getById((Integer)id);
        BankUser oldBankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        Form passwordResultForm = Banks.checkPassword(form, user, messages.lang().locale());
        if (passwordResultForm.hasErrors()) {
            if (passwordResultForm.value().isPresent() && ((ReIniForm)passwordResultForm.value().get()).isUserLocked()) {
                BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                return Banks.redirect((Call)routes.Banks.index()).flashing("error", messages.at("login.locked.user", new Object[0]));
            }
            return Banks.ok((Content)reIni.render(bank, passwordResultForm, WebAuthnData.build(user), inDetails, BankDetailsForm.Tab.BANK.label, request, messages));
        }
        if (oldBankUser == null) {
            return Banks.ok((Content)reIni.render(bank, (Form<ReIniForm>)form.withGlobalError("bank.error.noSuchBank"), WebAuthnData.build(user), inDetails, BankDetailsForm.Tab.BANK.label, request, messages));
        }
        try {
            BankUser newBankUser = ((ReIniForm)form.get()).createTemporaryBankUser(user, bank, oldBankUser);
            EbicsUtil.initializeUser(bank, user, newBankUser, ((ReIniForm)form.get()).password.toCharArray(), messagesApi.preferred((Http.RequestHeader)request).lang().locale());
        }
        catch (Exception e) {
            String errorMsg = GeneralUtils.getIniErrorMessage(e, messages, bank);
            return Banks.ok((Content)reIni.render(bank, (Form<ReIniForm>)form.withGlobalError(errorMsg), WebAuthnData.build(user), inDetails, BankDetailsForm.Tab.BANK.label, request, messages));
        }
        if (inDetails) {
            return Banks.ok((Content)iniComplete.render(Collections.singletonList(bank), id, null, request, messagesApi.preferred((Http.RequestHeader)request)));
        }
        return Banks.ok((Content)iniComplete.render(Collections.singletonList(bank), null, null, request, messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result showIniLetter(Http.Request request, int bankId) {
        return Banks.showIniLetter(request, bankId, routes.Banks.index(), this.messagesApi);
    }

    protected static Result showIniLetter(Http.Request request, int bankId, play.api.mvc.Call redirect, MessagesApi messagesApi) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        BankSettings bank = BankSettings.getById((Integer)bankId);
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        if (bankUser == null) {
            String message;
            String flashKey;
            if (user.isAdminOrTenantAdmin()) {
                flashKey = "warning";
                message = messages.at("bank.error.bankUserOnly", new Object[0]);
            } else {
                flashKey = "error";
                message = messages.at("bank.error.noSuchBank", new Object[0]);
            }
            return Banks.redirect((Call)redirect).flashing(flashKey, message);
        }
        try {
            File iniLetter = EbicsWorker.getINILetter((BankUser)bankUser);
            if (!iniLetter.exists()) {
                return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.noIniLetter", new Object[0]));
            }
            return GeneralUtils.supplyWorkspaceFile(iniLetter, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(bank.getDisplayName() + " - " + bankUser.getDefaultUser() + ".pdf"));
        }
        catch (IOException | GeneralSecurityException e) {
            return Banks.redirect((Call)redirect).flashing("error", messages.at("error.supplyingfile", new Object[]{e.toString()}));
        }
    }

    public CompletionStage<Result> updateProtocolVersionGet(Http.Request request, int id) {
        return CompletableFuture.supplyAsync(() -> Banks.updateProtocolVersionGet(request, id, this.messagesApi, this.formFactory, routes.Banks.index()), this.executionContext.current());
    }

    protected static Result updateProtocolVersionGet(Http.Request request, int id, MessagesApi messagesApi, FormFactory formFactory, play.api.mvc.Call redirect) {
        ProtocolVersion targetVersion;
        BankSettings bank;
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!Banks.canUserModifyBank(operatingUser, bank = BankSettings.getById((Integer)id))) {
            return Banks.redirect((Call)redirect).flashing("error", messages.at("bank.protocolversion.error.noAdmin", new Object[0]));
        }
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)operatingUser);
        if (bankUser == null) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.bankUserOnly", new Object[0]));
        }
        if (!BankUtils.isReady((BankUser)bankUser)) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.readyOnly", new Object[0]));
        }
        ProtocolVersion currentVersion = ProtocolVersion.getInstance((String)bank.getProtocolVersion());
        try {
            targetVersion = Banks.determineLatestProtocolVersion(bankUser, true);
        }
        catch (EbicsException | IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("An error occurred while fetching HPD", e);
            String error = Utils.getLocalizedMessage(e, messages);
            return Banks.redirect((Call)redirect).flashing("HTMLerror", messages.at("bank.protocolversion.errorFetchingBankParams", new Object[]{error}));
        }
        if (targetVersion == null) {
            return Banks.redirect((Call)redirect).flashing("info", messages.at("bank.protocolversion.unknown", new Object[0]));
        }
        if (targetVersion.compareTo(currentVersion) <= 0) {
            return Banks.redirect((Call)redirect).flashing("info", messages.at("bank.protocolversion.alreadyuptodate", new Object[]{bank.getDisplayName(), currentVersion.getValue()}));
        }
        return Banks.prepareUpgradeProtocolVersion(request, messages, bank, bankUser, currentVersion, targetVersion, formFactory, redirect);
    }

    public CompletionStage<Result> changeProtocolVersionGet(Http.Request request, int id, String toVersion) {
        return CompletableFuture.supplyAsync(() -> Banks.changeProtocolVersionGet(request, id, toVersion, this.messagesApi, this.formFactory, routes.Banks.index()), this.executionContext.current());
    }

    protected static Result changeProtocolVersionGet(Http.Request request, int id, String toVersion, MessagesApi messagesApi, FormFactory formFactory, play.api.mvc.Call redirect) {
        BankSettings bank;
        boolean inDetails = !redirect.equals((Object)routes.Banks.index());
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!Banks.canUserModifyBank(operatingUser, bank = BankSettings.getById((Integer)id))) {
            return Banks.redirect((Call)redirect).flashing("error", messages.at("bank.protocolversion.error.noAdmin", new Object[0]));
        }
        if (toVersion == null) {
            return Banks.redirect((Call)redirect).flashing("error", messages.at("bank.protocolversion.error.noTargetVersion", new Object[0]));
        }
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)operatingUser);
        if (bankUser == null) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.bankUserOnly", new Object[0]));
        }
        if (!BankUtils.isReady((BankUser)bankUser)) {
            return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.readyOnly", new Object[0]));
        }
        ProtocolVersion currentVersion = ProtocolVersion.getInstance((String)bank.getProtocolVersion());
        ProtocolVersion targetVersion = ProtocolVersion.getInstance((String)toVersion);
        try {
            Set<ProtocolVersion> supportedVersions = Banks.determineSupportedProtocolVersions(bankUser, true);
            if (supportedVersions == null) {
                return Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.protocolversion.unknown", new Object[0]));
            }
            if (supportedVersions.stream().noneMatch(arg_0 -> ((ProtocolVersion)targetVersion).equals(arg_0))) {
                return Banks.redirect((Call)redirect).flashing("error", messages.at("bank.protocolversion.notAvailable", new Object[]{targetVersion.getValue(), bank.getDisplayName()}));
            }
        }
        catch (EbicsException | IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("An error occurred while fetching HPD", e);
            String error = Utils.getLocalizedMessage(e, messages);
            return Banks.redirect((Call)redirect).flashing("HTMLerror", messages.at("bank.protocolversion.errorFetchingBankParams", new Object[]{error}));
        }
        if (targetVersion.compareTo(currentVersion) == 0) {
            return Banks.redirect((Call)redirect).flashing("info", messages.at("bank.protocolversion.alreadyused", new Object[]{bank.getDisplayName(), currentVersion.getValue()}));
        }
        if (targetVersion.compareTo(currentVersion) < 0) {
            return Banks.ok((Content)protocolversion.render(bank, currentVersion, targetVersion, null, inDetails, BankDetailsForm.Tab.BANK.label, request, messages));
        }
        return Banks.prepareUpgradeProtocolVersion(request, messages, bank, bankUser, currentVersion, targetVersion, formFactory, redirect);
    }

    private static Result prepareUpgradeProtocolVersion(Http.Request request, play.i18n.Messages messages, BankSettings bank, BankUser bankUser, ProtocolVersion currentVersion, ProtocolVersion targetVersion, FormFactory formFactory, play.api.mvc.Call redirect) {
        List<BankUser> bankUsersNotReadyForH005;
        boolean inDetails = !redirect.equals((Object)routes.Banks.index());
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (currentVersion.compareTo(ProtocolVersion.H004) <= 0 && targetVersion.compareTo(ProtocolVersion.H004) > 0 && !(bankUsersNotReadyForH005 = Banks.getBankUsersNotReadyForH005(bank)).isEmpty()) {
            String userNames = bankUsersNotReadyForH005.stream().map(b -> b.getUser().getName()).collect(Collectors.joining(", "));
            int minKeyLength = new KeyUtil(targetVersion).getMinKeyLength(KeyUtil.KeyType.A006);
            String flashMsg = messages.at("bank.protocolversion.usersNotReady", new Object[]{bank.getDisplayName(), ProtocolVersion.H005, minKeyLength, userNames});
            targetVersion = ProtocolVersion.H004;
            if (targetVersion.compareTo(currentVersion) <= 0) {
                return Banks.redirect((Call)redirect).flashing("warning", flashMsg);
            }
            Utils.addToFlash(flashMap, "warning", flashMsg);
        }
        Form form = null;
        if (currentVersion.compareTo(ProtocolVersion.H002) <= 0 && targetVersion.compareTo(ProtocolVersion.H002) > 0) {
            try {
                ProtocolVersionForm data = ProtocolVersionForm.fill(bankUser);
                form = formFactory.form(ProtocolVersionForm.class).fill((Object)data);
            }
            catch (EbicsException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("An error occurred while fetching HPB", e);
                if (e instanceof EbicsException) {
                    String error = BankingApiMessages.getErrorMessageWeb((Exception)e, (Locale)messages.lang().locale());
                    form = formFactory.form(ProtocolVersionForm.class).withGlobalError(error);
                }
                form = formFactory.form(ProtocolVersionForm.class).withGlobalError("bank.protocolversion.errorFetchingBankKeys", (List)ImmutableList.of((Object)e.toString()));
            }
        }
        return Banks.ok((Content)protocolversion.render(bank, currentVersion, targetVersion, form, inDetails, BankDetailsForm.Tab.BANK.label, request, messages)).flashing(flashMap);
    }

    private static Set<ProtocolVersion> determineSupportedProtocolVersions(BankUser bankUser, boolean forceNewHPDFetch) throws IOException, EbicsException, GeneralSecurityException {
        EbicsSession session;
        HPDResponseOrderData hpd;
        if (forceNewHPDFetch) {
            bankUser.getBank().setBankParameters(null);
        }
        if ((hpd = (session = EbicsUtil.getEbicsWorker(bankUser).getEbicsSession()).getBankParameters()) == null) {
            return null;
        }
        HPDProtocolParams protocolParams = hpd.getProtocolParams();
        if (protocolParams == null) {
            return null;
        }
        HashSet<ProtocolVersion> versions = new HashSet<ProtocolVersion>((Collection<ProtocolVersion>)protocolParams.getVersion().getProtocol());
        try {
            EbicsHEVResponse hev = session.getEbicsVersions();
            for (EbicsHEVResponse.VersionNumber versionNumber : hev.getVersionNumbers()) {
                versions.add(ProtocolVersion.getInstance((String)versionNumber.getProtocolVersion()));
            }
        }
        catch (Exception e) {
            BLLoggerPlay.error("can not find protocol version via HEV", e);
        }
        return versions;
    }

    private static ProtocolVersion determineLatestProtocolVersion(BankUser bankUser, boolean forceHPDUpdate) throws IOException, EbicsException, GeneralSecurityException {
        Set<ProtocolVersion> supportedVersions = Banks.determineSupportedProtocolVersions(bankUser, forceHPDUpdate);
        if (supportedVersions == null) {
            return null;
        }
        ProtocolVersion latestProtocolVersion = null;
        for (ProtocolVersion version : supportedVersions) {
            if (ProtocolVersion.H005.equals((Object)version)) {
                // empty if block
            }
            if (latestProtocolVersion != null && latestProtocolVersion.compareTo(version) >= 0) continue;
            latestProtocolVersion = version;
        }
        return latestProtocolVersion;
    }

    private static List<BankUser> getBankUsersNotReadyForH005(BankSettings bank) {
        ArrayList<BankUser> result = new ArrayList<BankUser>();
        for (BankUser activeBankUser : BankUser.findActiveNonLocalBankUsersForBank((BankSettings)bank)) {
            if (!KeyUtil.newKeysRequired((BankUser)activeBankUser, (ProtocolVersion)ProtocolVersion.H005)) continue;
            result.add(activeBankUser);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected static Result upgradeProtocolVersionPost(Http.Request request, int id, String targetVersion, boolean withPostData, MessagesApi messagesApi, FormFactory formFactory, play.api.mvc.Call redirect) {
        block55: {
            inDetails = redirect.equals((Object)routes.Banks.index()) == false;
            operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            messages = messagesApi.preferred((Http.RequestHeader)request);
            bank = BankSettings.getById((Integer)id);
            if (!Banks.canUserModifyBank(operatingUser, bank)) {
                return Banks.redirect((Call)redirect).flashing("error", messages.at("bank.protocolversion.error.noAdmin", new Object[0]));
            }
            flashMap = new HashMap<String, String>();
            t = DB.beginTransaction();
            try {
                logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
                bankUser = BankUser.findBankUser((BankSettings)bank, (User)operatingUser);
                if (bankUser == null) {
                    var15_17 = Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.bankUserOnly", new Object[0]));
                    return var15_17;
                }
                if (!BankUtils.isReady((BankUser)bankUser)) {
                    var15_18 = Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.readyOnly", new Object[0]));
                    return var15_18;
                }
                hashes = null;
                currentVersion = ProtocolVersion.getInstance((String)bank.getProtocolVersion());
                actualNewVersion = targetNewVersion = ProtocolVersion.getInstance((String)targetVersion);
                if (withPostData) {
                    form = formFactory.form(ProtocolVersionForm.class).bindFromRequest(request, new String[0]);
                    if (form.hasErrors()) {
                        var20_25 = Banks.ok((Content)protocolversion.render(bank, currentVersion, targetNewVersion, (Form<ProtocolVersionForm>)form, inDetails, BankDetailsForm.Tab.BANK.label, request, messages));
                        return var20_25;
                    }
                    hashes = (ProtocolVersionForm)form.get();
                }
                protocolVersionChanged = false;
                hashesChanged = false;
                if (currentVersion.compareTo(ProtocolVersion.H002) <= 0 && targetNewVersion.compareTo(ProtocolVersion.H002) > 0) {
                    if (hashes != null) {
                        bank.setExpectedDigestE002(hashes.getEncHash());
                        bank.setExpectedDigestX002(hashes.getAuthHash());
                        hashesChanged = true;
                    }
                    bank.setProtocolVersion(ProtocolVersion.H003.getValue());
                    protocolVersionChanged = true;
                }
                if (currentVersion.compareTo(ProtocolVersion.H003) <= 0 && targetNewVersion.compareTo(ProtocolVersion.H003) > 0) {
                    bank.setProtocolVersion(ProtocolVersion.H004.getValue());
                    protocolVersionChanged = true;
                }
                updateToEbics3 = false;
                if (currentVersion.compareTo(ProtocolVersion.H004) <= 0 && targetNewVersion.compareTo(ProtocolVersion.H004) > 0) {
                    bankUsersNotReadyForH005 = Banks.getBankUsersNotReadyForH005(bank);
                    if (!bankUsersNotReadyForH005.isEmpty()) {
                        userNames = bankUsersNotReadyForH005.stream().map((Function<BankUser, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$upgradeProtocolVersionPost$20(de.businesslogics.banking.database.vo.BankUser ), (Lde/businesslogics/banking/database/vo/BankUser;)Ljava/lang/String;)()).collect(Collectors.joining(", "));
                        minKeyLength = new KeyUtil(targetNewVersion).getMinKeyLength(KeyUtil.KeyType.A006);
                        flashMsg = messages.at("bank.protocolversion.usersNotReady", new Object[]{bank.getDisplayName(), ProtocolVersion.H005, minKeyLength, userNames});
                        Utils.addToFlash(flashMap, "warning", flashMsg);
                        actualNewVersion = ProtocolVersion.H004;
                    } else {
                        bank.setProtocolVersion(ProtocolVersion.H005.getValue());
                        migrator = new Ebics30Migrator(bank, BLLoggerPlay.getLogger());
                        migrator.migrate();
                        protocolVersionChanged = true;
                        updateToEbics3 = true;
                    }
                }
                bank.save();
                t.commit();
                if (protocolVersionChanged) {
                    logger.logEbicsVersionChanged(operatingUser, bank, currentVersion.getValue());
                }
                if (hashesChanged) {
                    logger.logBankDigestModified(operatingUser, "E002", bank, hashes.getEncHash());
                    logger.logBankDigestModified(operatingUser, "X002", bank, hashes.getAuthHash());
                }
                if (protocolVersionChanged) {
                    Utils.addToFlash(flashMap, "success", messages.at("bank.protocolversion.upgrade.success", new Object[]{bank.getDisplayName(), actualNewVersion.getValue()}));
                } else {
                    Utils.addToFlash(flashMap, "warning", messages.at("bank.protocolversion.noUpdate", new Object[]{bank.getDisplayName(), currentVersion.getValue(), targetNewVersion.getValue()}));
                }
                if (!updateToEbics3) break block55;
                acceptHashes = new AcceptHashesHandler();
                try {
                    Banks.updateHPB(bankUser, acceptHashes);
                    ** GOTO lbl88
                }
                catch (DifferingKeyDigestException e) {
                    BLLoggerPlay.error(e.getMessage());
                    formValues = new UpdateBankKeysForm();
                    formValues.setHandlerForBank(id, acceptHashes);
                    form = formFactory.form(UpdateBankKeysForm.class).fill((Object)formValues);
                    var26_37 = Banks.ok((Content)updateBankKeys.render(Collections.singletonList(bank), String.valueOf(id), (Form<UpdateBankKeysForm>)form, inDetails, flashMap, BankDetailsForm.Tab.BANK.label, request, messages));
                    if (t != null) {
                        t.close();
                    }
                    return var26_37;
                }
                catch (EbicsException | IOException | GeneralSecurityException e) {
                    BLLoggerPlay.error("An error occurred while updating bank access " + bank.getDisplayName() + ":", e);
                    error = messages.at("bank.error.whileFetchingHTD", new Object[]{bank.getDisplayName()}) + " " + String.valueOf(e);
                    flashKey = "error";
                    if (e instanceof EbicsException) {
                        error = BankingApiMessages.getErrorMessageWeb((Exception)e, (Locale)messages.lang().locale());
                        flashKey = "HTMLerror";
                    }
                    Utils.addToFlash(flashMap, flashKey, (String)error);
lbl88:
                    // 2 sources

                    cmBank = CMBank.get((BankSettings)bank);
                    statementFetchType = cmBank.getStatementFetchType();
                    if (statementFetchType != null && !statementFetchType.isEmpty() && !BTFTranslator.isBTFString((String)statementFetchType)) {
                        type = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatements", (Object[])new Object[0]);
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{statementFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "statements");
                        }
                    }
                    if ((adviceFetchType = cmBank.getAdviceFetchType()) != null && !adviceFetchType.isEmpty() && !BTFTranslator.isBTFString((String)adviceFetchType)) {
                        type = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.advices", (Object[])new Object[0]);
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{adviceFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "statements");
                        }
                    }
                    if ((creditAdvicesForSepaInstantCreditTransfersFetchType = cmBank.getCreditAdviceFetchType()) != null && !creditAdvicesForSepaInstantCreditTransfersFetchType.isEmpty() && !BTFTranslator.isBTFString((String)creditAdvicesForSepaInstantCreditTransfersFetchType)) {
                        type = Messages.getString((Locale)messages.lang().locale(), (String)"CMBankPropertyPage.creditAdvicesForSepaInstantCreditTransfers", (Object[])new Object[0]);
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{creditAdvicesForSepaInstantCreditTransfersFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "statements");
                        }
                    }
                    if ((batchedTransactionFilesFetchType = cmBank.getC54FetchType()) != null && !batchedTransactionFilesFetchType.isEmpty() && !BTFTranslator.isBTFString((String)batchedTransactionFilesFetchType)) {
                        type = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.batchedTransactionFiles", (Object[])new Object[0]);
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{batchedTransactionFilesFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "statements");
                        }
                    }
                    if ((bkaFetchType = cmBank.getBkaFetchType()) != null && !bkaFetchType.isEmpty() && !BTFTranslator.isBTFString((String)bkaFetchType)) {
                        type = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.pdfStatements", (Object[])new Object[0]);
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{bkaFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "bka");
                        }
                    }
                    if ((bkiFetchType = cmBank.getBkiFetchType()) != null && !bkiFetchType.isEmpty() && !BTFTranslator.isBTFString((String)bkiFetchType)) {
                        type = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.otherPdfDocuments", (Object[])new Object[0]);
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{bkiFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "bka");
                        }
                    }
                    if ((notificationsSepaTransferFetchType = (notificationsHandler = NotificationSettings.getForBank((BankSettings)bank)).getFetchTypeForCreditNotifications()) != null && !notificationsSepaTransferFetchType.isEmpty() && !BTFTranslator.isBTFString((String)notificationsSepaTransferFetchType)) {
                        type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.sepaTransfers", new Object[0])});
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{notificationsSepaTransferFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                        }
                    }
                    if ((notificationsSepaInstantTransferFetchType = notificationsHandler.getFetchTypeForInstantNotifications()) != null && !notificationsSepaInstantTransferFetchType.isEmpty() && !BTFTranslator.isBTFString((String)notificationsSepaInstantTransferFetchType)) {
                        type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.sepaInstantTransfers", new Object[0])});
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{notificationsSepaInstantTransferFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                        }
                    }
                    if ((notificationsSepaDebitFetchType = notificationsHandler.getFetchTypeForDebitNotifications()) != null && !notificationsSepaDebitFetchType.isEmpty() && !BTFTranslator.isBTFString((String)notificationsSepaDebitFetchType)) {
                        type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.sepaDebits", new Object[0])});
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{notificationsSepaDebitFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                        }
                    }
                    if ((notificationsSepaCallbackFetchType = notificationsHandler.getFetchTypeForCallbackNotifications()) != null && !notificationsSepaCallbackFetchType.isEmpty() && !BTFTranslator.isBTFString((String)notificationsSepaCallbackFetchType)) {
                        type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.sepaCallbacks", new Object[0])});
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{notificationsSepaCallbackFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                        }
                    }
                    if ((notificationsSepaForeignFetchType = notificationsHandler.getFetchTypeForForeignNotifications()) != null && !notificationsSepaForeignFetchType.isEmpty() && !BTFTranslator.isBTFString((String)notificationsSepaForeignFetchType)) {
                        type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.sepaForeign", new Object[0])});
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{notificationsSepaForeignFetchType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                        }
                    }
                    if ((notificationsVopType = notificationsHandler.getFetchTypeForVopNotifications()) != null && !notificationsVopType.isEmpty() && !BTFTranslator.isBTFString((String)notificationsVopType)) {
                        type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.vop", new Object[0])});
                        Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingBtf", new Object[]{notificationsVopType, type}));
                        if (inDetails) {
                            redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                        }
                    }
                }
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        if (Utils.hasWarningFlash(flashMap) || Utils.hasErrorFlash(flashMap)) {
            return Banks.redirect((Call)redirect).flashing(flashMap);
        }
        return Banks.runHTDUpdate(request, operatingUser, messages, Collections.singletonList(id), flashMap, formFactory, redirect);
    }

    protected static Result printHTD(User user, play.i18n.Messages messages, List<Integer> ids, play.api.mvc.Call redirectTo) {
        List<BankSettings> banks2 = ids.stream().map(id -> BankSettings.getByIdAndUser((Integer)id, (User)user)).filter(Objects::nonNull).toList();
        if (banks2.isEmpty()) {
            return Banks.redirect((Call)routes.Banks.index()).flashing("error", messages.at("bank.error.noSuchBank", new Object[0]));
        }
        HashMap<BankUser, BankUserHtdInfo> htdInfoByBankUser = new HashMap<BankUser, BankUserHtdInfo>();
        for (BankSettings bankSettings : banks2) {
            BankUserHtdInfo htdInfo;
            BankUser bankUser = BankUser.findBankUser((BankSettings)bankSettings, (User)user);
            if (bankUser == null || (htdInfo = BankUserHtdInfo.findForBankUser((BankUser)bankUser)) == null) continue;
            htdInfoByBankUser.put(bankUser, htdInfo);
        }
        if (htdInfoByBankUser.isEmpty()) {
            return Banks.redirect((Call)redirectTo).flashing("warning", messages.at("bankdetails.htd.notFound", new Object[]{banks2.size()}));
        }
        try {
            ArrayList<File> fileList = new ArrayList<File>();
            for (Map.Entry entry : htdInfoByBankUser.entrySet()) {
                fileList.add(HTDPrinter.printHTD((Locale)Locale.getDefault(), (String)user.getName(), (BankUser)((BankUser)entry.getKey()), (BankUserHtdInfo)((BankUserHtdInfo)entry.getValue())));
            }
            if (fileList.size() == 1) {
                File file2 = (File)fileList.getFirst();
                return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
            }
            return GeneralUtils.supplyZipFile(fileList, true, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.userProfile", (Object[])new Object[0]) + ".zip"));
        }
        catch (PDFException | IOException | GeneralSecurityException e) {
            return Banks.redirect((Call)redirectTo).flashing("error", messages.at("bank.printUserProfile.error", new Object[0]));
        }
    }

    public CompletionStage<Result> upgradeProtocolVersionGet(Http.Request request, int id, String targetVersion) {
        return CompletableFuture.supplyAsync(() -> Banks.upgradeProtocolVersionPost(request, id, targetVersion, false, this.messagesApi, this.formFactory, routes.Banks.index()), this.executionContext.current());
    }

    public CompletionStage<Result> downgradeProtocolVersionPost(Http.Request request, int id, String targetVersion) {
        return CompletableFuture.supplyAsync(() -> Banks.downgradeProtocolVersionPost(request, id, targetVersion, this.messagesApi, this.formFactory, routes.Banks.index()), this.executionContext.current());
    }

    protected static Result downgradeProtocolVersionPost(Http.Request request, int id, String targetVersion, MessagesApi messagesApi, FormFactory formFactory, play.api.mvc.Call redirect) {
        BankSettings bank;
        boolean inDetails = !redirect.equals((Object)routes.Banks.index());
        play.i18n.Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!Banks.canUserModifyBank(operatingUser, bank = BankSettings.getById((Integer)id))) {
            return Banks.redirect((Call)redirect).flashing("error", messages.at("bank.protocolversion.error.noAdmin", new Object[0]));
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        boolean downgradedFromH005 = false;
        try (Transaction t = DB.beginTransaction();){
            AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
            BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)operatingUser);
            if (bankUser == null) {
                Result result = Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.bankUserOnly", new Object[0]));
                return result;
            }
            if (!BankUtils.isReady((BankUser)bankUser)) {
                Result result = Banks.redirect((Call)redirect).flashing("warning", messages.at("bank.error.readyOnly", new Object[0]));
                return result;
            }
            ProtocolVersion currentVersion = ProtocolVersion.getInstance((String)bank.getProtocolVersion());
            ProtocolVersion targetNewVersion = ProtocolVersion.getInstance((String)targetVersion);
            boolean protocolVersionChanged = false;
            if (currentVersion.compareTo(ProtocolVersion.H005) >= 0 && targetNewVersion.compareTo(ProtocolVersion.H005) < 0) {
                bank.setProtocolVersion(ProtocolVersion.H004.getValue());
                protocolVersionChanged = true;
                downgradedFromH005 = true;
            }
            if (currentVersion.compareTo(ProtocolVersion.H004) >= 0 && targetNewVersion.compareTo(ProtocolVersion.H004) < 0) {
                bank.setProtocolVersion(ProtocolVersion.H003.getValue());
                protocolVersionChanged = true;
            }
            bank.save();
            t.commit();
            if (protocolVersionChanged) {
                logger.logEbicsVersionChanged(operatingUser, bank, currentVersion.getValue());
                Utils.addToFlash(flashMap, "success", messages.at("bank.protocolversion.downgrade.success", new Object[]{bank.getDisplayName(), targetNewVersion.getValue()}));
            } else {
                Utils.addToFlash(flashMap, "warning", messages.at("bank.protocolversion.noUpdate", new Object[]{bank.getDisplayName(), currentVersion.getValue(), targetNewVersion.getValue()}));
            }
        }
        if (Utils.hasWarningFlash(flashMap) || Utils.hasErrorFlash(flashMap)) {
            return Banks.redirect((Call)redirect).flashing(flashMap);
        }
        if (downgradedFromH005) {
            String notificationsVopType;
            String notificationsSepaForeignFetchType;
            String notificationsSepaCallbackFetchType;
            String notificationsSepaDebitFetchType;
            String notificationsSepaInstantTransferFetchType;
            NotificationSettings notificationsHandler;
            String notificationsSepaTransferFetchType;
            String bkiFetchType;
            String bkaFetchType;
            String batchedTransactionFilesFetchType;
            String creditAdvicesForSepaInstantCreditTransfersFetchType;
            String adviceFetchType;
            CMBank cmBank = CMBank.get((BankSettings)bank);
            String statementFetchType = cmBank.getStatementFetchType();
            if (statementFetchType != null && !statementFetchType.isEmpty() && BTFTranslator.isBTFString((String)statementFetchType)) {
                String type = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatements", (Object[])new Object[0]);
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{statementFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "statements");
                }
            }
            if ((adviceFetchType = cmBank.getAdviceFetchType()) != null && !adviceFetchType.isEmpty() && BTFTranslator.isBTFString((String)adviceFetchType)) {
                String type = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.advices", (Object[])new Object[0]);
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{adviceFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "statements");
                }
            }
            if ((creditAdvicesForSepaInstantCreditTransfersFetchType = cmBank.getCreditAdviceFetchType()) != null && !creditAdvicesForSepaInstantCreditTransfersFetchType.isEmpty() && BTFTranslator.isBTFString((String)creditAdvicesForSepaInstantCreditTransfersFetchType)) {
                String type = Messages.getString((Locale)messages.lang().locale(), (String)"CMBankPropertyPage.creditAdvicesForSepaInstantCreditTransfers", (Object[])new Object[0]);
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{creditAdvicesForSepaInstantCreditTransfersFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "statements");
                }
            }
            if ((batchedTransactionFilesFetchType = cmBank.getC54FetchType()) != null && !batchedTransactionFilesFetchType.isEmpty() && BTFTranslator.isBTFString((String)batchedTransactionFilesFetchType)) {
                String type = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.batchedTransactionFiles", (Object[])new Object[0]);
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{batchedTransactionFilesFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "statements");
                }
            }
            if ((bkaFetchType = cmBank.getBkaFetchType()) != null && !bkaFetchType.isEmpty() && BTFTranslator.isBTFString((String)bkaFetchType)) {
                String type = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.pdfStatements", (Object[])new Object[0]);
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{bkaFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "bka");
                }
            }
            if ((bkiFetchType = cmBank.getBkiFetchType()) != null && !bkiFetchType.isEmpty() && BTFTranslator.isBTFString((String)bkiFetchType)) {
                String type = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.otherPdfDocuments", (Object[])new Object[0]);
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{bkiFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "bka");
                }
            }
            if ((notificationsSepaTransferFetchType = (notificationsHandler = NotificationSettings.getForBank((BankSettings)bank)).getFetchTypeForCreditNotifications()) != null && !notificationsSepaTransferFetchType.isEmpty() && BTFTranslator.isBTFString((String)notificationsSepaTransferFetchType)) {
                String type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.sepaTransfers", new Object[0])});
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{notificationsSepaTransferFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                }
            }
            if ((notificationsSepaInstantTransferFetchType = notificationsHandler.getFetchTypeForInstantNotifications()) != null && !notificationsSepaInstantTransferFetchType.isEmpty() && BTFTranslator.isBTFString((String)notificationsSepaInstantTransferFetchType)) {
                String type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.sepaInstantTransfers", new Object[0])});
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{notificationsSepaInstantTransferFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                }
            }
            if ((notificationsSepaDebitFetchType = notificationsHandler.getFetchTypeForDebitNotifications()) != null && !notificationsSepaDebitFetchType.isEmpty() && BTFTranslator.isBTFString((String)notificationsSepaDebitFetchType)) {
                String type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.sepaDebits", new Object[0])});
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{notificationsSepaDebitFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                }
            }
            if ((notificationsSepaCallbackFetchType = notificationsHandler.getFetchTypeForCallbackNotifications()) != null && !notificationsSepaCallbackFetchType.isEmpty() && BTFTranslator.isBTFString((String)notificationsSepaCallbackFetchType)) {
                String type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.sepaCallbacks", new Object[0])});
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{notificationsSepaCallbackFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                }
            }
            if ((notificationsSepaForeignFetchType = notificationsHandler.getFetchTypeForForeignNotifications()) != null && !notificationsSepaForeignFetchType.isEmpty() && BTFTranslator.isBTFString((String)notificationsSepaForeignFetchType)) {
                String type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.sepaForeign", new Object[0])});
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{notificationsSepaForeignFetchType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                }
            }
            if ((notificationsVopType = notificationsHandler.getFetchTypeForVopNotifications()) != null && !notificationsVopType.isEmpty() && BTFTranslator.isBTFString((String)notificationsVopType)) {
                String type = messages.at("bankdetails.notifications.notificationsFor", new Object[]{messages.at("bankdetails.notifications.vop", new Object[0])});
                Utils.addToFlash(flashMap, "warning", messages.at("bank.error.noMatchingOrderType", new Object[]{notificationsVopType, type}));
                if (inDetails) {
                    redirect = routes.BankDetails.index(bank.getBankId(), "notifications");
                }
            }
        }
        return Banks.runHTDUpdate(request, operatingUser, messages, Collections.singletonList(id), flashMap, formFactory, redirect);
    }

    private static void updateHPB(BankUser bankUser, AcceptHashesHandler acceptHashes) throws GeneralSecurityException, IOException, EbicsException {
        EbicsWorker w = EbicsUtil.getEbicsWorker(bankUser, DatabaseToken.getInstance((BankUser)bankUser, null), acceptHashes);
        bankUser.getBank().setE001Key(null);
        bankUser.getBank().setE002Key(null);
        bankUser.getBank().setX001Key(null);
        bankUser.getBank().setX002Key(null);
        w.getEbicsSession().getBankEncrKey();
    }

    public CompletionStage<Result> upgradeProtocolVersionPost(Http.Request request, int id, String targetVersion) {
        return CompletableFuture.supplyAsync(() -> Banks.upgradeProtocolVersionPost(request, id, targetVersion, true, this.messagesApi, this.formFactory, routes.Banks.index()), this.executionContext.current());
    }

    public Result createBankFromLicense(Http.Request request) {
        return this.createBank(request, null, true);
    }

    private Result createBank(Http.Request request, String bankName, boolean fromLicense) {
        play.i18n.Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!Banks.canUserCreateBanks(operatingUser)) {
            return Banks.redirect((Call)routes.Banks.index()).flashing("error", messages.at("bank.create.noadmin", new Object[0]));
        }
        NewBankForm bankForm = new NewBankForm();
        if (bankName != null) {
            bankForm.fillFromKnownBank(bankName);
        }
        if (fromLicense) {
            try {
                bankForm.fillFromLicenseInfo(operatingUser);
            }
            catch (IOException e) {
                return Banks.redirect((Call)routes.Banks.index()).flashing("HTMLerror", Utils.getLocalizedMessage(e, messages));
            }
        }
        bankForm.startIni = !operatingUser.isLocalUser();
        bankForm.createFetchSchedule = true;
        for (User u : User.getAllForTenants((Collection)operatingUser.getManageableTenants(), (boolean)operatingUser.isAdmin())) {
            bankForm.users.put(u.getId(), true);
        }
        Form form = this.formFactory.form(NewBankForm.class).fill((Object)bankForm);
        return Banks.ok((Content)newbank.render((Form<NewBankForm>)form, false, request, messages, 0));
    }

    public CompletionStage<Result> saveNewBank(Http.Request request) {
        return CompletableFuture.supplyAsync(() -> {
            boolean isOperatorAssignedToBank;
            play.i18n.Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
            User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            if (!Banks.canUserCreateBanks(operatingUser)) {
                return Banks.redirect((Call)routes.Banks.index()).flashing("error", messages.at("bank.create.noadmin", new Object[0]));
            }
            HashMap<String, String> flashMap = new HashMap<String, String>();
            Form form = this.formFactory.form(NewBankForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((NewBankForm)form.get()).validate((Form<NewBankForm>)form, operatingUser, messages);
            }
            boolean hasHevError = false;
            if (!form.errors("hev_fetch_failed").isEmpty()) {
                hasHevError = true;
                List hevErrors = form.errors("hev_fetch_failed");
                if (((NewBankForm)form.discardingErrors().get()).ignoreHevError) {
                    ArrayList remainingErrors = new ArrayList(form.errors());
                    remainingErrors.removeAll(hevErrors);
                    form = form.discardingErrors();
                    for (ValidationError error : remainingErrors) {
                        form = form.withError(error);
                    }
                } else {
                    form = form.withGlobalError(((ValidationError)hevErrors.getFirst()).message());
                    form = form.withError("protocolVersion", "bank.create.hevError");
                }
            }
            if (form.hasErrors()) {
                int openTab = hasHevError ? 1 : 0;
                return Banks.ok((Content)newbank.render(form, hasHevError, request, messages, openTab));
            }
            BankSettings bank = ((NewBankForm)form.get()).storeBank(operatingUser);
            Utils.addToFlash(flashMap, "success", messages.at("bank.created", new Object[0]));
            if (((NewBankForm)form.get()).createFetchSchedule) {
                try {
                    Scheduler scheduler = new Scheduler();
                    scheduler.setBank(bank);
                    scheduler.setLoginUser(null);
                    scheduler.setOrderOrFileType(StatementsPreScheduler.class.getName());
                    scheduler.setYear("-");
                    scheduler.setDays("2-6");
                    scheduler.setHour("6");
                    scheduler.setMinute("00");
                    scheduler.setInterval(Scheduler.Interval.NONE);
                    scheduler.save();
                    new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logSchedulerCreated(operatingUser, scheduler);
                    this.clusterFetchScheduler.updateScheduler(scheduler);
                    Utils.addToFlash(flashMap, "success", messages.at("fetchschedule.createdForBank", new Object[0]));
                }
                catch (Exception e) {
                    Utils.addToFlash(flashMap, "HTMLerror", messages.at("fetchschedule.error.cannotCreate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                }
            }
            boolean bl = isOperatorAssignedToBank = ((NewBankForm)form.get()).users.containsKey(operatingUser.getId()) && ((NewBankForm)form.get()).users.get(operatingUser.getId()) != false;
            if (((NewBankForm)form.get()).startIni && isOperatorAssignedToBank) {
                return Banks.redirect((Call)routes.Banks.reIniGet(bank.getBankId())).flashing(flashMap);
            }
            return Banks.redirect((Call)routes.Banks.index()).flashing(flashMap);
        }, this.executionContext.current());
    }

    private static <T extends PasswordForm> Form<T> checkPassword(Form<T> form, User user, Locale locale) {
        if (!form.hasErrors()) {
            return ((PasswordForm)form.get()).checkPassword(form, user, PasswordForm.PasswordType.EBICS_PASSWORD, locale);
        }
        return form;
    }

    public Result determineProtocolVersion(Http.Request request) {
        play.i18n.Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form form = this.formFactory.form(NewBankForm.class).bindFromRequest(request, new String[0]);
        EbicsHEVResponse hev = null;
        try {
            String hostId;
            URL url = form.field("url").value().isPresent() ? new URI((String)form.field("url").value().get()).toURL() : null;
            String string = hostId = form.field("hostId").value().isPresent() ? (String)form.field("hostId").value().get() : null;
            if (hostId != null && !hostId.isEmpty() && !StringUtils.check((String)hostId, (RegularExpressions)RegularExpressions.EBICS_V24_HOST_ID)) {
                form = form.withError("hostId", "bankdetails.hostid.invalid");
            }
            if ((hev = EbicsSession.getEbicsVersions((URL)url, (String)hostId, (EbicsHttpEngine)new EbicsHttpEngineImpl())) == null) {
                form = form.withGlobalError("ini.protocolVersion.determine.error");
            }
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            form = form.withError("url", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.invalidUrl", (Object[])new Object[0]));
        }
        catch (EbicsException | IOException e) {
            if (e instanceof EbicsException) {
                BLLoggerPlay.error("An error occurred checking the EBICS URL: " + e.getMessage());
            } else {
                BLLoggerPlay.error("An error occurred checking the EBICS URL!", e);
            }
            form = form.withGlobalError(messages.at("ini.protocolVersion.determine.error", new Object[0]) + ": " + Utils.getLocalizedMessage(e, messages));
        }
        if (form.hasErrors() || form.hasGlobalErrors()) {
            if (!form.hasGlobalErrors()) {
                form = form.withGlobalError("general.formerror");
            }
            return Banks.ok((Content)newbank.render((Form<NewBankForm>)form, false, request, messages, 0));
        }
        ArrayList<String> supportedVersions = new ArrayList<String>();
        Map<String, String> clientVersions = Banks.protocolVersionsMap(true);
        for (String version : clientVersions.keySet()) {
            if (hev == null || !hev.can(ProtocolVersion.getInstance((String)version))) continue;
            supportedVersions.add(version);
        }
        String highestVersionString = supportedVersions.stream().sorted().reduce((s1, s2) -> s2).orElse(null);
        if (highestVersionString == null) {
            form = form.withGlobalError("ini.protocolVersion.determine.error");
        } else {
            ProtocolVersion highestVersion = ProtocolVersion.getInstance((String)highestVersionString);
            HashMap<String, String> data = new HashMap<String, String>(form.rawData());
            data.put("protocolVersion", highestVersion.getValue());
            form = form.bind(messages.lang(), null, data, new String[0]);
        }
        return Banks.ok((Content)newbank.render((Form<NewBankForm>)form, false, request, messages, 1));
    }

    public Result createBank(Http.Request request, String bankName) {
        try {
            if (bankName != null) {
                bankName = URLDecoder.decode(bankName, StandardCharsets.UTF_8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createBank(request, bankName, false);
    }

    public CompletionStage<Result> printHTD(Http.Request request) {
        play.i18n.Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String bankIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        return CompletableFuture.supplyAsync(() -> Banks.printHTD(user, messages, GeneralUtils.getSelectionIds(bankIds), routes.Banks.index()), this.executionContext.current());
    }

    private static /* synthetic */ String lambda$upgradeProtocolVersionPost$20(BankUser b) {
        return b.getUser().getName();
    }
}

