/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.Banks;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.DateFormatter;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.UserEffectivePermissions;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.zkasecurity.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import models.BankDetailsForm;
import models.CopyKeysForm;
import models.PasswordForm;
import models.WebAuthnData;
import play.data.Form;
import play.data.FormFactory;
import play.data.format.Formatters;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.html.banks.copyKeys;
import views.html.banks.details;

@Security.Authenticated(value=AuthenticatorFor.Settings.class)
public class BankDetails
extends Controller {
    private final ClassLoaderExecutionContext executionContext;
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;

    public static Seq<Tuple2<String, String>> getUserOptions(Messages messages, BankUser bankUser) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        String activeSuffix = bankUser == null ? "" : " (" + BankingApiMessages.getString((Locale)messages.lang().locale(), (String)("GeneralMessages.bank.state." + bankUser.getState().name()), (Object[])new Object[0]) + ")";
        result.add(Scala.Tuple((Object)USER_ACTIVATION_OPTION.REMOVED.name(), (Object)messages.at("bankdetails.user.removedFromBank", new Object[0])));
        result.add(Scala.Tuple((Object)USER_ACTIVATION_OPTION.DEACTIVATED.name(), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bank.state.deactivated", (Object[])new Object[0])));
        result.add(Scala.Tuple((Object)USER_ACTIVATION_OPTION.ACTIVATED.name(), (Object)(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.activated", (Object[])new Object[0]) + activeSuffix)));
        return Scala.toSeq(result);
    }

    @Inject
    public BankDetails(FormFactory formFactory, Formatters formatters, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
        formatters.register(Date.class, (Formatters.SimpleFormatter)new DateFormatter());
        formatters.register(GeneralSEPAWriter.Version.class, (Formatters.SimpleFormatter)new Formatters.SimpleFormatter<GeneralSEPAWriter.Version>(this){

            public GeneralSEPAWriter.Version parse(String string, Locale locale) {
                return GeneralSEPAWriter.Version.valueOf((String)string);
            }

            public String print(GeneralSEPAWriter.Version version, Locale locale) {
                return version.name();
            }
        });
    }

    public Result index(Http.Request request, Integer bankId, String openTab) {
        return this.indexWithMode(request, bankId, false, openTab);
    }

    public Result indexEditMode(Http.Request request, Integer bankId, String openTab) {
        return this.indexWithMode(request, bankId, true, openTab);
    }

    private Result indexWithMode(Http.Request request, Integer bankId, boolean inEditMode, String openTab) {
        BankSettings bank;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!Banks.canUserSeeBank(operatingUser, bank = BankSettings.getById((Integer)bankId))) {
            return BankDetails.redirect((Call)routes.Banks.index()).flashing("warning", messages.at("bank.error.noSuchBank", new Object[0]));
        }
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)operatingUser);
        Form form = this.formFactory.form(BankDetailsForm.class).fill((Object)BankDetailsForm.fillForm(bank, bankUser));
        ProtocolVersion protocolVersion = ProtocolVersion.getInstance((String)bank.getProtocolVersion());
        SignatureVersion signatureVersion = null;
        if (bankUser != null) {
            signatureVersion = SignatureVersion.getInstance((String)bankUser.getSignatureVersion());
        }
        return BankDetails.ok((Content)details.render(bank, bankUser, (Form<BankDetailsForm>)form, protocolVersion, signatureVersion, inEditMode, openTab, request, messages));
    }

    public Result submit(Http.Request request, Integer bankId) {
        BankSettings bank;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!Banks.canUserModifyBank(operatingUser, bank = BankSettings.getById((Integer)bankId))) {
            return BankDetails.redirect((Call)routes.Banks.index()).flashing("error", messages.at("bankdetails.saved.nopermission", new Object[0]));
        }
        if (!Banks.canUserSeeBank(operatingUser, bank)) {
            return BankDetails.redirect((Call)routes.Banks.index()).flashing("error", messages.at("bank.error.noSuchBank", new Object[0]));
        }
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)operatingUser);
        Form form = this.formFactory.form(BankDetailsForm.class).bindFromRequest(request, new String[0]);
        if (form.hasErrors()) {
            String firstError = ((ValidationError)form.errors().get(0)).message();
            form = form.withGlobalError(firstError);
            ProtocolVersion protocolVersion = ProtocolVersion.getInstance((String)bank.getProtocolVersion());
            SignatureVersion signatureVersion = null;
            if (bankUser != null) {
                signatureVersion = SignatureVersion.getInstance((String)bankUser.getSignatureVersion());
            }
            return BankDetails.ok((Content)details.render(bank, bankUser, (Form<BankDetailsForm>)form, protocolVersion, signatureVersion, true, "bank", request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        List<ValidationError> errors = ((BankDetailsForm)form.get()).validate(messages);
        if (errors != null && !errors.isEmpty()) {
            String firstError = errors.get(0).message();
            form = form.withGlobalError(firstError);
            ProtocolVersion protocolVersion = ProtocolVersion.getInstance((String)bank.getProtocolVersion());
            SignatureVersion signatureVersion = null;
            if (bankUser != null) {
                signatureVersion = SignatureVersion.getInstance((String)bankUser.getSignatureVersion());
            }
            return BankDetails.ok((Content)details.render(bank, bankUser, GeneralUtils.formWithErrors(form, errors), protocolVersion, signatureVersion, true, "bank", request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        ((BankDetailsForm)form.get()).saveForm(operatingUser, bank, bankUser);
        UserEffectivePermissions.updatePermissions((BankSettings)bank);
        return BankDetails.redirect((Call)routes.BankDetails.index(bankId, BankDetailsForm.Tab.BANK.label)).flashing("success", messages.at("bankdetails.saved", new Object[]{bank.getDisplayName()}));
    }

    public Result showIniLetter(Http.Request request, int bankId, String tab) {
        return Banks.showIniLetter(request, bankId, routes.BankDetails.index(bankId, tab), this.messagesApi);
    }

    public Result copyBankGet(Http.Request request, int id, String tab) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        BankSettings bank = BankSettings.getById((Integer)id);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        if (Branding.getBranding().hideShareUserKeysButton()) {
            return BankDetails.redirect((Call)routes.BankDetails.index(id, tab)).flashing("error", messages.at("general.noPermission", new Object[0]));
        }
        if (bankUser == null) {
            return BankDetails.redirect((Call)routes.BankDetails.index(id, tab)).flashing("error", messages.at("bank.error.bankUserOnly", new Object[0]));
        }
        if (!BankUtils.isReady((BankUser)bankUser)) {
            return BankDetails.redirect((Call)routes.BankDetails.index(id, tab)).flashing("error", messages.at("bank.error.readyOnly", new Object[0]));
        }
        Form form = this.formFactory.form(CopyKeysForm.class);
        return BankDetails.ok((Content)copyKeys.render(bankUser, (Form<CopyKeysForm>)form, WebAuthnData.build(user), true, tab, request, messages));
    }

    public Result copyBankPost(Http.Request request, int id, String tab) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        BankSettings bank = BankSettings.getById((Integer)id);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        if (Branding.getBranding().hideShareUserKeysButton()) {
            return BankDetails.redirect((Call)routes.BankDetails.index(id, tab)).flashing("error", messages.at("general.noPermission", new Object[0]));
        }
        if (bankUser == null) {
            return BankDetails.redirect((Call)routes.BankDetails.index(id, tab)).flashing("error", messages.at("bank.error.bankUserOnly", new Object[0]));
        }
        if (!BankUtils.isReady((BankUser)bankUser)) {
            return BankDetails.redirect((Call)routes.BankDetails.index(id, tab)).flashing("error", messages.at("bank.error.readyOnly", new Object[0]));
        }
        Form form = this.formFactory.form(CopyKeysForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors() && !(form = ((CopyKeysForm)form.get()).checkPassword(form, user, PasswordForm.PasswordType.EBICS_PASSWORD, true, messages.lang().toLocale())).hasErrors()) {
            form = ((CopyKeysForm)form.get()).checkUserToCopyAndPassword(form, bankUser);
        }
        if (form.hasErrors()) {
            return BankDetails.ok((Content)copyKeys.render(bankUser, form, WebAuthnData.build(user), true, tab, request, messages));
        }
        CopyKeysForm copyKeysForm = (CopyKeysForm)form.get();
        User toCopy = copyKeysForm.foundUser;
        if (toCopy != null) {
            boolean loginuserChanged = false;
            BankUser buToCopy = BankUser.findBankUser((BankSettings)bankUser.getBank(), (User)toCopy);
            if (buToCopy == null) {
                buToCopy = new BankUser();
                buToCopy.setBank(bankUser.getBank());
                buToCopy.setUser(toCopy);
                buToCopy.setOrderNumber(bankUser.getOrderNumber());
            }
            buToCopy.setDefaultUser(bankUser.getDefaultUser());
            buToCopy.setWithCerts(bankUser.isWithCerts());
            buToCopy.setAuthCert(bankUser.getAuthCert());
            buToCopy.setAuthKeyLength(bankUser.getAuthKeyLength());
            buToCopy.setAuthKey(bankUser.getAuthKey());
            buToCopy.setEncrCert(bankUser.getEncrCert());
            buToCopy.setEncrKeyLength(bankUser.getEncrKeyLength());
            buToCopy.setEncrKey(bankUser.getEncrKey());
            buToCopy.setSigCert(bankUser.getSigCert());
            buToCopy.setSigKeyLength(bankUser.getSigKeyLength());
            buToCopy.setSignatureVersion(bankUser.getSignatureVersion());
            buToCopy.setLockUserSignature(bankUser.getLockUserSignature());
            buToCopy.setState(bankUser.getState());
            if (!"DATABASE".equals(toCopy.getKeyDirectory())) {
                toCopy.setKeyDirectory("DATABASE");
                loginuserChanged = true;
            }
            try {
                buToCopy.setSigKey(KeyStore.encryptData((byte[])KeyStore.decryptData((byte[])bankUser.getSigKey(), (char[])copyKeysForm.password.toCharArray()), (char[])copyKeysForm.passwordCopyTo.toCharArray()));
            }
            catch (Exception e) {
                form = form.withError("passwordCopyTo", "bank.copyKeys.passwordWrong");
                return BankDetails.ok((Content)copyKeys.render(bankUser, (Form<CopyKeysForm>)form, WebAuthnData.build(user), true, tab, request, messages));
            }
            buToCopy.save();
            if (loginuserChanged) {
                toCopy.save();
            }
        }
        return BankDetails.redirect((Call)routes.BankDetails.index(id, tab)).flashing("success", messages.at("bank.copyKeys.done", new Object[0]));
    }

    public Result lockBankGet(Http.Request request, int id, String tab) {
        return Banks.lockBankGet(request, id, routes.BankDetails.index(id, tab), this.messagesApi, this.formFactory);
    }

    public CompletionStage<Result> lockBankPost(Http.Request request, int id, String tab) {
        return CompletableFuture.supplyAsync(() -> Banks.lockBankPost(request, id, routes.BankDetails.index(id, tab), this.messagesApi, this.formFactory), this.executionContext.current());
    }

    public Result changeSignatureVersionGet(Http.Request request, int id, String tab) {
        return Banks.changeSignatureVersion(request, id, routes.BankDetails.index(id, tab), this.messagesApi, this.formFactory);
    }

    public CompletionStage<Result> changeSignatureVersionPost(Http.Request request, int id, String tab) {
        return CompletableFuture.supplyAsync(() -> Banks.changeSignatureVersionPost(request, id, routes.BankDetails.index(id, tab), this.messagesApi, this.formFactory), this.executionContext.current());
    }

    public CompletionStage<Result> runHTDUpdate(Http.Request request, Integer id, String tab) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> Banks.runHTDUpdate(request, user, messages, Collections.singletonList(id), null, this.formFactory, routes.BankDetails.index(id, tab)), this.executionContext.current());
    }

    public CompletionStage<Result> printHTD(Http.Request request, Integer id, String tab) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> Banks.printHTD(user, messages, Collections.singletonList(id), routes.BankDetails.index(id, tab)), this.executionContext.current());
    }

    public Result updateBankKeys(Http.Request request, int id, String tab) {
        return Banks.updateBankKeys(request, String.valueOf(id), this.messagesApi, this.formFactory, routes.BankDetails.index(id, tab));
    }

    public Result reIniGet(Http.Request request, int id, String tab) {
        return Banks.reIni(request, id, this.messagesApi, this.formFactory, routes.BankDetails.index(id, tab));
    }

    public CompletionStage<Result> reIniPost(Http.Request request, int id, String tab) {
        return CompletableFuture.supplyAsync(() -> Banks.reIniPost(request, id, this.messagesApi, this.formFactory, routes.BankDetails.index(id, tab)), this.executionContext.current());
    }

    public CompletionStage<Result> changeProtocolVersionGet(Http.Request request, int id, String toVersion, String tab) {
        return CompletableFuture.supplyAsync(() -> Banks.changeProtocolVersionGet(request, id, toVersion, this.messagesApi, this.formFactory, routes.BankDetails.index(id, tab)), this.executionContext.current());
    }

    public CompletionStage<Result> updateProtocolVersionGet(Http.Request request, int id, String tab) {
        return CompletableFuture.supplyAsync(() -> Banks.updateProtocolVersionGet(request, id, this.messagesApi, this.formFactory, routes.BankDetails.index(id, tab)), this.executionContext.current());
    }

    public CompletionStage<Result> upgradeProtocolVersionGet(Http.Request request, int id, String targetVersion, String tab) {
        return CompletableFuture.supplyAsync(() -> Banks.upgradeProtocolVersionPost(request, id, targetVersion, false, this.messagesApi, this.formFactory, routes.BankDetails.index(id, tab)), this.executionContext.current());
    }

    public CompletionStage<Result> upgradeProtocolVersionPost(Http.Request request, int id, String targetVersion, String tab) {
        return CompletableFuture.supplyAsync(() -> Banks.upgradeProtocolVersionPost(request, id, targetVersion, true, this.messagesApi, this.formFactory, routes.BankDetails.index(id, tab)), this.executionContext.current());
    }

    public CompletionStage<Result> downgradeProtocolVersionPost(Http.Request request, int id, String targetVersion, String tab) {
        return CompletableFuture.supplyAsync(() -> Banks.downgradeProtocolVersionPost(request, id, targetVersion, this.messagesApi, this.formFactory, routes.BankDetails.index(id, tab)), this.executionContext.current());
    }

    public CompletionStage<Result> deleteQuestion(Http.Request request, Integer id) {
        return CompletableFuture.supplyAsync(() -> Banks.deleteBanksQuestion(request, id, this.messagesApi, this.formFactory), this.executionContext.current());
    }

    public CompletionStage<Result> activateQuestion(Http.Request request, Integer id) {
        return CompletableFuture.supplyAsync(() -> Banks.toggleActivateBanksQuestion(request, true, id, this.messagesApi, this.formFactory), this.executionContext.current());
    }

    public CompletionStage<Result> deactivateQuestion(Http.Request request, Integer id) {
        return CompletableFuture.supplyAsync(() -> Banks.toggleActivateBanksQuestion(request, false, id, this.messagesApi, this.formFactory), this.executionContext.current());
    }

    public static enum USER_ACTIVATION_OPTION {
        ACTIVATED,
        DEACTIVATED,
        REMOVED;

    }
}

