/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.DatabaseConnection;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmBalance;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.BalancesCsvExport;
import de.businesslogics.banking.mt940.api.ValueBalanceCalculator;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.Currency;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.cm.balances;

@Security.Authenticated(value=AuthenticatorFor.CM.class)
public class Balances
extends Controller {
    private final MessagesApi messagesApi;

    public static List<CmBalance> getBalancesForAccount(Account account, SortingHandler sorting) {
        return Balances.sortedPagedBalances(Expr.eq((String)"account", (Object)account), 0, true).setMaxRows(sorting.getPageSize()).findList();
    }

    @Inject
    public Balances(MessagesApi messagesApi) {
        this.messagesApi = messagesApi;
    }

    public Result balances(Http.Request request, Integer accountId) {
        List list;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES);
        boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        List accs = Account.findAccounts((User)user, null, null, (boolean)checkPermission);
        if (accs.isEmpty()) {
            return Balances.redirect((Call)routes.CmAccountOverview.index()).flashing("warning", messages.at("balances.warning.noAccounts", new Object[0]));
        }
        Account acc = this.findAccount(accs, accountId);
        if (acc == null) {
            return Balances.redirect((Call)routes.Balances.balances(-1)).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
        }
        Currency currency = Currency.getInstance((String)acc.getCurrency());
        Query<CmBalance> query = Balances.sortedPagedBalances(Expr.eq((String)"account", (Object)acc), sorting.getSortingColumn(), sorting.isSortingAscending());
        sorting.computeForQuery(query);
        Map bookingBalanceMap = CmStatement.findBookingBalanceValueDateMap((Account)acc);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.CM_VALUE_BALANCES, (Call)routes.Balances.balances(accountId));
        }
        return Balances.ok((Content)balances.render(acc, currency, accs, list, bookingBalanceMap, sorting, request, messages));
    }

    public Result balances_sort(Http.Request request, Integer accountId, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES).updateSort(sort, asc);
        return Balances.redirect((Call)routes.Balances.balances(accountId));
    }

    public Result balances_pageSize(Http.Request request, Integer accountId, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES).updatePage(page, pageSize);
        return Balances.redirect((Call)routes.Balances.balances(accountId));
    }

    public Result createCSVExport(Http.Request request, Integer accountId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES);
        List accs = Account.findAccounts((User)user, null, null, (boolean)checkPermission);
        if (accs.isEmpty()) {
            return Balances.redirect((Call)routes.CmAccountOverview.index()).flashing("warning", messages.at("balances.warning.noAccounts", new Object[0]));
        }
        Account acc = this.findAccount(accs, accountId);
        if (acc == null) {
            return Balances.redirect((Call)routes.Balances.balances(-1)).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
        }
        Map bookingBalanceMap = CmStatement.findBookingBalanceValueDateMap((Account)acc);
        Query<CmBalance> query = Balances.sortedPagedBalances(Expr.eq((String)"account", (Object)acc), sorting.getSortingColumn(), sorting.isSortingAscending());
        try {
            String fileName = messages.at("balances.title", new Object[0]) + "_" + acc.getName() + ".csv";
            File tmpFile = Util.createTempFile((String)fileName, (String)".tmp", (boolean)true);
            try (OutputStream outputStream = EncryptData.getInstance().openOutputStream(tmpFile);){
                new BalancesCsvExport(bookingBalanceMap, acc, Currency.getInstance((String)acc.getCurrency()), messages.lang().locale()).write(outputStream, (Iterable)query.findList());
            }
            return GeneralUtils.supplyWorkspaceFile(tmpFile, false, true).as("text/comma-separated-values").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(fileName));
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Failed to export balances overview to CSV file!", e);
            return Balances.redirect((Call)routes.Balances.balances(acc.getId())).flashing("HTMLerror", messages.at("error.failedcsvexport", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
    }

    public Result recalculateValueBalances(Http.Request request, Integer accountId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        List accs = Account.findAccounts((User)user, null, null, (boolean)checkPermission);
        if (accs.isEmpty()) {
            return Balances.redirect((Call)routes.CmAccountOverview.index()).flashing("warning", messages.at("balances.warning.noAccounts", new Object[0]));
        }
        Account account = this.findAccount(accs, accountId);
        if (account == null) {
            return Balances.redirect((Call)routes.Balances.balances(-1)).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
        }
        try {
            ValueBalanceCalculator.recalculate((Account)account);
        }
        catch (Exception e) {
            return Balances.redirect((Call)routes.Balances.balances(account.getId())).flashing("error", messages.at("balances.recalculateValueBalances.failed", new Object[]{account.getName(), e}));
        }
        return Balances.redirect((Call)routes.Balances.balances(account.getId())).flashing("success", messages.at("balances.recalculateValueBalances.success", new Object[]{account.getName()}));
    }

    private Account findAccount(List<Account> accs, Integer accountId) {
        Account acc = null;
        if (accs.isEmpty()) {
            return null;
        }
        if (accountId < 0) {
            acc = accs.getFirst();
        }
        Iterator<Account> iterator = accs.iterator();
        while (iterator.hasNext()) {
            int countStatements;
            Account a = iterator.next();
            if (a.getId().equals(accountId)) {
                acc = a;
            }
            if ((countStatements = CmStatement.findCountStatementsAndAdvices((Account)a, null, null)) != 0) continue;
            iterator.remove();
        }
        accs.sort(Comparator.comparing(Account::getDefaultDisplayName));
        return acc;
    }

    private static Query<CmBalance> sortedPagedBalances(Expression expr, int sort, boolean asc) {
        Query q = DB.find(CmBalance.class).where(expr);
        String dateSortDirection = DBType.PSQL.equals((Object)DatabaseConnection.getInstance().getDbType()) ? (asc ? "ASC NULLS FIRST" : "DESC NULLS LAST") : (asc ? "ASC" : "DESC");
        switch (sort) {
            case 1: {
                if (asc) {
                    q = q.order("valueBalance asc");
                    break;
                }
                q = q.order("valueBalance desc");
                break;
            }
            case 2: {
                if (asc) {
                    q = q.order("valueBalanceWithAdvice asc");
                    break;
                }
                q = q.order("valueBalanceWithAdvice desc");
                break;
            }
            default: {
                q = q.order("valueDate " + dateSortDirection);
            }
        }
        return q;
    }
}

