/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.DateFormatter;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.ProgressMonitorDummy;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmValueGroup;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.BalanceListsCsvExport;
import de.businesslogics.banking.mt940.api.ValueBalancesDataProvider;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.util.IProgressMonitorWrapper;
import io.ebean.Query;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import models.BalancelistsDatepickerForm;
import models.NewValueGroupForm;
import play.data.Form;
import play.data.FormFactory;
import play.data.format.Formatters;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.cm.balancelists;

@Security.Authenticated(value=AuthenticatorFor.CM.class)
public class BalanceLists
extends Controller {
    public static int DEFAULT_DATE_COUNT = 5;
    protected static final String PROPKEY_GROUP = "Group";
    protected static final String PROPKEY_DATEDIFF = "Datediff";
    protected static final String PROPKEY_DATECOUNT = "Datecount";
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;

    @Inject
    public BalanceLists(FormFactory formFactory, Formatters formatters, MessagesApi messagesApi) {
        this.formFactory = formFactory;
        formatters.register(Date.class, (Formatters.SimpleFormatter)new DateFormatter());
        this.messagesApi = messagesApi;
    }

    public static ValueBalancesDataProvider.Data[] getPagedBalanceListsData(User user, ValueBalancesDataProvider provider, SortingHandler sorting) {
        ValueBalancesDataProvider.Data[] dataPagedWithSum;
        ValueBalancesDataProvider.Data[] data = ValueBalancesDataProvider.sort((ValueBalancesDataProvider.Data[])provider.getData(user), (Integer)sorting.getSortingColumn(), (boolean)sorting.isSortingAscending());
        if (data.length <= 1) {
            sorting.computeForList(new ArrayList());
            dataPagedWithSum = new ValueBalancesDataProvider.Data[]{};
        } else {
            ValueBalancesDataProvider.Data[] dataWithoutSum = Arrays.copyOfRange(data, 0, data.length - 2);
            List<ValueBalancesDataProvider.Data> dataList = Arrays.asList(dataWithoutSum);
            dataList = sorting.computeForList(dataList);
            ValueBalancesDataProvider.Data[] dataPaged = dataList.toArray(new ValueBalancesDataProvider.Data[0]);
            dataPagedWithSum = new ValueBalancesDataProvider.Data[dataPaged.length + 2];
            for (int i = 0; i < dataPagedWithSum.length; ++i) {
                dataPagedWithSum[i] = i < dataPaged.length ? dataPaged[i] : (i == dataPaged.length ? data[data.length - 2] : data[data.length - 1]);
            }
        }
        return dataPagedWithSum;
    }

    public static List<CmFolder> getFolders(User user, Tenant tenant) {
        List list = CmFolder.findAll((User)user);
        if (tenant == null) {
            return list;
        }
        ArrayList<CmFolder> returnList = new ArrayList<CmFolder>();
        for (CmFolder a : list) {
            if (!Objects.equals(a.getTenant().getId(), tenant.getId())) continue;
            returnList.add(a);
        }
        return returnList;
    }

    public static List<Account> getAccounts(User user, Tenant tenant) {
        Query query = user.isAdmin() ? DB.find(Account.class).where().query() : Account.findAccountsQuery((User)user, (boolean)true);
        List list = query.order("bank.displayName, name, iban, id").findList();
        if (tenant == null) {
            return list;
        }
        ArrayList<Account> returnList = new ArrayList<Account>();
        for (Account a : list) {
            if (!Objects.equals(a.getBank().getTenant().getId(), tenant.getId())) continue;
            returnList.add(a);
        }
        return returnList;
    }

    protected static int safeParseInt(SortingHandler sorting, String key, int defaultValue) {
        String property = sorting.getProperty(key);
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException nfe) {
            if (property != null) {
                BLLoggerPlay.warning("Could not parse input string to integer: " + property);
                sorting.setProperty(key, null);
            }
            return defaultValue;
        }
    }

    public Result balancelists(Http.Request request, boolean valueBalances) {
        return this.balancelists(request, valueBalances, null, null, null, false);
    }

    public Result balancelists_group(Http.Request request, Integer group, boolean valueBalances) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2).setProperty(PROPKEY_GROUP, String.valueOf(group));
        return BalanceLists.redirect((Call)routes.BalanceLists.balancelists(valueBalances));
    }

    private Result balancelists(Http.Request request, boolean valueBalances, Form<BalancelistsDatepickerForm> dateForm, Form<NewValueGroupForm> newGroupForm, Form<NewValueGroupForm> editGroupForm, boolean createcsv) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2);
        int groupId = Integer.parseInt(sorting.getProperty(PROPKEY_GROUP, "-1"));
        CmValueGroup group = CmValueGroup.findById((Integer)groupId, (User)user);
        if (groupId != -1 && group == null) {
            groupId = -1;
        }
        int diff = BalanceLists.safeParseInt(sorting, PROPKEY_DATEDIFF, -3);
        Calendar c = Calendar.getInstance();
        c.add(5, diff);
        Date startDate = c.getTime();
        int dateCount = BalanceLists.safeParseInt(sorting, PROPKEY_DATECOUNT, DEFAULT_DATE_COUNT);
        ProgressMonitorDummy monitorDummy = ProgressMonitorDummy.getInstance();
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
        ValueBalancesDataProvider provider = new ValueBalancesDataProvider(group, c, dateCount, valueBalances, store, (IProgressMonitorWrapper)monitorDummy);
        ValueBalancesDataProvider.Data[] data = ValueBalancesDataProvider.sort((ValueBalancesDataProvider.Data[])provider.getData(user), (Integer)sorting.getSortingColumn(), (boolean)sorting.isSortingAscending());
        boolean balancesWithAdvices = store.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.BALANCES_WITH_ADVICE_INFO);
        if (createcsv) {
            return this.createCSV(request, data, startDate, dateCount, valueBalances, balancesWithAdvices);
        }
        if (dateForm == null) {
            BalancelistsDatepickerForm dateFormPresets = new BalancelistsDatepickerForm();
            dateFormPresets.dateFrom = startDate;
            dateFormPresets.dateCount = dateCount;
            dateForm = this.formFactory.form(BalancelistsDatepickerForm.class).fill((Object)dateFormPresets);
        } else {
            ((BalancelistsDatepickerForm)dateForm.get()).dateFrom = startDate;
            ((BalancelistsDatepickerForm)dateForm.get()).dateCount = dateCount;
        }
        if (newGroupForm == null) {
            newGroupForm = this.formFactory.form(NewValueGroupForm.class);
        }
        if (editGroupForm == null && groupId > 0) {
            NewValueGroupForm value = NewValueGroupForm.fill(group);
            editGroupForm = this.formFactory.form(NewValueGroupForm.class).fill((Object)value);
        }
        return BalanceLists.ok((Content)balancelists.render(group, BalanceLists.getPagedBalanceListsData(user, provider, sorting), startDate, dateCount, valueBalances, balancesWithAdvices, sorting, (Form<BalancelistsDatepickerForm>)dateForm, (Form<NewValueGroupForm>)newGroupForm, (Form<NewValueGroupForm>)editGroupForm, request, messages));
    }

    public Result balancelists_page(Http.Request request, int pageNumber, int pageSize, boolean valueBalances) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2);
        sorting.updatePage(pageNumber, pageSize);
        return BalanceLists.redirect((Call)routes.BalanceLists.balancelists(valueBalances));
    }

    public Result balancelists_sort(Http.Request request, boolean valueBalances, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2).updateSort(sort, asc);
        return BalanceLists.redirect((Call)routes.BalanceLists.balancelists(valueBalances));
    }

    public Result balancelists_form(Http.Request request, boolean valueBalances) {
        String dateFromProperty;
        Form form = this.formFactory.form(BalancelistsDatepickerForm.class).bindFromRequest(request, new String[0]);
        if (form.hasErrors()) {
            return this.balancelists(request, valueBalances, (Form<BalancelistsDatepickerForm>)form, null, null, false);
        }
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2);
        Date dateFrom = ((BalancelistsDatepickerForm)form.get()).dateFrom;
        if (dateFrom == null) {
            dateFromProperty = null;
        } else {
            Date today = Calendar.getInstance().getTime();
            long diffMillis = dateFrom.getTime() - today.getTime();
            long diffDays = (int)Math.ceil((double)diffMillis / 8.64E7);
            dateFromProperty = String.valueOf(diffDays);
        }
        sorting.setProperty(PROPKEY_DATEDIFF, dateFromProperty);
        Integer dateCount = ((BalancelistsDatepickerForm)form.get()).dateCount;
        String dateCountProperty = dateCount == null ? null : String.valueOf(dateCount);
        sorting.setProperty(PROPKEY_DATECOUNT, dateCountProperty);
        return BalanceLists.redirect((Call)routes.BalanceLists.balancelists(valueBalances));
    }

    public Result createCSVExport(Http.Request request, boolean valueBalances) {
        return this.balancelists(request, valueBalances, null, null, null, true);
    }

    private Result createCSV(Http.Request request, ValueBalancesDataProvider.Data[] data, Date startDate, int dateCount, boolean valueBalances, boolean balancesWithAdvices) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        try {
            String fileName = messages.at("balances.title", new Object[0]) + ".csv";
            File tmpFile = Util.createTempFile((String)fileName, (String)".tmp", (boolean)true);
            try (OutputStream outputStream = EncryptData.getInstance().openOutputStream(tmpFile);){
                new BalanceListsCsvExport(startDate, dateCount, valueBalances, balancesWithAdvices, messages.lang().locale()).write(outputStream, Arrays.asList(data));
            }
            return GeneralUtils.supplyWorkspaceFile(tmpFile, false, true).as("text/comma-separated-values").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(fileName));
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Failed to export balancelists overview to CSV file!", e);
            return BalanceLists.redirect((Call)routes.BalanceLists.balancelists(valueBalances)).flashing("HTMLerror", messages.at("error.failedcsvexport", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
    }

    public Result newGroup(Http.Request request, boolean valueBalances) {
        Form<NewValueGroupForm> form = this.formFactory.form(NewValueGroupForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        CmValueGroup group = new CmValueGroup();
        if (!form.hasErrors()) {
            form = ((NewValueGroupForm)form.get()).validateAndSave(form, group, User.getUser((String)((String)request.attrs().get(Security.USERNAME))), messages.lang().locale());
        }
        if (form.hasErrors()) {
            return this.balancelists(request, valueBalances, null, form, null, false);
        }
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2).setProperty(PROPKEY_GROUP, String.valueOf(group.getId()));
        return BalanceLists.redirect((Call)routes.BalanceLists.balancelists(valueBalances));
    }

    public Result editGroup(Http.Request request, boolean valueBalances) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        int groupId = Integer.parseInt(new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2).getProperty(PROPKEY_GROUP, "-1"));
        Form<NewValueGroupForm> form = this.formFactory.form(NewValueGroupForm.class).bindFromRequest(request, new String[0]);
        CmValueGroup group = CmValueGroup.findById((Integer)groupId, (User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (group == null) {
            return BalanceLists.redirect((Call)routes.BalanceLists.balancelists(valueBalances)).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("balancelists.error.noSuchGroup", new Object[0]));
        }
        if (!form.hasErrors()) {
            form = ((NewValueGroupForm)form.get()).validateAndSave(form, group, User.getUser((String)((String)request.attrs().get(Security.USERNAME))), messages.lang().locale());
        }
        if (form.hasErrors()) {
            return this.balancelists(request, valueBalances, null, null, form, false);
        }
        return BalanceLists.redirect((Call)routes.BalanceLists.balancelists(valueBalances));
    }

    public Result deleteGroup(Http.Request request, boolean valueBalances) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        int groupId = Integer.parseInt(new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2).getProperty(PROPKEY_GROUP, "-1"));
        CmValueGroup group = CmValueGroup.findById((Integer)groupId, (User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))));
        if (group == null) {
            return BalanceLists.redirect((Call)routes.BalanceLists.balancelists(valueBalances)).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("balancelists.error.noSuchGroup", new Object[0]));
        }
        CmValueGroup.delete((CmValueGroup)group);
        new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2).setProperty(PROPKEY_GROUP, null);
        return BalanceLists.redirect((Call)routes.BalanceLists.balancelists(valueBalances));
    }
}

