/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.routes;
import controllers.util.AwvBookingsCollector;
import controllers.util.AwvPaymentReportCollector;
import controllers.util.BLLoggerPlay;
import controllers.util.BigDecimalFormatter;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.awzel.api.AwzelApi;
import de.businesslogics.banking.awzel.api.CountryProvider;
import de.businesslogics.banking.awzel.api.ReportCreationRunnerApi;
import de.businesslogics.banking.awzel.api.ServiceCodeProvider;
import de.businesslogics.banking.awzel.api.WareCodeProvider;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.AwzelExport;
import de.businesslogics.banking.database.vo.AwzelParticipantContactPerson;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Query;
import io.ebean.Update;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.AwvCreateReportForm;
import models.AwvDikaNotificationForm;
import models.AwvDirinvNotificationForm;
import models.AwvNotificationForm;
import models.AwvParticipantForm;
import models.AwvTransitNotificationForm;
import models.SimpleTextForm;
import models.payments.PaymentException;
import play.data.Form;
import play.data.FormFactory;
import play.data.format.Formatters;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.awv.awvnotifications;
import views.html.awv.awvparticipants;
import views.html.awv.convertawvnotification;
import views.html.awv.editawvnotification;
import views.html.awv.editawvparticipant;
import views.html.awv.newawvnotification;
import views.html.awv.newawvparticipant;

@Security.Authenticated(value=AuthenticatorFor.AWV.class)
public class Awv
extends Controller {
    private static final Pattern DATA_MONTH_PATTERN = Pattern.compile("(\\d{4})(0[1-9]|1[0-2])");
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static String getMonthString(String monthString, Locale locale) {
        Matcher matcher;
        if (monthString != null && (matcher = DATA_MONTH_PATTERN.matcher(monthString)).matches()) {
            return matcher.group(1) + " - " + new DateFormatSymbols(locale).getMonths()[Integer.parseInt(matcher.group(2)) - 1];
        }
        return "";
    }

    public static String getMonthString(Tenant tenant, String monthString, Locale locale, boolean showTenant) {
        return Awv.getMonthString(tenant, monthString, locale, false, showTenant);
    }

    private static String getMonthString(Tenant tenant, String monthString, Locale locale, boolean showExported, boolean showTenant) {
        Matcher matcher;
        StringBuilder sb = new StringBuilder();
        if (monthString != null && (matcher = DATA_MONTH_PATTERN.matcher(monthString)).matches()) {
            AwzelExport ex;
            if (showTenant && tenant != null) {
                sb.append(tenant.getName()).append(" - ");
            }
            sb.append(matcher.group(1)).append(" - ");
            sb.append(new DateFormatSymbols(locale).getMonths()[Integer.parseInt(matcher.group(2)) - 1]);
            if (showExported && (ex = AwzelExport.findByMonth((String)monthString, (Tenant)tenant)) != null) {
                sb.append(BankingApiMessages.getString((String)"GeneralMessages.awvReportFileExported", (Object[])new Object[0]));
            }
        }
        return sb.toString();
    }

    public static String getMonthHeader(Tenant tenant, String monthString, Locale locale, boolean showTenant) {
        return Awv.getMonthString(tenant, monthString, locale, true, showTenant);
    }

    public Result update(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        flashMap.put("success", messages.at("awv.update.fetching.done", new Object[0]));
        return Awv.redirect((Call)routes.Awv.notifications()).flashing(flashMap);
    }

    public static String getExportInformation(Tenant tenant, String month, Messages messages) {
        AwzelExport awzelExport = AwzelExport.findByMonth((String)month, (Tenant)tenant);
        if (awzelExport == null) {
            return null;
        }
        if (awzelExport.getExportUser() == null) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.reportFileCreated.short", (Object[])new Object[]{awzelExport.getExportTime()});
        }
        return messages.at("awv.notifications.exported.long", new Object[]{awzelExport.getExportTime(), awzelExport.getExportUser()});
    }

    public static boolean isMonthExportable(String month, User user) {
        if (month == null || !month.matches("\\d{6}")) {
            return false;
        }
        Query iterator = AwzelEntry.getEntriesForMonth((int)Integer.parseInt(month.substring(4)), (int)Integer.parseInt(month.substring(0, 4)), (User)user);
        MyConsumer consumer = new MyConsumer();
        iterator.findEach((Consumer)consumer);
        if (consumer.hasInvalid) {
            return false;
        }
        return consumer.hasEntries;
    }

    public static String getParticipantCompany(AwzelParticipantContactPerson contactPerson) {
        StringBuilder textBuilder = new StringBuilder();
        if (contactPerson.getCompany().getName() != null) {
            textBuilder.append(contactPerson.getCompany().getName());
        }
        if (contactPerson.getCompany().getInstituteId() != null) {
            if (!textBuilder.isEmpty()) {
                textBuilder.append(" - ");
            }
            textBuilder.append(contactPerson.getCompany().getInstituteId());
        }
        return textBuilder.toString();
    }

    public static String getParticipantContactPerson(AwzelParticipantContactPerson contactPerson) {
        StringBuilder textBuilder = new StringBuilder();
        if (contactPerson.getTitle() != null && !contactPerson.getTitle().isEmpty()) {
            textBuilder.append(contactPerson.getTitle());
        }
        if (contactPerson.getSurname() != null && !contactPerson.getSurname().isEmpty()) {
            if (!textBuilder.isEmpty()) {
                textBuilder.append(' ');
            }
            textBuilder.append(contactPerson.getSurname());
        }
        if (contactPerson.getFirstName() != null && !contactPerson.getFirstName().isEmpty()) {
            if (!textBuilder.isEmpty()) {
                textBuilder.append(", ");
            }
            textBuilder.append(contactPerson.getFirstName());
        }
        if (contactPerson.getExtranetId() != null && !contactPerson.getExtranetId().isEmpty()) {
            if (!textBuilder.isEmpty()) {
                textBuilder.append(" - ");
            }
            textBuilder.append(contactPerson.getExtranetId());
        }
        return textBuilder.toString();
    }

    public static Seq<Tuple2<String, String>> getEntryReporters(User user, boolean addEmptyLine) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (addEmptyLine) {
            result.add(Scala.Tuple((Object)"", (Object)""));
        }
        StringBuilder displayName = new StringBuilder();
        for (AwzelParticipantContactPerson contactPerson : AwzelParticipantContactPerson.findAll((User)user).findList()) {
            displayName.setLength(0);
            if (contactPerson.getCompany().getName() != null && !contactPerson.getCompany().getName().isEmpty()) {
                displayName.append(contactPerson.getCompany().getName());
            }
            if (contactPerson.getCompany().getInstituteId() != null && !contactPerson.getCompany().getInstituteId().isEmpty()) {
                if (!displayName.isEmpty()) {
                    displayName.append(" (").append(contactPerson.getCompany().getInstituteId()).append(')');
                } else {
                    displayName.append(contactPerson.getCompany().getInstituteId());
                }
            }
            if (!displayName.isEmpty()) {
                displayName.append(" - ");
            }
            if (contactPerson.getSurname() != null && !contactPerson.getSurname().isEmpty()) {
                displayName.append(contactPerson.getSurname());
            }
            if (contactPerson.getFirstName() != null && !contactPerson.getFirstName().isEmpty()) {
                if (contactPerson.getSurname() != null && !contactPerson.getSurname().isEmpty()) {
                    displayName.append(", ");
                }
                displayName.append(contactPerson.getFirstName());
            }
            result.add(Scala.Tuple((Object)String.valueOf(contactPerson.getPersonId()), (Object)Utils.addZWNJ(displayName.toString())));
        }
        result.sort((o1, o2) -> {
            if (o1 == null || o1._2 == null) {
                return o2 == null || o2._2 == null ? 0 : 1;
            }
            return ((String)o1._2).compareTo((String)o2._2);
        });
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getCountries(Locale locale) {
        return Awv.getCountries(locale, false);
    }

    public static Seq<Tuple2<String, String>> getCountries(Locale locale, boolean includeGermany) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        CountryProvider provider = new CountryProvider(locale);
        for (String label : provider.getCountryLabels()) {
            result.add(Scala.Tuple((Object)provider.getISOCountryCode(label), (Object)label));
        }
        result.sort((o1, o2) -> {
            if (o1 == null || o1._2 == null) {
                return o2 == null || o2._2 == null ? 0 : 1;
            }
            return ((String)o1._2).compareTo((String)o2._2);
        });
        if (includeGermany) {
            result.add(0, Scala.Tuple((Object)Locale.GERMANY.getCountry(), (Object)Locale.GERMANY.getDisplayCountry(locale)));
        }
        return Scala.toSeq(result);
    }

    public static String editHelpUrl(AwzelEntry.EntryType entryType) {
        if (entryType == AwzelEntry.EntryType.DIKA) {
            return "awv/services-capital";
        }
        if (entryType == AwzelEntry.EntryType.DIRINV) {
            return "awv/direct-investments";
        }
        if (entryType == AwzelEntry.EntryType.TRANSIT) {
            return "awv/transit-trade";
        }
        return "awv/notification-create";
    }

    @Inject
    public Awv(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext, Formatters formatters) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
        formatters.register(BigDecimal.class, (Formatters.SimpleFormatter)new BigDecimalFormatter());
    }

    public Result notifications(Http.Request request) {
        Form form = this.formFactory.form(AwvCreateReportForm.class).fill((Object)new AwvCreateReportForm());
        return this.loadNotifications(request, (Form<AwvCreateReportForm>)form);
    }

    private Result loadNotifications(Http.Request request, Form<AwvCreateReportForm> form) {
        List list;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sort = new SortingHandler(user, Sorting.Table.AWZEL_ENTRY);
        Query query = AwzelEntry.getQueryForUser((User)user).order("reportMonth DESC");
        if (sort.getSortingColumn() == 1) {
            if (sort.isSortingAscending()) {
                query.order("category ASC");
            } else {
                query.order("category DESC");
            }
        } else if (sort.getSortingColumn() == 2) {
            if (sort.isSortingAscending()) {
                query.order("serviceCode ASC");
            } else {
                query.order("serviceCode DESC");
            }
        } else if (sort.isSortingAscending()) {
            query.order("type ASC");
        } else {
            query.order("type DESC");
        }
        sort.computeForQuery(query);
        HashMap<Tuple2<Tenant, String>, List<AwzelEntry>> entries = new HashMap<Tuple2<Tenant, String>, List<AwzelEntry>>();
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.AWZEL_ENTRY, (Call)routes.Awv.notifications());
        }
        for (AwzelEntry entry : list) {
            Tuple2 key = Scala.Tuple((Object)entry.getTenant(), (Object)entry.getReportMonth());
            list = entries.computeIfAbsent((Tuple2<Tenant, String>)key, k -> new ArrayList());
            list.add(entry);
        }
        return Awv.ok((Content)awvnotifications.render(entries, form, sort, messages, request));
    }

    public Result notificationsPage(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.AWZEL_ENTRY).updatePage(page, pageSize);
        return Awv.redirect((Call)routes.Awv.notifications());
    }

    public Result notificationsSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.AWZEL_ENTRY).updateSort(sort, ascending);
        return Awv.redirect((Call)routes.Awv.notifications());
    }

    public Result newNotification(Http.Request request, String type) {
        return this.newNotification(request, type, false);
    }

    public Result postNewNotification(Http.Request request, String type) {
        return this.newNotification(request, type, true);
    }

    private Result newNotification(Http.Request request, String type, boolean post) {
        Form<? extends AwvNotificationForm> form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        AwzelEntry.EntryType entryType = AwzelEntry.EntryType.valueOf((String)type);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (entryType == AwzelEntry.EntryType.DIKA) {
            form = this.formFactory.form(AwvDikaNotificationForm.class).fill((Object)new AwvDikaNotificationForm());
        } else if (entryType == AwzelEntry.EntryType.TRANSIT) {
            form = this.formFactory.form(AwvTransitNotificationForm.class).fill((Object)new AwvTransitNotificationForm());
        } else if (entryType == AwzelEntry.EntryType.DIRINV) {
            form = this.formFactory.form(AwvDirinvNotificationForm.class).fill((Object)new AwvDirinvNotificationForm());
        } else {
            return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", messages.at("awv.notifications.type.unknown", new Object[]{type}));
        }
        if (post) {
            if (!(form = form.bindFromRequest(request, new String[0])).hasErrors()) {
                form = ((AwvNotificationForm)form.get()).validate(form, messages.lang().toLocale(), user);
            }
            if (!form.hasErrors()) {
                ((AwvNotificationForm)form.get()).store(user);
            }
            if (form.hasErrors()) {
                return Awv.ok((Content)newawvnotification.render(form, entryType, messages, request));
            }
            return Awv.redirect((Call)routes.Awv.notifications()).flashing("success", messages.at("awv.notifications.new.done", new Object[]{entryType.ordinal()}));
        }
        if (form.value().isPresent()) {
            return Awv.ok((Content)newawvnotification.render(form, entryType, messages, request));
        }
        return Awv.internalServerError();
    }

    public Result notification(Http.Request request, int id) {
        return this.notification(request, id, false, false);
    }

    public Result postNotification(Http.Request request, int id) {
        return this.notification(request, id, true, false);
    }

    public Result notificationEdit(Http.Request request, int id) {
        return this.notification(request, id, false, true);
    }

    private Result notification(Http.Request request, int id, boolean post, boolean inEditMode) {
        Form form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        AwzelEntry entry = AwzelEntry.findForId((int)id, (User)user);
        if (entry == null) {
            return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", messages.at("awv.notifications.unknown", new Object[0]));
        }
        if (post) {
            Form<? extends AwvNotificationForm> form2;
            if (entry.getType() == AwzelEntry.EntryType.DIKA) {
                form2 = this.formFactory.form(AwvDikaNotificationForm.class).bindFromRequest(request, new String[0]);
            } else if (entry.getType() == AwzelEntry.EntryType.TRANSIT) {
                form2 = this.formFactory.form(AwvTransitNotificationForm.class).bindFromRequest(request, new String[0]);
            } else if (entry.getType() == AwzelEntry.EntryType.DIRINV) {
                form2 = this.formFactory.form(AwvDirinvNotificationForm.class).bindFromRequest(request, new String[0]);
            } else {
                return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", messages.at("awv.notifications.type.unknown", new Object[]{entry.getType()}));
            }
            if (!form2.hasErrors()) {
                form2 = ((AwvNotificationForm)form2.get()).validate(form2, messages.lang().toLocale(), user);
            }
            if (!form2.hasErrors()) {
                ((AwvNotificationForm)form2.get()).store(entry, user);
            }
            if (form2.hasErrors()) {
                return Awv.ok((Content)editawvnotification.render(form2, entry, inEditMode, messages, request));
            }
            return Awv.redirect((Call)routes.Awv.notification(id)).flashing("success", messages.at("awv.notifications.modified", new Object[0]));
        }
        if (entry.getType() == AwzelEntry.EntryType.DIKA) {
            form = this.formFactory.form(AwvDikaNotificationForm.class).fill((Object)new AwvDikaNotificationForm(entry));
        } else if (entry.getType() == AwzelEntry.EntryType.TRANSIT) {
            form = this.formFactory.form(AwvTransitNotificationForm.class).fill((Object)new AwvTransitNotificationForm(entry));
        } else if (entry.getType() == AwzelEntry.EntryType.DIRINV) {
            form = this.formFactory.form(AwvDirinvNotificationForm.class).fill((Object)new AwvDirinvNotificationForm(entry));
        } else {
            return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", messages.at("awv.notifications.type.unknown", new Object[]{entry.getType()}));
        }
        return Awv.ok((Content)editawvnotification.render((Form<? extends AwvNotificationForm>)form, entry, inEditMode, messages, request));
    }

    public Result deleteNotifications(Http.Request request) {
        return this.deleteAwvNotifications(request, null);
    }

    public Result deleteNotification(Http.Request request, Integer id) {
        return this.deleteAwvNotifications(request, id);
    }

    public Result deleteAwvNotifications(Http.Request request, Integer id) {
        int number2;
        List<Integer> selectedIds;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (id != null) {
            selectedIds = Collections.singletonList(id);
        } else {
            String selection = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            selectedIds = GeneralUtils.getSelectionIds(selection);
        }
        if (!selectedIds.isEmpty()) {
            List entries = AwzelEntry.findForIds(selectedIds, (User)user);
            number2 = DB.deleteAll((Collection)entries);
        } else {
            number2 = 0;
        }
        String flashKey = number2 == 0 ? "warning" : "success";
        return Awv.redirect((Call)routes.Awv.notifications()).flashing(flashKey, messages.at("awv.notifications.delete", new Object[]{number2}));
    }

    public Result createCancellation(Http.Request request) {
        return this.createCancellation(request, null);
    }

    public Result createCancellationSingle(Http.Request request, Integer id) {
        return this.createCancellation(request, id);
    }

    private Result createCancellation(Http.Request request, Integer id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String selection = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List<Integer> selectedIds = id != null ? Collections.singletonList(id) : GeneralUtils.getSelectionIds(selection);
        int number2 = 0;
        if (!selectedIds.isEmpty()) {
            List entries = AwzelEntry.findForIds(selectedIds, (User)user);
            for (AwzelEntry entry : entries) {
                if (!AwzelApi.isEntryCancelable((AwzelEntry)entry)) continue;
                AwzelApi.createCancellationFromAwzelEntry((AwzelEntry)entry);
                ++number2;
            }
        }
        String flashKey = number2 == 0 ? "warning" : "success";
        if (id != null) {
            return Awv.redirect((Call)routes.Awv.notification(id)).flashing(flashKey, messages.at("awv.notifications.createcancellation.done", new Object[]{number2}));
        }
        return Awv.redirect((Call)routes.Awv.notifications()).flashing(flashKey, messages.at("awv.notifications.createcancellation.done", new Object[]{number2}));
    }

    public Result changeNotificationType(Http.Request request, int id, String newTypeString) {
        return this.changeNotificationType(request, id, newTypeString, false);
    }

    public Result postChangeNotificationType(Http.Request request, int id, String newTypeString) {
        return this.changeNotificationType(request, id, newTypeString, true);
    }

    private Result changeNotificationType(Http.Request request, int id, String newTypeString, boolean post) {
        Form form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        AwzelEntry entry = AwzelEntry.findForId((int)id, (User)user);
        if (entry == null) {
            return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", messages.at("awv.notifications.unknown", new Object[0]));
        }
        AwzelEntry.EntryType newType = AwzelEntry.EntryType.valueOf((String)newTypeString);
        if (newType == entry.getType()) {
            return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", messages.at("awv.notifications.changenotificationtype.unknowntype", new Object[]{newTypeString}));
        }
        if (post) {
            Form<? extends AwvNotificationForm> form2;
            if (newType == AwzelEntry.EntryType.DIKA) {
                form2 = this.formFactory.form(AwvDikaNotificationForm.class).bindFromRequest(request, new String[0]);
            } else if (newType == AwzelEntry.EntryType.TRANSIT) {
                form2 = this.formFactory.form(AwvTransitNotificationForm.class).bindFromRequest(request, new String[0]);
            } else if (newType == AwzelEntry.EntryType.DIRINV) {
                form2 = this.formFactory.form(AwvDirinvNotificationForm.class).bindFromRequest(request, new String[0]);
            } else {
                return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", messages.at("awv.notifications.unknown", new Object[0]));
            }
            if (!form2.hasErrors()) {
                form2 = ((AwvNotificationForm)form2.get()).validate(form2, messages.lang().toLocale(), user);
            }
            if (!form2.hasErrors()) {
                ((AwvNotificationForm)form2.get()).store(user);
            }
            if (form2.hasErrors()) {
                return Awv.ok((Content)convertawvnotification.render(form2, newType, id, messages, request));
            }
            entry.delete();
            return Awv.redirect((Call)routes.Awv.notifications()).flashing("success", messages.at("awv.notifications.changenotificationtype.done", new Object[0]));
        }
        if (newType == AwzelEntry.EntryType.DIKA) {
            form = this.formFactory.form(AwvDikaNotificationForm.class).fill((Object)new AwvDikaNotificationForm(entry));
        } else if (newType == AwzelEntry.EntryType.TRANSIT) {
            form = this.formFactory.form(AwvTransitNotificationForm.class).fill((Object)new AwvTransitNotificationForm(entry));
        } else if (newType == AwzelEntry.EntryType.DIRINV) {
            form = this.formFactory.form(AwvDirinvNotificationForm.class).fill((Object)new AwvDirinvNotificationForm(entry));
        } else {
            return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", messages.at("awv.notifications.unknown", new Object[0]));
        }
        return Awv.ok((Content)convertawvnotification.render((Form<? extends AwvNotificationForm>)form, newType, id, messages, request));
    }

    public CompletionStage<Result> createReportFile(Http.Request request, String monthString) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(AwvCreateReportForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            int month = -1;
            int year = -1;
            if (monthString != null) {
                Matcher m = DATA_MONTH_PATTERN.matcher(monthString);
                if (m.matches()) {
                    year = Integer.parseInt(m.group(1));
                    month = Integer.parseInt(m.group(2));
                } else {
                    return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", MessageFormat.format(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.invalidMonth", (Object[])new Object[0]), monthString));
                }
            }
            if (AwzelParticipantContactPerson.countNumberOfParticipants((User)user) == 0) {
                return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", messages.at("awv.notifications.report.noparticipants", new Object[0]));
            }
            Form<AwvCreateReportForm> resultForm = form;
            if (AwzelEntry.countEntriesForMonth((String)monthString, (User)user) == 0) {
                return Awv.redirect((Call)routes.Awv.notifications()).flashing("error", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.creatingAwvReport", (Object[])new Object[]{messages.at("awv.notifications.report.nodata", new Object[0])}));
            }
            if (!resultForm.hasErrors()) {
                resultForm = ((AwvCreateReportForm)resultForm.get()).validate(messages, resultForm, month, year);
            }
            if (resultForm.hasErrors() || ((AwvCreateReportForm)resultForm.get()).getReportCreationInfo() == null) {
                return this.loadNotifications(request, resultForm);
            }
            final HashMap flashMap = new HashMap();
            ReportCreationRunnerApi runner = new ReportCreationRunnerApi(this, new File(Util.WORKSPACEDIR, "tmp"), ((AwvCreateReportForm)resultForm.get()).getReportCreationInfo(), user, BLLoggerPlay.getLogger(), messages.lang().toLocale(), false){

                protected void notifyListenersForCreatedExportFile() {
                }

                protected void handleError(String message) {
                    Utils.addToFlash(flashMap, "error", message);
                }

                protected boolean askToOverwrite(File file2) {
                    return true;
                }
            };
            runner.run();
            try {
                if (form.hasErrors() || runner.getResultFiles() == null || runner.getResultFiles().isEmpty()) {
                    return Awv.redirect((Call)routes.Awv.notifications()).flashing(flashMap);
                }
                if (runner.getResultFiles().size() > 1) {
                    Object filename = ((File)runner.getResultFiles().get(0)).getName();
                    filename = ((String)filename).substring(0, ((String)filename).length() - 3) + "zip";
                    return GeneralUtils.supplyZipFile(runner.getResultFiles(), false, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement((String)filename));
                }
                String filename = ((File)runner.getResultFiles().get(0)).getName();
                String contentType = filename.length() > 3 && filename.substring(filename.length() - 3).equalsIgnoreCase("CSV") ? "text/comma-separated-values" : "application/xml";
                return GeneralUtils.supplyWorkspaceFile((File)runner.getResultFiles().get(0), false, true).as(contentType).withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(filename));
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to create the AWV report file!", e);
                return Awv.redirect((Call)routes.Awv.notifications()).flashing("HTMLerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.creatingAwvReport", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public Result createFromSignedPayments(Http.Request request) {
        return this.createAwvFromSignedPayments(request, null);
    }

    public Result createFromSignedPayment(Http.Request request, Integer id) {
        return this.createAwvFromSignedPayments(request, id);
    }

    private Result createAwvFromSignedPayments(Http.Request request, Integer id) {
        List<Integer> ids;
        play.api.mvc.Call redirectTo;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            redirectTo = routes.SignedPayments.payment(id, null);
            ids = Collections.singletonList(id);
        } else {
            redirectTo = routes.SignedPayments.index(false);
            String paymentIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            ids = GeneralUtils.getSelectionIds(paymentIds);
        }
        AwvPaymentReportCollector collector = new AwvPaymentReportCollector();
        int count = 0;
        for (SignedPayment signedPayment : DB.find(SignedPayment.class).where().in("id", ids).findList()) {
            try {
                if (collector.storePayment(new AwvPaymentReportCollector.PaymentInfo(signedPayment)) == null) continue;
                ++count;
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to read payment information for signed payment " + signedPayment.getId(), e);
            }
        }
        String flashKey = count == 0 ? "warning" : "success";
        return Awv.redirect((Call)redirectTo).flashing(flashKey, messages.at("bookings.createawv.done", new Object[]{count}));
    }

    public Result createFromBookings(Http.Request request, Integer accountId, Integer statementId, Integer pageId, Integer folder) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String bookingIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Integer> ids = GeneralUtils.getSelectionIds(bookingIds);
        AwvBookingsCollector collector = new AwvBookingsCollector();
        int count = 0;
        for (CmBooking booking : DB.find(CmBooking.class).where().in("id", ids).findList()) {
            if (collector.storeStatementBooking(booking) == null) continue;
            ++count;
        }
        String flashKey = count == 0 ? "warning" : "success";
        return Awv.redirect((Call)routes.Bookings.bookings(accountId, null, statementId, pageId, folder, null)).flashing(flashKey, messages.at("bookings.createawv.done", new Object[]{count}));
    }

    public Result createFromDti(Http.Request request, Integer accountId, Integer statementId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String bookingIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Integer> ids = GeneralUtils.getSelectionIds(bookingIds);
        AwvBookingsCollector collector = new AwvBookingsCollector();
        int count = 0;
        for (CmBooking booking : DB.find(CmBooking.class).where().in("id", ids).findList()) {
            if (collector.storeStatementBooking(booking) == null) continue;
            ++count;
        }
        String flashKey = count == 0 ? "warning" : "success";
        return Awv.redirect((Call)routes.DtiView.dti(accountId, statementId, null)).flashing(flashKey, messages.at("bookings.createawv.done", new Object[]{count}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result serviceCodes(Http.Request request, String entryType, Integer category, String search) {
        Locale locale = this.messagesApi.preferred((Http.RequestHeader)request).lang().toLocale();
        AwzelEntry.EntryType type = AwzelEntry.EntryType.valueOf((String)entryType);
        ServiceCodeProvider provider = new ServiceCodeProvider(type, BLLoggerPlay.getLogger(), locale);
        if (category != null && category > 0) {
            provider.setCategory(category.intValue());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
            int i = 0;
            StringBuilder builder = new StringBuilder();
            for (ServiceCodeProvider.ServiceCodeDetails details2 : provider.getProposals(search)) {
                builder.setLength(0);
                builder.append(details2.getServiceCode()).append('\t').append(details2.getLabel());
                if (details2.getDescription() != null && !details2.getDescription().isEmpty()) {
                    builder.append('\t').append(details2.getDescription());
                }
                writer.write(builder.append('\n').toString());
                if (++i < 10) continue;
                break;
            }
        }
        catch (IOException e) {
            try {
                BLLoggerPlay.error("Failed to create service code information!", e);
            }
            catch (Throwable throwable) {
                Util.closeStream(writer);
                throw throwable;
            }
            Util.closeStream((Closeable)writer);
        }
        Util.closeStream((Closeable)writer);
        return Awv.ok((byte[])baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result wareCodeNames(Http.Request request, String search) {
        Locale locale = this.messagesApi.preferred((Http.RequestHeader)request).lang().toLocale();
        WareCodeProvider provider = new WareCodeProvider(locale);
        Map proposals = provider.getProposals(search);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!proposals.isEmpty()) {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
                int i = 0;
                for (String code : proposals.keySet()) {
                    writer.write(code + "\t" + (String)proposals.get(code) + "\t" + provider.getWareDescription(code) + "\n");
                    if (++i < 10) continue;
                    break;
                }
            }
            catch (IOException e) {
                try {
                    BLLoggerPlay.error("Failed to create ware code information!", e);
                }
                catch (Throwable throwable) {
                    Util.closeStream(writer);
                    throw throwable;
                }
                Util.closeStream((Closeable)writer);
            }
            Util.closeStream((Closeable)writer);
        }
        return Awv.ok((byte[])baos.toByteArray());
    }

    public Result participants(Http.Request request) {
        List list;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sort = new SortingHandler(user, Sorting.Table.AWZEL_PARTICIPANT);
        Query query = AwzelParticipantContactPerson.findAll((User)user);
        Tenant t = Tenant.findById((int)Integer.parseInt(sort.getProperty("TENANT", "-1")), (User)user, (boolean)false);
        if (t != null) {
            query.where().eq("company.tenant", (Object)t);
        }
        if (sort.getSortingColumn() == 1) {
            if (sort.isSortingAscending()) {
                query.order("title ASC, surname ASC, firstname ASC, extranetId ASC");
            } else {
                query.order("title DESC, surname DESC, firstname DESC, extranetId DESC");
            }
        } else if (sort.getSortingColumn() == 2) {
            if (sort.isSortingAscending()) {
                query.order("department ASC");
            } else {
                query.order("department DESC");
            }
        } else if (sort.getSortingColumn() == 3) {
            if (sort.isSortingAscending()) {
                query.order("company.tenant ASC");
            } else {
                query.order("company.tenant DESC");
            }
        } else if (sort.isSortingAscending()) {
            query.order("company.name ASC, company.instituteId ASC");
        } else {
            query.order("company.name DESC, company.instituteId DESC");
        }
        sort.computeForQuery(query);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.AWZEL_PARTICIPANT, (Call)routes.Awv.participants());
        }
        return Awv.ok((Content)awvparticipants.render(list, sort, t, request, messages));
    }

    public Result participantsPage(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.AWZEL_PARTICIPANT).updatePage(page, pageSize);
        return Awv.redirect((Call)routes.Awv.participants());
    }

    public Result participantsSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.AWZEL_PARTICIPANT).updateSort(sort, ascending);
        return Awv.redirect((Call)routes.Awv.participants());
    }

    public Result participantsTenant(Http.Request request, Integer tenantId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.AWZEL_PARTICIPANT).setProperty("TENANT", tenantId != null ? String.valueOf(tenantId) : null);
        return Awv.redirect((Call)routes.Awv.participants());
    }

    public Result newParticipant(Http.Request request, boolean post) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (post) {
            Form<AwvParticipantForm> form = this.formFactory.form(AwvParticipantForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((AwvParticipantForm)form.get()).validate(form, user, null, messages);
            }
            if (form.hasErrors()) {
                return Awv.ok((Content)newawvparticipant.render(form, messages, request));
            }
            ((AwvParticipantForm)form.get()).store(user);
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("success", messages.at("awv.participants.new.done", new Object[0]));
            int deletedCompanies = ((AwvParticipantForm)form.get()).deleteCompanies();
            if (deletedCompanies < 0) {
                flashMap.put("warning", messages.at("awv.participants.deletecompany.failed", new Object[0]));
            }
            return Awv.redirect((Call)routes.Awv.participants()).flashing(flashMap);
        }
        Form form = this.formFactory.form(AwvParticipantForm.class).fill((Object)new AwvParticipantForm(user));
        return Awv.ok((Content)newawvparticipant.render((Form<AwvParticipantForm>)form, messages, request));
    }

    public Result participant(Http.Request request, int id) {
        return this.participantDetails(request, id, false, false);
    }

    public Result postParticipant(Http.Request request, int id) {
        return this.participantDetails(request, id, true, false);
    }

    public Result participantEdit(Http.Request request, int id) {
        return this.participantDetails(request, id, false, true);
    }

    private Result participantDetails(Http.Request request, int id, boolean post, boolean editMode) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        AwzelParticipantContactPerson participant = (AwzelParticipantContactPerson)DB.find(AwzelParticipantContactPerson.class, (Object)id);
        if (participant == null || !user.getTenants().contains(participant.getCompany().getTenant())) {
            return Awv.redirect((Call)routes.Awv.participants()).flashing("error", messages.at("awv.participants.unknown", new Object[0]));
        }
        if (post) {
            Form<AwvParticipantForm> form = this.formFactory.form(AwvParticipantForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((AwvParticipantForm)form.get()).validate(form, user, participant, messages);
            }
            if (form.hasErrors()) {
                return Awv.ok((Content)editawvparticipant.render(form, id, post || editMode, messages, request));
            }
            ((AwvParticipantForm)form.get()).store(participant, user);
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("success", messages.at("awv.participants.edit.done", new Object[0]));
            int deletedCompanies = ((AwvParticipantForm)form.get()).deleteCompanies();
            if (deletedCompanies < 0) {
                flashMap.put("warning", messages.at("awv.participants.deletecompany.failed", new Object[0]));
            }
            return Awv.redirect((Call)routes.Awv.participant(id)).flashing(flashMap);
        }
        Form form = this.formFactory.form(AwvParticipantForm.class).fill((Object)new AwvParticipantForm(participant));
        return Awv.ok((Content)editawvparticipant.render((Form<AwvParticipantForm>)form, id, editMode, messages, request));
    }

    public Result deleteParticipants(Http.Request request) {
        return this.deleteAwvParticipants(request, null);
    }

    public Result deleteParticipant(Http.Request request, Integer id) {
        return this.deleteAwvParticipants(request, id);
    }

    public Result deleteAwvParticipants(Http.Request request, Integer id) {
        String flashMessage;
        String flashKey;
        int count;
        List<Integer> ids;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            ids = Collections.singletonList(id);
        } else {
            String selection = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            ids = GeneralUtils.getSelectionIds(selection);
        }
        if (!ids.isEmpty()) {
            Update update;
            if (ids.size() == 1) {
                update = DB.createUpdate(AwzelParticipantContactPerson.class, (String)"DELETE FROM AwzelParticipantContactPerson WHERE personId = :id");
                update.set("id", (Object)ids.get(0));
            } else {
                update = DB.createUpdate(AwzelParticipantContactPerson.class, (String)"DELETE FROM AwzelParticipantContactPerson WHERE personId IN (:ids)");
                update.set("ids", ids);
            }
            try {
                count = update.execute();
            }
            catch (Exception e) {
                BLLoggerPlay.warning("Failed to delete AWV participant!", e);
                count = -1;
            }
        } else {
            count = 0;
        }
        if (count < 0) {
            flashKey = "warning";
            flashMessage = messages.at("awv.participants.delete.failed", new Object[]{ids.size()});
        } else if (count == 0) {
            flashKey = "warning";
            flashMessage = messages.at("awv.participants.delete", new Object[]{count});
        } else {
            flashKey = "success";
            flashMessage = messages.at("awv.participants.delete", new Object[]{count});
        }
        return Awv.redirect((Call)routes.Awv.participants()).flashing(flashKey, flashMessage);
    }

    private static class MyConsumer
    implements Consumer<AwzelEntry> {
        boolean hasEntries = false;
        boolean hasInvalid = false;

        private MyConsumer() {
        }

        @Override
        public void accept(AwzelEntry bean) {
            this.hasEntries = true;
            if (this.hasInvalid || !AwzelApi.isEntryValid((AwzelEntry)bean)) {
                this.hasInvalid = true;
            }
        }
    }
}

