/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.ExportFile;
import de.businesslogics.banking.database.vo.ExportFileFilter;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.mt940.api.AutomaticExporter;
import de.businesslogics.banking.mt940.api.CmCleanUp;
import io.ebean.Query;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.AutExportForm;
import models.SimpleTextForm;
import models.cm.AutomaticExportFileFilterForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.Scala;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.cm.autExportFiles;
import views.html.cm.autexportform;
import views.html.cm.automaticExports;

@Security.Authenticated(value=AuthenticatorFor.CM.class)
public class AutomaticExports
extends Controller {
    private static final String EXPORT_IDS = "export_ids";
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;

    public static List<Account> getAccounts(User user) {
        Query query = user.isAdmin() ? DB.find(Account.class).where().query() : Account.findAccountsQuery((User)user, (boolean)true);
        return query.order("bank.displayName, name, iban, id").findList();
    }

    @Inject
    public AutomaticExports(FormFactory formFactory, MessagesApi messagesApi) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
    }

    public Result index(Http.Request request) {
        List list;
        Tenant tenant;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!Utils.showAutomaticExports(user)) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.files()).flashing("warning", messages.at("autexports.exportsHidden", new Object[0]));
        }
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_EXPORT);
        try {
            int tenantId = Integer.parseInt(sorting.getProperty("TENANT", "-1"));
            tenant = Tenant.findById((int)tenantId, (User)user, (boolean)true);
        }
        catch (NumberFormatException ignored) {
            tenant = null;
        }
        Query<AutomaticExport> query = this.query(user, tenant, sorting.getSortingColumn(), sorting.isSortingAscending());
        sorting.computeForQuery(query);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.CM_EXPORT, (Call)routes.AutomaticExports.index());
        }
        return AutomaticExports.ok((Content)automaticExports.render(list, sorting, tenant, request, messages));
    }

    private Query<AutomaticExport> query(User user, Tenant tenant, int sort, boolean asc) {
        Query query = AutomaticExport.findAllForTenants((List)user.getVisibleTenants());
        if (tenant != null) {
            query.where().eq("tenant", (Object)tenant);
        }
        switch (sort) {
            case 1: {
                query = query.order("name " + (asc ? "asc" : "desc"));
                break;
            }
            case 2: {
                query = query.order("type " + (asc ? "asc" : "desc"));
            }
            case 3: {
                query = query.order("conversion.name " + (asc ? "asc" : "desc") + ", convert_to_pdf " + (asc ? "asc" : "desc"));
                break;
            }
            case 4: {
                query = query.order("directory " + (asc ? "asc" : "desc"));
                break;
            }
            case 5: {
                query = query.order("tenant.name " + (asc ? "asc" : "desc"));
            }
            default: {
                query = query.order("activated " + (asc ? "asc" : "desc"));
            }
        }
        return query;
    }

    public static String loadJsParametersOverview(Messages messages) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("selectedExports", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.countSelectedAutomaticExports", (Object[])new Object[]{999}));
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String loadJsParameters(User user, Messages messages) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("patternsample", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.exampleAppend", (Object[])new Object[]{""}));
        resultJson.put("nopattern", messages.at("error.required", new Object[0]));
        resultJson.put("incorrectpattern", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.incorrectNamePattern", (Object[])new Object[0]));
        resultJson.put("patternerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.invalidPattern", (Object[])new Object[0]));
        resultJson.put("editlinktemplate", routes.Conversions.edit(null).toString());
        resultJson.put("samplelinktemplate", routes.AutomaticExports.getExampleFileName(null, null).toString());
        List folders2 = CmFolder.findAll((User)user);
        resultJson.put("foldersexists", !folders2.isEmpty());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public Result index_sort(Http.Request request, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_EXPORT).updateSort(sort, asc);
        return AutomaticExports.redirect((Call)routes.AutomaticExports.index());
    }

    public Result index_pageSize(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_EXPORT).updatePage(page, pageSize);
        return AutomaticExports.redirect((Call)routes.AutomaticExports.index());
    }

    public Result index_tenant(Http.Request request, int tenantId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String propValue = tenantId >= 0 ? String.valueOf(tenantId) : null;
        new SortingHandler(user, Sorting.Table.CM_EXPORT).setProperty("TENANT", propValue);
        return AutomaticExports.redirect((Call)routes.AutomaticExports.index());
    }

    public Result newAutExport(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!Utils.showAutomaticExports(user)) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.index());
        }
        AutExportForm autExportForm = new AutExportForm();
        autExportForm.active = true;
        return AutomaticExports.ok((Content)autexportform.render(null, (Form<AutExportForm>)this.formFactory.form(AutExportForm.class).fill((Object)autExportForm), true, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result edit(Http.Request request, Integer id) {
        return this.editAutomaticExport(request, id, false);
    }

    public Result editMode(Http.Request request, Integer id) {
        return this.editAutomaticExport(request, id, true);
    }

    public Result editAutomaticExport(Http.Request request, Integer id, boolean inEditMode) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!Utils.showAutomaticExports(user)) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.index());
        }
        AutomaticExport export = AutomaticExport.findById((int)id, (User)user);
        if (export == null) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.index()).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("autexports.error.noSuchExport", new Object[0]));
        }
        Form form = this.formFactory.form(AutExportForm.class).fill((Object)AutExportForm.fill(export));
        return AutomaticExports.ok((Content)autexportform.render(id, (Form<AutExportForm>)form, inEditMode, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result postForm(Http.Request request, Integer id) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (!Utils.showAutomaticExports(user)) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.index());
        }
        Form<AutExportForm> form = this.formFactory.form(AutExportForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors()) {
            form = ((AutExportForm)form.get()).validate(form, user);
        }
        if (form.hasErrors()) {
            return AutomaticExports.ok((Content)autexportform.render(id, form, true, request, messages));
        }
        AutomaticExport export = new AutomaticExport();
        if (id != null && (export = AutomaticExport.findById((int)id, (User)user)) == null) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.index()).flashing("error", messages.at("autexports.error.noSuchExport", new Object[0]));
        }
        AutExportForm value = (AutExportForm)form.get();
        export = value.getAutExport(export, user);
        export.save();
        if (id != null) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.edit(id)).flashing("success", messages.at("autexports.success.saved", new Object[]{export.getName()}));
        }
        return AutomaticExports.redirect((Call)routes.AutomaticExports.index()).flashing("success", messages.at("autexports.success.saved", new Object[]{export.getName()}));
    }

    public static String getFilterDescription(SortingHandler sorting, ExportFileFilter filter, User user, Messages messages) {
        if (filter == null) {
            if (sorting.getProperty(EXPORT_IDS) == null) {
                return "";
            }
            List<Integer> id = GeneralUtils.getSelectionIds(sorting.getProperty(EXPORT_IDS));
            AutomaticExport export = AutomaticExport.findById((int)id.getFirst(), (User)user);
            return messages.at("autexports.filter.automaticExport", new Object[]{export.getName()});
        }
        StringBuilder result = new StringBuilder();
        if (filter.getAutomaticExportId() != null && filter.getAutomaticExportId() > 0) {
            AutomaticExport export = AutomaticExport.findById((int)filter.getAutomaticExportId(), (User)user);
            if (export != null) {
                result.append(messages.at("autexports.filter.automaticExport", new Object[]{export.getName()}));
            } else {
                filter.setAutomaticExportId(null);
                filter.save();
            }
        }
        if (filter.getFileName() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            if (filter.getFileNameComparator() == FilterComparator.Text.STARTS_WITH) {
                result.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"Filter.filename.startswith", (Object[])new Object[]{filter.getFileName()}));
            } else if (filter.getFileNameComparator() == FilterComparator.Text.ENDS_WITH) {
                result.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"Filter.filename.endswith", (Object[])new Object[]{filter.getFileName()}));
            } else if (filter.getFileNameComparator() == FilterComparator.Text.CONTAINS_NOT) {
                result.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"Filter.filename.containsnot", (Object[])new Object[]{filter.getFileName()}));
            } else {
                result.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"Filter.filename.contains", (Object[])new Object[]{filter.getFileName()}));
            }
        }
        if (filter.getDateComparator() != null && filter.getFromDate() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            result.append(messages.at("notifications.filter.date", new Object[]{filter.getDateComparator().ordinal(), filter.getFromDate(), filter.getToDate()}));
        }
        return result.toString();
    }

    public Result activate(Http.Request request, boolean active) {
        return this.activateAutomaticExports(request, active, null);
    }

    public Result activateAutomaticExport(Http.Request request, boolean active, Integer id) {
        return this.activateAutomaticExports(request, active, id);
    }

    public Result activateAutomaticExports(Http.Request request, boolean active, Integer exportId) {
        play.api.mvc.Call redirectTo;
        String ids;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (exportId != null) {
            ids = exportId.toString();
            redirectTo = routes.AutomaticExports.edit(exportId);
        } else {
            ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.AutomaticExports.index();
        }
        if (!Utils.showAutomaticExports(user)) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.index());
        }
        int notFound2 = 0;
        int done = 0;
        for (Integer id : GeneralUtils.getSelectionIds(ids)) {
            AutomaticExport export = AutomaticExport.findById((int)id, (User)user);
            if (export == null) {
                ++notFound2;
                continue;
            }
            if (export.isActivated() == active) continue;
            export.setActivated(active);
            export.save();
            ++done;
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (active) {
            flashMap.put("success", this.messagesApi.preferred((Http.RequestHeader)request).at("autexports.activate.success", new Object[]{done}));
        } else {
            flashMap.put("success", this.messagesApi.preferred((Http.RequestHeader)request).at("autexports.deactivate.success", new Object[]{done}));
        }
        if (notFound2 > 0) {
            flashMap.put("warning", this.messagesApi.preferred((Http.RequestHeader)request).at("autexports.error.someExportsNotFound", new Object[]{notFound2}));
        }
        return AutomaticExports.redirect((Call)redirectTo).flashing(flashMap);
    }

    public Result delete(Http.Request request) {
        return this.deleteAutomaticExports(request, null);
    }

    public Result deleteAutomaticExport(Http.Request request, Integer id) {
        return this.deleteAutomaticExports(request, id);
    }

    public static Seq<Tuple2<String, String>> getExportTypes(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(new Tuple2((Object)AutomaticExport.Type.STATEMENT.name(), (Object)messages.at("fetchschedule.statements", new Object[0])));
        result.add(new Tuple2((Object)AutomaticExport.Type.ADVICE.name(), (Object)messages.at("fetchschedule.advice", new Object[0])));
        result.add(new Tuple2((Object)AutomaticExport.Type.BATCHED_TRANSACTION_FILE.name(), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.batchedTransactionFiles", (Object[])new Object[0])));
        return Scala.toSeq(result);
    }

    public Result filesByID(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String exportIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        ExportFileFilter fetchFilter = ExportFileFilter.getFilter((User)user);
        fetchFilter.setExportFileActive(true);
        fetchFilter.setAutomaticExportId(Integer.valueOf(Integer.parseInt(exportIds)));
        fetchFilter.save();
        return AutomaticExports.redirect((Call)routes.AutomaticExports.files());
    }

    public Result files_tenant(Http.Request request, Integer tenant) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_EXPORT_FILES).setProperty("TENANT", tenant != null ? String.valueOf(tenant) : null);
        return AutomaticExports.redirect((Call)routes.AutomaticExports.files());
    }

    public static Seq<Tuple2<String, String>> getAutomaticExports(String username, boolean includeEmpty) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (includeEmpty) {
            result.add(Scala.Tuple((Object)"-1", (Object)""));
        }
        User user = User.getUser((String)username);
        List list = AutomaticExport.findAllForTenants((List)user.getVisibleTenants()).findList();
        for (AutomaticExport autExp : list) {
            Object bankName = autExp.getName();
            if (user.getTenants().size() > 1) {
                bankName = (String)bankName + " (" + autExp.getTenant().getName() + ")";
            }
            result.add(new Tuple2((Object)autExp.getId().toString(), (Object)Utils.addZWNJ((String)bankName)));
        }
        result.sort((o1, o2) -> ((String)o1._2).compareTo((String)o2._2));
        return Scala.toSeq(result);
    }

    public Result filesFilter(Http.Request request, boolean active) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        ExportFileFilter fetchFilter = ExportFileFilter.getFilter((User)user);
        if (active) {
            Form<AutomaticExportFileFilterForm> form = this.formFactory.form(AutomaticExportFileFilterForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((AutomaticExportFileFilterForm)form.get()).validate(form, fetchFilter);
            }
            if (form.hasErrors()) {
                return this.internalFileIndex(request, form, fetchFilter);
            }
            fetchFilter.setExportFileActive(!fetchFilter.isEmpty());
        } else {
            fetchFilter.setExportFileActive(false);
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_EXPORT_FILES);
            sorting.setProperty(EXPORT_IDS, null);
        }
        fetchFilter.save();
        return AutomaticExports.redirect((Call)routes.AutomaticExports.files());
    }

    private Result internalFileIndex(Http.Request request, Form<AutomaticExportFileFilterForm> filterForm, ExportFileFilter filter) {
        Tenant tenant;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_EXPORT_FILES);
        try {
            int tenantId = Integer.parseInt(sorting.getProperty("TENANT", "-1"));
            tenant = Tenant.findById((int)tenantId, (User)user, (boolean)false);
        }
        catch (NumberFormatException e) {
            tenant = null;
        }
        List<ExportFile> list = this.filesList(user, sorting, filter, tenant);
        sorting.computeForList(list);
        return AutomaticExports.ok((Content)autExportFiles.render(list, sorting, filterForm, filter, tenant, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public static String getName(Messages messages, AutomaticExport.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case AutomaticExport.Type.ADVICE -> messages.at("fetchschedule.advice", new Object[0]);
            case AutomaticExport.Type.BATCHED_TRANSACTION_FILE -> BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.batchedTransactionFiles", (Object[])new Object[0]);
            case AutomaticExport.Type.STATEMENT -> messages.at("fetchschedule.statements", new Object[0]);
        };
    }

    public Result getExampleFileName(String pattern, String exportName) {
        if (pattern == null || pattern.isEmpty()) {
            return AutomaticExports.badRequest((String)"noPattern");
        }
        try {
            if (exportName == null || exportName.isEmpty()) {
                exportName = "Test";
            }
            return AutomaticExports.ok((String)AutomaticExporter.getExample((String)exportName).substitute(pattern));
        }
        catch (Exception e) {
            return AutomaticExports.badRequest((String)"incorrectPattern");
        }
    }

    private List<ExportFile> filesList(User user, SortingHandler sortingHandler, ExportFileFilter filter, Tenant tenant) {
        Query query = user.isAdmin() ? DB.find(ExportFile.class) : ExportFile.findQueryByUser((User)user);
        if (filter.isExportFileActive() && !filter.isEmpty()) {
            query.where(filter.getExpression());
        }
        switch (sortingHandler.getSortingColumn()) {
            case 0: 
            case 1: {
                query.orderBy("workspaceFile.path " + (sortingHandler.isSortingAscending() ? "asc" : "desc"));
                break;
            }
            case 3: {
                query.orderBy("workspaceFile.size " + (sortingHandler.isSortingAscending() ? "asc" : "desc"));
                break;
            }
            case 2: {
                query.orderBy("lastUpdate " + (sortingHandler.isSortingAscending() ? "asc" : "desc"));
                break;
            }
            case 4: {
                query.orderBy("account.bank.tenantId " + (sortingHandler.isSortingAscending() ? "asc" : "desc"));
            }
        }
        sortingHandler.computeForQuery(query);
        if (tenant != null) {
            query = query.where().eq("accounts.bank.tenant", (Object)tenant).query();
        }
        return query.findList();
    }

    public Result files_sort(Http.Request request, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_EXPORT_FILES).updateSort(sort, asc);
        return AutomaticExports.redirect((Call)routes.AutomaticExports.files());
    }

    public Result files_pageSize(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_EXPORT_FILES).updatePage(page, pageSize);
        return AutomaticExports.redirect((Call)routes.AutomaticExports.files());
    }

    public Result downloadFile(Http.Request request, int id) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        ExportFile f = ExportFile.findByIdAndUser((int)id, (User)user);
        if (f == null) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.files()).flashing("error", messages.at("pdfstatements.error.noSuchFile", new Object[0]));
        }
        File file2 = WorkspaceFileSystem.getFile((WorkspaceFile)f.getWorkspaceFile());
        if (!file2.exists() || !file2.isFile()) {
            CmCleanUp.delete((ExportFile)f);
            return AutomaticExports.redirect((Call)routes.AutomaticExports.files()).flashing("error", messages.at("pdfstatements.error.noSuchFile", new Object[0]));
        }
        try {
            Result result = GeneralUtils.supplyWorkspaceFile(file2, true, false);
            if (file2.getName().endsWith("pdf")) {
                result = result.as("application/pdf");
            }
            return result.withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
        }
        catch (IOException | GeneralSecurityException e) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.files()).flashing("error", messages.at("error.supplyingfile", new Object[]{e.toString()}));
        }
    }

    public Result deleteFile(Http.Request request) {
        return this.deleteFiles(request, null);
    }

    public Result deleteFileSingle(Http.Request request, Integer id) {
        return this.deleteFiles(request, id);
    }

    public Result deleteFiles(Http.Request request, Integer id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String idsString = id != null ? id.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        int countSuccess = 0;
        int countFailed = 0;
        for (int i : GeneralUtils.getSelectionIds(idsString)) {
            ExportFile f = ExportFile.findByIdAndUser((int)i, (User)user);
            if (f == null) {
                ++countFailed;
                continue;
            }
            CmCleanUp.delete((ExportFile)f);
            ++countSuccess;
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (countSuccess > 0) {
            flashMap.put("success", messages.at("fetched.success.deleted", new Object[]{countSuccess}));
        }
        if (countFailed > 0) {
            flashMap.put("warning", messages.at("pdfstatements.error.cannotDelete", new Object[]{countFailed}));
        }
        return AutomaticExports.redirect((Call)routes.AutomaticExports.files()).flashing(flashMap);
    }

    public Result getZipFile(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String idsString = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        ArrayList<File> list = new ArrayList<File>();
        for (int i : GeneralUtils.getSelectionIds(idsString)) {
            ExportFile f = ExportFile.findByIdAndUser((int)i, (User)user);
            if (f == null) continue;
            list.add(WorkspaceFileSystem.getFile((WorkspaceFile)f.getWorkspaceFile()));
        }
        if (list.isEmpty()) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.files()).flashing("error", messages.at("fetched.error.noFilesToZip", new Object[0]));
        }
        try {
            return GeneralUtils.supplyZipFile(list, true, false).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("ExportFiles.zip"));
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to create zip download to export files!", e);
            return AutomaticExports.redirect((Call)routes.AutomaticExports.files()).flashing("error", messages.at("general.error.couldNotDownload", new Object[]{list.size()}));
        }
    }

    public Result deleteAutomaticExports(Http.Request request, Integer exportId) {
        String flashMessage;
        String flashKey;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String ids = exportId != null ? exportId.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        if (!Utils.showAutomaticExports(user)) {
            return AutomaticExports.redirect((Call)routes.AutomaticExports.index());
        }
        ArrayList<AutomaticExport> exports = new ArrayList<AutomaticExport>();
        for (Integer id : GeneralUtils.getSelectionIds(ids)) {
            AutomaticExport export = AutomaticExport.findById((int)id, (User)user);
            if (export == null) continue;
            exports.add(export);
        }
        AutomaticExport.delete(exports);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (!exports.isEmpty()) {
            flashKey = "success";
            flashMessage = messages.at("autexports.success.deleted", new Object[]{exports.size()});
        } else {
            flashKey = "warning";
            flashMessage = "autexports.error.nothingToDelete";
        }
        return AutomaticExports.redirect((Call)routes.AutomaticExports.index()).flashing(flashKey, flashMessage);
    }

    public Result files(Http.Request request) {
        List<ExportFile> list;
        Tenant tenant;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_EXPORT_FILES);
        List<Integer> exportIds = GeneralUtils.getSelectionIds(sorting.getProperty(EXPORT_IDS));
        ExportFileFilter filter = ExportFileFilter.getFilter((User)user);
        if (!exportIds.isEmpty()) {
            filter.setExportFileActive(true);
            filter.setAutomaticExportId(Integer.valueOf(Integer.parseInt(sorting.getProperty(EXPORT_IDS))));
            filter.save();
            sorting.setProperty(EXPORT_IDS, null);
        }
        Form filterForm = this.formFactory.form(AutomaticExportFileFilterForm.class).fill((Object)new AutomaticExportFileFilterForm(filter));
        try {
            int tenantId = Integer.parseInt(sorting.getProperty("TENANT", "-1"));
            tenant = Tenant.findById((int)tenantId, (User)user, (boolean)false);
        }
        catch (NumberFormatException e) {
            tenant = null;
        }
        try {
            list = this.filesList(user, sorting, filter, tenant);
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.CM_EXPORT_FILES, (Call)routes.AutomaticExports.files());
        }
        return AutomaticExports.ok((Content)autExportFiles.render(list, sorting, (Form<AutomaticExportFileFilterForm>)filterForm, filter, tenant, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }
}

