/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.Authenticator;
import controllers.DatabaseConnection;
import controllers.routes;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import play.Environment;
import play.i18n.MessagesApi;
import play.mvc.Call;
import play.mvc.Http;
import play.mvc.Result;

public class AuthenticatorFor
extends Authenticator {
    private Optional<String> userNameFromParentClass;
    private final List<PreferenceConstants> preferenceConstants;
    private final String errorMessageKey;

    private AuthenticatorFor(Environment environment, MessagesApi messagesApi, List<PreferenceConstants> preferences2, String errorMessageKey) {
        super(environment, messagesApi);
        this.preferenceConstants = preferences2;
        this.errorMessageKey = errorMessageKey;
    }

    private AuthenticatorFor(Environment environment, MessagesApi messagesApi, PreferenceConstants preference2, String errorMessageKey) {
        this(environment, messagesApi, Collections.singletonList(preference2), errorMessageKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<String> getUsername(Http.Request request) {
        this.userNameFromParentClass = super.getUsername(request);
        if (!this.userNameFromParentClass.isPresent()) return this.userNameFromParentClass;
        Class<DatabaseConnection> clazz = DatabaseConnection.class;
        synchronized (DatabaseConnection.class) {
            User user = User.getUser((String)this.userNameFromParentClass.get());
            for (PreferenceConstants constant : this.preferenceConstants) {
                boolean viewAllowed = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)constant);
                if (viewAllowed) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Optional.empty();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.userNameFromParentClass;
        }
    }

    @Override
    public Result onUnauthorized(Http.Request request) {
        if (this.userNameFromParentClass.isPresent()) {
            return AuthenticatorFor.redirect((Call)routes.Application.index()).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at(this.errorMessageKey, new Object[0]));
        }
        return super.onUnauthorized(request);
    }

    public static class BanksAndAccounts
    extends AuthenticatorFor {
        @Inject
        public BanksAndAccounts(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, Arrays.asList(PreferenceConstants.ALLOW_SETTINGS, PreferenceConstants.ALLOW_BANKS_AND_ACCOUNTS), "bank.andAccounts.nopermission");
        }
    }

    public static class Settings
    extends AuthenticatorFor {
        @Inject
        public Settings(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, PreferenceConstants.ALLOW_SETTINGS, "settings.nopermission");
        }
    }

    public static class SendFile
    extends AuthenticatorFor {
        @Inject
        public SendFile(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, PreferenceConstants.ALLOW_SEND_FILES, "sent.error.nopermission");
        }
    }

    public static class Payment
    extends AuthenticatorFor {
        @Inject
        public Payment(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, PreferenceConstants.ALLOW_PAYMENT_RECORDING, "payment.error.nopermission");
        }
    }

    public static class Folders
    extends AuthenticatorFor {
        @Inject
        public Folders(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, PreferenceConstants.ALLOW_FOLDER_FILES, "folders.nopermission");
        }
    }

    public static class Notifications
    extends AuthenticatorFor {
        @Inject
        public Notifications(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, PreferenceConstants.ALLOW_NOTIFICATIONS, "notifications.error.nopermission");
        }
    }

    public static class FetchFile
    extends AuthenticatorFor {
        @Inject
        public FetchFile(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, PreferenceConstants.ALLOW_FETCH_FILES, "fetched.error.nopermission");
        }
    }

    public static class DES
    extends AuthenticatorFor {
        @Inject
        public DES(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, PreferenceConstants.ALLOW_VEU, "desoverview.nopermission");
        }
    }

    public static class CM
    extends AuthenticatorFor {
        @Inject
        public CM(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, PreferenceConstants.ALLOW_VIEW_ACCOUNT_STATEMENTS, "cm.nopermission");
        }
    }

    public static class AWV
    extends AuthenticatorFor {
        @Inject
        public AWV(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, PreferenceConstants.ALLOW_AWV_RECORDING, "awv.nopermission");
        }
    }

    public static class AppSync
    extends AuthenticatorFor {
        @Inject
        public AppSync(Environment environment, MessagesApi messagesApi) {
            super(environment, messagesApi, PreferenceConstants.ALLOW_SYNCHRONISATION, "syncwithapp.nopermission");
        }
    }
}

