/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.JsonFactory;
import controllers.Setup;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.LicenseHandler;
import de.businesslogics.banking.api.AbstractLicenseHandler;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.LoginSession;
import de.businesslogics.banking.database.vo.OpenIdToken;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.preferences.PreferenceConstants;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import play.Environment;
import play.i18n.MessagesApi;
import play.mvc.Call;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;

public class Authenticator
extends Security.Authenticator {
    public static GenericUrl openIdRefreshUrl;
    public static GenericUrl openIdRevokeUrl;
    private final Environment environment;
    protected final MessagesApi messagesApi;

    @Inject
    public Authenticator(Environment environment, MessagesApi messagesApi) {
        this.environment = environment;
        this.messagesApi = messagesApi;
    }

    public static void setOpenIdToken(String openIDUserId, IdTokenResponse tokenResponse) {
        OpenIdToken token = OpenIdToken.getOrCreateForUser((User)User.getUser((String)openIDUserId));
        if (tokenResponse.getRefreshToken() != null) {
            token.setRefreshToken(tokenResponse.getRefreshToken());
        } else if (tokenResponse.getAccessToken() != null) {
            token.setAccessToken(tokenResponse.getAccessToken());
        }
        token.setIdToken(tokenResponse.getIdToken());
        token.save();
    }

    public static void revokeOpenIdToken(String openIDUserId) {
        if (openIdRevokeUrl == null) {
            BLLoggerPlay.error("Failed to revoke OpenID token, revoke URL is null!");
            return;
        }
        User user = User.getUser((String)openIDUserId);
        OpenIdToken token = OpenIdToken.findForUser((User)user);
        if (token != null) {
            String accessToken = token.getAccessToken();
            HttpRequestFactory factory = Setup.OPENID_CLIENT.getTransport().createRequestFactory(request -> Setup.OPENID_CLIENT.getClientAuthentication().intercept(request));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("token", accessToken);
            try {
                factory.buildPostRequest(openIdRevokeUrl, (HttpContent)new UrlEncodedContent(data)).execute();
            }
            catch (IOException e) {
                BLLoggerPlay.error(e.getMessage());
            }
            OpenIdToken.deleteByUser((User)user);
        }
    }

    public Optional<String> getUsername(Http.Request request) {
        if (!Setup.setupComplete(this.environment)) {
            return Optional.empty();
        }
        long id = Long.parseLong(request.session().get("id").orElse("0"));
        if (id == 0L || !Authenticator.checkLoginSession(id)) {
            return Optional.empty();
        }
        User user = ((LoginSession)DB.find(LoginSession.class, (Object)id)).getUser();
        if (user == null) {
            return Optional.empty();
        }
        String username = user.getName();
        if (LicenseHandler.getInstance().checkLicense(user) != AbstractLicenseHandler.LicenseCheckResult.OK) {
            return Optional.empty();
        }
        if (user.getLastPasswordChange() == null || user.hasResetPassword()) {
            return Optional.empty();
        }
        if (PasswordRequirement.getRequirement().hasToChange(user)) {
            return Optional.empty();
        }
        if (user.isToBeImported()) {
            return Optional.empty();
        }
        if (Authenticator.require2FAforLogin(user) && !Yubikey.hasAnyKeys((User)user)) {
            return Optional.empty();
        }
        if (user.getWebLicense() == null) {
            for (User u : User.getAll()) {
                if (LicenseHandler.getInstance().checkLicense(u) != AbstractLicenseHandler.LicenseCheckResult.OK) continue;
                user.setWebLicense(u.getWebLicense());
                user.save();
                break;
            }
        }
        if (Setup.OPENID_CLIENT != null) {
            IdToken idToken;
            OpenIdToken token = OpenIdToken.findForUser((User)User.getUser((String)username));
            if (token == null) {
                return Optional.empty();
            }
            try {
                idToken = IdToken.parse((JsonFactory)Setup.OPENID_CLIENT.getJsonFactory(), (String)token.getIdToken());
            }
            catch (IOException e) {
                BLLoggerPlay.getLogger().logError("Could not parse OpenID token string from database! " + e.getMessage());
                return Optional.empty();
            }
            if ("GET".equals(request.method()) && !idToken.verifyExpirationTime(System.currentTimeMillis(), Setup.OPENID_VERIFIER.getAcceptableTimeSkewSeconds())) {
                String refreshToken = token.getRefreshToken();
                if (refreshToken == null || openIdRefreshUrl == null) {
                    return Optional.empty();
                }
                BLLoggerPlay.info("OpenID token expired for " + username + ", trying to refresh ...");
                RefreshTokenRequest refreshRequest = new RefreshTokenRequest(Setup.OPENID_CLIENT.getTransport(), Setup.OPENID_CLIENT.getJsonFactory(), openIdRefreshUrl, refreshToken);
                try {
                    IdTokenResponse response = IdTokenResponse.execute((TokenRequest)refreshRequest);
                    idToken = response.parseIdToken();
                    if (!Setup.OPENID_VERIFIER.verify(idToken)) {
                        return Optional.empty();
                    }
                    Authenticator.setOpenIdToken(username, response);
                }
                catch (IOException e) {
                    BLLoggerPlay.error("Error occurred while refreshing OpenID token: " + e.getMessage());
                    return Optional.empty();
                }
            }
        }
        return Optional.ofNullable(username);
    }

    public Result onUnauthorized(Http.Request request) {
        if (Setup.setupComplete(this.environment)) {
            User user;
            long id = Long.parseLong(request.session().get("id").orElse("0"));
            if (id > 0L && Authenticator.checkLoginSession(id) && (user = ((LoginSession)DB.find(LoginSession.class, (Object)id)).getUser()) != null) {
                AbstractLicenseHandler.LicenseCheckResult licenseResult = LicenseHandler.getInstance().checkLicense(user);
                if (licenseResult != AbstractLicenseHandler.LicenseCheckResult.OK) {
                    String flash2 = licenseResult.getMessage(this.messagesApi.preferred((Http.RequestHeader)request).lang().locale());
                    return Authenticator.redirect((Call)routes.Logins.invalidLicense(user.getName())).flashing("error", flash2);
                }
                if (user.isToBeImported()) {
                    return Authenticator.redirect((Call)routes.UserSetup.selectImportForm());
                }
                if (user.getLastPasswordChange() == null || user.hasResetPassword()) {
                    return Authenticator.redirect((Call)Branding.getBranding().getNewUserSetup());
                }
                if (PasswordRequirement.getRequirement().hasToChange(user)) {
                    return Authenticator.redirect((Call)routes.UserSetup.changePasswordPage());
                }
                if (Authenticator.require2FAforLogin(user) && !Yubikey.hasAnyKeys((User)user)) {
                    request.session().adding("loginuser", String.valueOf(user.getId()));
                    String flash3 = this.messagesApi.preferred((Http.RequestHeader)request).at("yubikeys.requiredForLogin", new Object[0]);
                    return Authenticator.redirect((Call)routes.Logins.addWebAuthnPage());
                }
            }
            if (Setup.OPENID_CLIENT != null) {
                AuthorizationCodeRequestUrl acr = Setup.OPENID_CLIENT.newAuthorizationUrl();
                acr.setRedirectUri(Authenticator.buildOpenIdRedirectURL(request));
                if (Setup.OPENID_ACR_VALUES != null && !Setup.OPENID_ACR_VALUES.isEmpty()) {
                    acr.set("acr_values", (Object)Setup.OPENID_ACR_VALUES);
                }
                String target = request.uri();
                if ("POST".equals(request.method())) {
                    target = routes.Application.index().path();
                }
                return Authenticator.redirect((String)acr.build()).addingToSession(request, "GOTO_URL", target);
            }
            return Authenticator.redirect((Call)routes.Logins.index()).addingToSession(request, "GOTO_URL", request.uri());
        }
        return Authenticator.redirect((Call)routes.Setup.index());
    }

    public static boolean checkLoginSession(long sessionId) {
        LoginSession session = (LoginSession)DB.find(LoginSession.class, (Object)sessionId);
        if (session == null) {
            return false;
        }
        List tenants2 = session.getUser().getTenants();
        long min = Setup.SESSION_TIMEOUT;
        for (Tenant tenant : tenants2) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, session.getUser(), tenant);
            long tenantTimeout = preferenceStore.getLong((DatabasePreferenceConstant)PreferenceConstants.SESSION_TIMEOUT);
            if ((tenantTimeout = tenantTimeout * 60L * 1000L) <= 0L) continue;
            min = Math.min(min, tenantTimeout);
        }
        return LoginSession.updateSession((long)sessionId, (long)min);
    }

    public static boolean require2FAforLogin(User user) {
        if (Setup.REQUIRE_2FA_FOR_LOGIN) {
            return true;
        }
        if (user == null) {
            return false;
        }
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user, null);
        if (store.getBoolean((DatabasePreferenceConstant)PreferenceConstants.REQUIRE_2FA_FOR_LOGIN)) {
            Setup.REQUIRE_2FA_FOR_LOGIN = true;
            return true;
        }
        for (Tenant t : user.getTenants()) {
            DatabasePreferenceStore store2 = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user, t);
            if (!store2.getBoolean((DatabasePreferenceConstant)PreferenceConstants.REQUIRE_2FA_FOR_LOGIN)) continue;
            return true;
        }
        return false;
    }

    public static String buildOpenIdRedirectURL(Http.Request request) {
        if (Setup.OPENID_REDIRECT_URL != null) {
            return Setup.OPENID_REDIRECT_URL;
        }
        if (Setup.WEBAUTHN_URL != null) {
            return Setup.WEBAUTHN_URL + String.valueOf(routes.Logins.openIdLogin(null, null, null));
        }
        if (Setup.WEBSOCKET_URL != null) {
            if (Setup.WEBSOCKET_URL_SECURE) {
                return "https://" + Setup.WEBSOCKET_URL + String.valueOf(routes.Logins.openIdLogin(null, null, null));
            }
            return "http://" + Setup.WEBSOCKET_URL + String.valueOf(routes.Logins.openIdLogin(null, null, null));
        }
        return routes.Logins.openIdLogin(null, null, null).absoluteURL(request);
    }
}

