/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import controllers.AppSync;
import controllers.Authenticator;
import controllers.BalanceLists;
import controllers.DatabaseConnection;
import controllers.DesOverview;
import controllers.Users;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.SortingHandler;
import controllers.util.UserNotificationHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.PreferenceUtil;
import de.businesslogics.banking.api.ProgressMonitorDummy;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmCheck;
import de.businesslogics.banking.database.vo.CmValueGroup;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SimpleTextFilter;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.ValueBalancesDataProvider;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.Currency;
import de.businesslogics.util.IProgressMonitorWrapper;
import de.businesslogics.util.PaymentUtils;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import models.SimpleTextForm;
import play.data.DynamicForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Lang;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.index;

@Security.Authenticated(value=Authenticator.class)
public class Application
extends Controller {
    private final MessagesApi messagesApi;
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;

    public static String loadIndexPageJsParameters(boolean fetchNow) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("fetchOverviewLink", routes.Application.fetchDesOverview().toString());
        resultJson.put("fetchNow", fetchNow);
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    @Inject
    public Application(MessagesApi messagesApi, FormFactory formFactory, ClassLoaderExecutionContext executionContext) {
        this.messagesApi = messagesApi;
        this.formFactory = formFactory;
        this.executionContext = executionContext;
    }

    public Result index(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (user.isAdmin() && Branding.getBranding().showUserTableForOneBankAtStartpage()) {
            return this.handleUserTable(request, null, null, null, null);
        }
        return this.handleAccountTableValueBalance(request);
    }

    public Result disableVopHint(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
        store.setValue((DatabasePreferenceConstant)PreferenceConstants.HIDE_VOP_HINT, true);
        return Application.redirect((Call)routes.Application.index());
    }

    public Result usersFilter(Http.Request request, boolean filterActive) {
        Users.setupUsersFilter(request, filterActive, this.formFactory);
        return Application.redirect((Call)routes.Application.index());
    }

    public Result usersSort(Http.Request request, int sort, boolean ascending) {
        return this.handleUserTable(request, null, null, sort, ascending);
    }

    public Result usersWithPage(Http.Request request, int pageNumber, int pageSize) {
        return this.handleUserTable(request, pageNumber, pageSize, null, null);
    }

    public Result handleAccountTableValueBalance(Http.Request request) {
        return this.handleAccountTable(request, true);
    }

    public Result handleAccountTableBookingBalance(Http.Request request) {
        return this.handleAccountTable(request, false);
    }

    public Result accountsWithPage(Http.Request request, int pageNumber, int pageSize, boolean valueBalances) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2).updatePage(pageNumber, pageSize);
        return this.handleAccountTable(request, valueBalances);
    }

    public Result accountsWithSort(Http.Request request, boolean valueBalances, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2).updateSort(sort, asc);
        return this.handleAccountTable(request, valueBalances);
    }

    public CompletionStage<Result> registerUserNotification(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
        Lang lang = this.messagesApi.preferred((Http.RequestHeader)request).lang();
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonNode node = Json.parse((byte[])Base64.getUrlDecoder().decode(((SimpleTextForm)form.get()).text));
                String url = node.get("endpoint").asText();
                node = node.get("keys");
                UserNotificationHandler.getInstance().registerPushNotification(user, lang.code(), url, node.get("p256dh").asText(), node.get("auth").asText());
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to register push notification!", e);
            }
            return Application.ok();
        }, this.executionContext.current());
    }

    private Result handleAccountTable(Http.Request request, boolean valueBalances) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean allowCM = PreferenceUtil.doAllowViewAccountStatements((User)user);
        boolean preferenceSet = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.SHOW_BALANCE_LIST_ON_START_PAGE);
        if (allowCM && preferenceSet) {
            SortingHandler accountSorting = new SortingHandler(user, Sorting.Table.CM_VALUE_BALANCES2);
            int dateCount = BalanceLists.safeParseInt(accountSorting, "Datecount", BalanceLists.DEFAULT_DATE_COUNT);
            int groupId = Integer.parseInt(accountSorting.getProperty("Group", "-1"));
            CmValueGroup group = CmValueGroup.findById((Integer)groupId, (User)user);
            int diff = BalanceLists.safeParseInt(accountSorting, "Datediff", -3);
            Calendar c = Calendar.getInstance();
            c.add(5, diff);
            Date startDate = c.getTime();
            ProgressMonitorDummy monitorDummy = ProgressMonitorDummy.getInstance();
            DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
            ValueBalancesDataProvider provider = new ValueBalancesDataProvider(group, c, dateCount, valueBalances, store, (IProgressMonitorWrapper)monitorDummy);
            ValueBalancesDataProvider.Data[] data = BalanceLists.getPagedBalanceListsData(user, provider, accountSorting);
            return Application.ok((Content)index.render(null, null, data, startDate, dateCount, valueBalances, accountSorting, this.getNumberOfNewDesOrders(user), this.getNumberOfNewStatements(user), null, null, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        return Application.ok((Content)index.render(null, null, null, null, null, true, null, this.getNumberOfNewDesOrders(user), this.getNumberOfNewStatements(user), null, null, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private Result handleUserTable(Http.Request request, Integer pageNumber, Integer pageSize, Integer sort, Boolean sortAscending) {
        String filterText;
        HashMap<String, String> flashMap;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.START_PAGE_USERS);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (Users.isNotManagingUser(messages, user, flashMap = new HashMap<String, String>())) {
            return Application.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.USERS);
        Expression filterExpression = null;
        if (filter.isFilterActive()) {
            filterExpression = BankUser.getFilterExpression((String)filter.getFilterText());
        }
        SimpleTextForm filterValue = new SimpleTextForm();
        filterValue.text = filter.getFilterText();
        Form filterForm = this.formFactory.form(SimpleTextForm.class).fill((Object)filterValue);
        String string = filterText = filter.isFilterActive() ? filter.getFilterText() : null;
        if (pageNumber != null && pageSize != null) {
            sorting.updatePage(pageNumber, pageSize);
        }
        if (sort != null && sortAscending != null) {
            sorting.updateSort(sort, sortAscending);
        }
        Query<BankUser> bankUsers = this.bankUserQuery(sorting, filterExpression);
        return Application.ok((Content)index.render(bankUsers.findList(), sorting, null, null, null, true, null, this.getNumberOfNewDesOrders(user), this.getNumberOfNewStatements(user), (Form<SimpleTextForm>)filterForm, filterText, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private Query<BankUser> bankUserQuery(SortingHandler sorting, Expression filterExpression) {
        ExpressionList expr = DB.find(BankUser.class).where().eq("bank.url", (Object)Branding.getBranding().getUrl()).eq("bank.hostId", (Object)Branding.getBranding().getHostId()).isNotNull("defaultUser");
        if (filterExpression != null) {
            expr.add(filterExpression);
        }
        Query query = expr.query();
        sorting.computeForQuery(query);
        int sort = sorting.getSortingColumn();
        boolean asc = sorting.isSortingAscending();
        switch (sort) {
            case 0: {
                if (asc) {
                    query = query.order("bank.tenant.name asc");
                    break;
                }
                query = query.order("bank.tenant.name desc");
                break;
            }
            case 1: {
                if (asc) {
                    query = query.order("bank.customerId asc");
                    break;
                }
                query = query.order("bank.customerId desc");
                break;
            }
            case 2: {
                if (asc) {
                    query = query.order("default_user asc");
                    break;
                }
                query = query.order("default_user desc");
                break;
            }
            case 3: {
                if (asc) {
                    query = query.order("deactivated asc, state asc");
                    break;
                }
                query = query.order("deactivated desc, state desc");
                break;
            }
            case 4: {
                Object orderByClause;
                if (asc) {
                    orderByClause = "user.lastLogin ASC";
                    if (DBType.PSQL.equals((Object)DatabaseConnection.getInstance().getDbType())) {
                        orderByClause = (String)orderByClause + " NULLS FIRST";
                    }
                } else {
                    orderByClause = "user.lastLogin DESC";
                    if (DBType.PSQL.equals((Object)DatabaseConnection.getInstance().getDbType())) {
                        orderByClause = (String)orderByClause + " NULLS LAST";
                    }
                }
                query = query.order((String)orderByClause);
            }
        }
        return query;
    }

    private long getNumberOfNewDesOrders(User user) {
        return DsOpenOrder.queryForUser((User)user).where().eq("signable", (Object)true).findCount();
    }

    private long getNumberOfNewStatements(User user) {
        return CmCheck.getAccountCountByUser((User)user);
    }

    public Result qrCode(String toEncode) {
        if (toEncode == null || toEncode.isEmpty()) {
            return Application.notFound();
        }
        try {
            String decrypted = AppSync.decryptFromPage(toEncode);
            HashMap<EncodeHintType, Integer> hints = new HashMap<EncodeHintType, Integer>();
            hints.put(EncodeHintType.MARGIN, 0);
            hints.put(EncodeHintType.ERROR_CORRECTION, (Integer)ErrorCorrectionLevel.H);
            BitMatrix matrix = new QRCodeWriter().encode(decrypted, BarcodeFormat.QR_CODE, 200, 200, hints);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)bout);
            return Application.ok((byte[])bout.toByteArray()).as("image/png");
        }
        catch (WriterException | IOException e) {
            BLLoggerPlay.error("Failed to generate QR code!", e);
            return Application.internalServerError((String)e.getLocalizedMessage());
        }
    }

    public Result addDecimals(Http.Request request) {
        return this.calculateDecimals(request, false);
    }

    /*
     * WARNING - void declaration
     */
    public Result addSumsWithCurrencyDecimals(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        ArrayList<String> decimalStrings = new ArrayList<String>();
        try {
            void var12_23;
            void var11_17;
            JsonNode dataNode = request.body().asJson().get("data");
            if (dataNode != null) {
                Iterator decimalsIterator = dataNode.elements();
                while (decimalsIterator.hasNext()) {
                    JsonNode json = (JsonNode)decimalsIterator.next();
                    decimalStrings.add(json.asText());
                }
            }
            HashMap<String, BigDecimal> curAmountMap = new HashMap<String, BigDecimal>();
            int count = 0;
            int countWithoutCurrency = 0;
            BigDecimal result = BigDecimal.ZERO;
            ObjectNode resultJson = Json.newObject();
            for (String string : decimalStrings) {
                ++count;
                String[] stringArray = string.split("-");
                String amount2 = stringArray[0];
                String currency = stringArray.length == 1 ? "EUR" : stringArray[1];
                if (amount2 != null && !amount2.isEmpty()) {
                    BigDecimal am = (BigDecimal)curAmountMap.get(currency);
                    if (am == null) {
                        am = BigDecimal.ZERO;
                    }
                    am = am.add(new BigDecimal(amount2));
                    curAmountMap.put(currency, am);
                    continue;
                }
                ++countWithoutCurrency;
            }
            StringBuilder amount3 = new StringBuilder();
            for (Map.Entry entry : curAmountMap.entrySet()) {
                String currency = (String)entry.getKey();
                BigDecimal totalSum = (BigDecimal)entry.getValue();
                String tmp = currency == null ? PaymentUtils.formatAmount((BigDecimal)totalSum, (Currency)null, (Locale)messages.lang().locale()) : PaymentUtils.formatAmount((BigDecimal)totalSum, (Currency)Currency.getInstance((String)currency), (Locale)messages.lang().locale());
                if (!amount3.toString().isEmpty()) {
                    amount3.append(", ");
                }
                amount3.append(tmp);
            }
            if (countWithoutCurrency > 0) {
                String string = MessageFormat.format(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.totalAmountInfoCountNoAmout", (Object[])new Object[0]), count, amount3, countWithoutCurrency);
                String string2 = MessageFormat.format(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.totalAmountInfoFilesCountNoAmout", (Object[])new Object[0]), count, amount3, countWithoutCurrency);
            } else {
                String string = MessageFormat.format(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.totalAmountInfo", (Object[])new Object[0]), count, amount3);
                String string3 = MessageFormat.format(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.totalAmountInfoFiles", (Object[])new Object[0]), count, amount3);
            }
            resultJson.put("sum", (String)var11_17);
            resultJson.put("sumFiles", (String)var12_23);
            return Application.ok((String)Json.asciiStringify((JsonNode)resultJson));
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Failed to add up decimals '" + Arrays.toString(decimalStrings.toArray()) + "'", e);
            return Application.badRequest((String)Utils.getLocalizedMessage(e, messages));
        }
    }

    public Result multiplyDecimals(Http.Request request) {
        return this.calculateDecimals(request, true);
    }

    private Result calculateDecimals(Http.Request request, boolean multiply) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        ArrayList<String> decimalStrings = new ArrayList<String>();
        try {
            JsonNode dataNode = request.body().asJson().get("data");
            if (dataNode != null) {
                Iterator decimalsIterator = dataNode.elements();
                while (decimalsIterator.hasNext()) {
                    JsonNode json = (JsonNode)decimalsIterator.next();
                    decimalStrings.add(json.asText());
                }
            }
            BigDecimal result = multiply ? BigDecimal.ONE : BigDecimal.ZERO;
            ObjectNode resultJson = Json.newObject();
            for (String decimalString : decimalStrings) {
                BigDecimal decimal = new BigDecimal(decimalString);
                result = multiply ? result.multiply(decimal) : result.add(decimal);
            }
            resultJson.put(multiply ? "product" : "sum", result.toPlainString());
            return Application.ok((String)Json.asciiStringify((JsonNode)resultJson));
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Failed to " + (multiply ? "multiply" : "add up") + " decimals '" + Arrays.toString(decimalStrings.toArray()) + "'", e);
            return Application.badRequest((String)Utils.getLocalizedMessage(e, messages));
        }
    }

    public Result fetchDesOverview(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        ObjectNode resultJson = Json.newObject();
        Map<String, String> flashMap = DesOverview.fetchDesOverviewSync(user, messages);
        if (Utils.hasErrorFlash(flashMap)) {
            resultJson.put("error", flashMap.get("error"));
        }
        resultJson.put("numberOfNewDesOrders", this.getNumberOfNewDesOrders(user));
        return Application.ok((String)Json.asciiStringify((JsonNode)resultJson));
    }

    public Result setTableColumns(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        DynamicForm form = this.formFactory.form().bindFromRequest(request, new String[0]);
        Sorting.Table table = Sorting.Table.valueOf((String)form.get("tableId"));
        String columnOrder = form.get("column_order");
        String columnVisibility = form.get("column_visibility");
        SortingHandler sorting = new SortingHandler(user, table);
        sorting.setColumnOrder(columnOrder);
        sorting.setColumnVisibilities(columnVisibility);
        SortingHandler.TableHandler handler = SortingHandler.TableHandler.getHandler(table);
        if (handler != null && handler.getRedirectRoute() != null) {
            return Application.redirect((Call)handler.getRedirectRoute());
        }
        String referer = Utils.getHeaderValue(request, "referer");
        if (referer != null && !referer.isEmpty()) {
            return Application.redirect((String)Utils.getHeaderValue(request, "referer"));
        }
        return Application.redirect((Call)routes.Application.index());
    }
}

