/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.ExportMasterData;
import de.businesslogics.banking.api.ProgressMonitorDummy;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.IProgressMonitorWrapper;
import de.businesslogics.zkasecurity.KeyStore;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.SimplePasswordCallback;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import models.AppSyncForm;
import models.WebAuthnData;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Lang;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.settings.appsyncresult;
import views.html.settings.appsyncstart;

@Security.Authenticated(value=AuthenticatorFor.AppSync.class)
public class AppSync
extends Controller {
    private static final char[] QR_CODE_PASSWORD = new char[]{'n', '5', 'd', 'N', 'X', 'T', 'A', 'c', 'T', 'A', 'c', 'T', 'A', '8', 'u', 'b', 'K', 'k', 't'};
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;
    private final MessagesApi messagesApi;

    public static String getMobileAppName(Messages messages) {
        return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"Printer.creator", (Object[])new Object[0]);
    }

    private static List<BankUser> findReadyBankUsers(User user) {
        List bankUsers = BankUser.findActiveBanksForUser((User)user);
        bankUsers.removeIf(bankUser -> bankUser.getState() != BankUser.UserState.READY);
        return bankUsers;
    }

    @Inject
    public AppSync(FormFactory formFactory, ClassLoaderExecutionContext executionContext, MessagesApi messagesApi) {
        this.formFactory = formFactory;
        this.executionContext = executionContext;
        this.messagesApi = messagesApi;
    }

    public Result start(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (user.isLocalUser() || !Util.isSyncronizationAllowed((User)user)) {
            return AppSync.redirect((Call)routes.Application.index());
        }
        HashMap<Object, String> formDataMap = new HashMap<Object, String>();
        formDataMap.put("useQrCode", String.valueOf(true));
        List<BankUser> bankUsers = AppSync.findReadyBankUsers(user);
        for (BankUser bankUser : bankUsers) {
            formDataMap.put("bank_" + bankUser.getBank().getBankId(), String.valueOf(true));
        }
        Form form = this.formFactory.form(AppSyncForm.class).bind((Lang)request.acceptLanguages().get(0), request.attrs(), formDataMap, new String[0]).discardingErrors();
        return AppSync.ok((Content)appsyncstart.render((Form<AppSyncForm>)form, bankUsers, WebAuthnData.build(user), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public CompletionStage<Result> execute(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            if (user.isLocalUser() || !Util.isSyncronizationAllowed((User)user)) {
                return AppSync.redirect((Call)routes.Application.index());
            }
            Form<AppSyncForm> form = this.formFactory.form(AppSyncForm.class).bindFromRequest(request, new String[0]);
            List<BankUser> selectedBankUsers = AppSyncForm.getSelectedBankUsers(form, user);
            String resultEncrypted = null;
            Object resultPlain = null;
            try {
                if (!form.hasErrors() && (form = ((AppSyncForm)form.get()).validate(form, user, selectedBankUsers, messages)).value().isPresent() && ((AppSyncForm)form.value().get()).isUserLocked()) {
                    BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                    return AppSync.redirect((Call)routes.Application.index()).flashing("error", "login.locked.user");
                }
                if (!form.hasErrors()) {
                    ExportMasterData handler = new ExportMasterData(selectedBankUsers, Util.WORKSPACEDIR, (PasswordCallback)new SimplePasswordCallback(((AppSyncForm)form.get()).password.toCharArray()), null, user.getTenants());
                    resultPlain = handler.sendToLicenseServer(user.getWebLicense().getId(), true, (IProgressMonitorWrapper)ProgressMonitorDummy.getInstance());
                    if (handler.getSynchronizationEncryptionKey() != null) {
                        resultPlain = (String)resultPlain + "|" + HexTool.toHex((byte[])handler.getSynchronizationEncryptionKey());
                    }
                    resultEncrypted = AppSync.encryptForPage((String)resultPlain);
                }
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to run synchronization!", e);
                form = form.withGlobalError(Utils.getLocalizedMessage(e, messages));
            }
            if (form.hasErrors()) {
                return AppSync.ok((Content)appsyncstart.render(form, AppSync.findReadyBankUsers(user), WebAuthnData.build(user), request, messages));
            }
            return AppSync.ok((Content)appsyncresult.render(resultEncrypted, resultPlain, request, messages));
        }, this.executionContext.current());
    }

    public static String encryptForPage(String data) {
        try {
            return HexTool.toHex((byte[])KeyStore.encryptData((byte[])data.getBytes(), (char[])QR_CODE_PASSWORD));
        }
        catch (Exception e) {
            BLLoggerPlay.error("Can not encrypt data for HTML page", e);
            return null;
        }
    }

    public static String decryptFromPage(String data) {
        try {
            return new String(KeyStore.decryptData((byte[])HexTool.fromHex((String)data), (char[])QR_CODE_PASSWORD));
        }
        catch (Exception e) {
            BLLoggerPlay.error("Can not decrypt data from HTML page", e);
            return "";
        }
    }
}

