/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.account.iban.SEPABankConnection;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BLZCache;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.SimpleTextFilter;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import io.ebean.Query;
import io.ebean.Transaction;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.AccountForm;
import models.SimpleTextForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.settings.accounts;
import views.html.settings.deleteAccountQuestion;
import views.html.settings.editaccount;
import views.html.settings.newaccount;

@Security.Authenticated(value=AuthenticatorFor.BanksAndAccounts.class)
public class Accounts
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;

    public static String getAccountNumber(Account account) {
        if (account.getIban() != null && !account.getIban().isEmpty()) {
            return IbanUtil.formatIBAN((String)account.getIban());
        }
        if (account.getGermanAccountNumber() != null && !account.getGermanAccountNumber().isEmpty()) {
            return account.getGermanAccountNumber();
        }
        if (account.getFrenchAccountNumber() != null && !account.getFrenchAccountNumber().isEmpty()) {
            return account.getFrenchAccountNumber();
        }
        if (account.getNationalAccountNumber() != null && !account.getNationalAccountNumber().isEmpty()) {
            return account.getNationalAccountNumber();
        }
        return "";
    }

    public static String getBankCode(Account account) {
        if (account.getBic() != null && !account.getBic().isEmpty()) {
            return account.getBic();
        }
        if (account.getGermanBankCode() != null && !account.getGermanBankCode().isEmpty()) {
            return account.getGermanBankCode();
        }
        if (account.getFrenchBankCode() != null && !account.getFrenchBankCode().isEmpty() && account.getFrenchBranchCode() != null && !account.getFrenchBranchCode().isEmpty()) {
            return account.getFrenchBankCode() + "/" + account.getFrenchBranchCode();
        }
        if (account.getNationalBankCode() != null) {
            return account.getNationalBankCode();
        }
        return "";
    }

    public static String getNewTitle(Messages messages, AccountType type) {
        if (type == AccountType.DOMESTIC) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.newGermanAccount", (Object[])new Object[0]);
        }
        if (type == AccountType.FOREIGN) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.newForeignAccount", (Object[])new Object[0]);
        }
        return null;
    }

    public static String getNewLead(Messages messages, AccountType type) {
        if (type == AccountType.DOMESTIC) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.newGermanAccountLead", (Object[])new Object[0]);
        }
        if (type == AccountType.FOREIGN) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.newForeignAccountLead", (Object[])new Object[0]);
        }
        return null;
    }

    public static String getEditTitle(Messages messages, AccountType type, Integer id) {
        Account account = (Account)DB.find(Account.class, (Object)id);
        if (account != null && account.isHTDAccount()) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.editHTDAccount", (Object[])new Object[0]);
        }
        if (account != null && account.isCMAccount()) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.editCMAccount", (Object[])new Object[0]);
        }
        if (type == AccountType.DOMESTIC) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.editGermanAccount", (Object[])new Object[0]);
        }
        if (type == AccountType.FOREIGN) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.editForeignAccount", (Object[])new Object[0]);
        }
        return null;
    }

    public static String getEditLead(Messages messages, AccountType type, Integer id) {
        Account account = (Account)DB.find(Account.class, (Object)id);
        if (account != null && account.isHTDAccount()) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.editHTDAccountLead", (Object[])new Object[0]);
        }
        if (account != null && account.isCMAccount()) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.editCMAccountLead", (Object[])new Object[0]);
        }
        if (type == AccountType.DOMESTIC) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.editGermanAccountLead", (Object[])new Object[0]);
        }
        if (type == AccountType.FOREIGN) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.editForeignAccountLead", (Object[])new Object[0]);
        }
        return null;
    }

    public static Map<Integer, List<Integer>> getBankUsers(User user) {
        HashMap<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
        for (BankSettings bank : BankSettings.findBanksForTenants((List)user.getTenants())) {
            ArrayList<Integer> userList = new ArrayList<Integer>();
            for (BankUser bankUser : DB.find(BankUser.class).where().eq("bank", (Object)bank).findList()) {
                userList.add(bankUser.getUser().getId());
            }
            result.put(bank.getBankId(), userList);
        }
        return result;
    }

    @Inject
    public Accounts(FormFactory formFactory, MessagesApi messagesApi) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
    }

    private Query<Account> query(User user, SortingHandler sorting, SimpleTextFilter filter, Tenant tenant) {
        Query query = Account.queryForPaymentAccounts((User)user);
        if (tenant != null) {
            query = query.where().eq("bank.tenant", (Object)tenant).query();
        }
        if (filter.isFilterActive()) {
            query.where(Account.getFilterExpression((String)filter.getFilterText(), (boolean)false));
        }
        String[] sortColumnNames = sorting.getSortingColumn() == 1 ? new String[]{"name"} : (sorting.getSortingColumn() == 2 ? new String[]{"description"} : (sorting.getSortingColumn() == 3 ? new String[]{"iban", "germanAccountNumber", "frenchAccountNumber", "nationalAccountNumber"} : (sorting.getSortingColumn() == 4 ? new String[]{"bic", "germanBankCode", "frenchBankCode", "frenchBranchCode", "nationalBankCode"} : (sorting.getSortingColumn() == 5 ? new String[]{"currency"} : (sorting.getSortingColumn() == 7 ? new String[]{"bank.tenant"} : new String[]{"bank.displayName", "name", "iban", "germanAccountNumber", "frenchAccountNumber", "nationalAccountNumber"})))));
        query.orderBy(null);
        for (String sortColumnName : sortColumnNames) {
            if (sorting.isSortingAscending()) {
                query.orderBy().asc(sortColumnName);
                continue;
            }
            query.orderBy().desc(sortColumnName);
        }
        return query;
    }

    public Result index_tenant(Http.Request request, Integer tenant) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.ACCOUNT).setProperty("TENANT", tenant != null ? String.valueOf(tenant) : null);
        return Accounts.redirect((Call)routes.Accounts.index());
    }

    public Result index(Http.Request request) {
        List list;
        Tenant tenant;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.ACCOUNT);
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.ACCOUNTS);
        try {
            int tenantId = Integer.parseInt(sorting.getProperty("TENANT", "-1"));
            tenant = Tenant.findById((int)tenantId, (User)user, (boolean)false);
        }
        catch (NumberFormatException e) {
            tenant = null;
        }
        Query<Account> query = this.query(user, sorting, filter, tenant);
        sorting.computeForQuery(query);
        SimpleTextForm simpleTextForm = new SimpleTextForm();
        simpleTextForm.text = filter.getFilterText();
        Form filterForm = this.formFactory.form(SimpleTextForm.class).fill((Object)simpleTextForm);
        String filterText = filter.isFilterActive() ? filter.getFilterText() : null;
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.ACCOUNT, (Call)routes.Accounts.index());
        }
        return Accounts.ok((Content)accounts.render(list, sorting, (Form<SimpleTextForm>)filterForm, filterText, tenant, request, messages));
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.ACCOUNT).updateSort(sort, ascending);
        return Accounts.redirect((Call)routes.Accounts.index());
    }

    public Result indexWithPage(Http.Request request, int pageNumber, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.ACCOUNT).updatePage(pageNumber, pageSize);
        return Accounts.redirect((Call)routes.Accounts.index());
    }

    public Result indexWithFilter(Http.Request request, boolean active) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.ACCOUNTS);
        if (active) {
            Form filterForm = this.formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
            String filterText = ((SimpleTextForm)filterForm.get()).text;
            if (filterText != null && !filterText.isEmpty()) {
                filter.setFilterText(filterText);
                filter.setFilterActive(true);
            } else {
                filter.setFilterText(null);
                filter.setFilterActive(false);
            }
        } else {
            filter.setFilterActive(false);
        }
        filter.save();
        return Accounts.redirect((Call)routes.Accounts.index());
    }

    public Result delete(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String accountIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        int nDeleted = 0;
        int nDowngradedToCM = 0;
        try (Transaction t = DB.beginTransaction();){
            for (Account account : this.getSelectedAccounts(accountIds)) {
                if (account.isHTDAccount() || BankUser.findBankUser((BankSettings)account.getBank(), (User)user) == null) continue;
                if (Account.canBeDeleted((Account)account)) {
                    Logger.logAccountDeleted((User)user, (Account)account);
                    Account.delete((Account)account);
                    ++nDeleted;
                    continue;
                }
                ++nDowngradedToCM;
            }
            t.commit();
        }
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        String message = messages.at("accounts.deleted", new Object[]{nDeleted});
        if (nDeleted == 0) {
            Utils.addToFlash(flashMap, "warning", message);
        } else {
            Utils.addToFlash(flashMap, "success", message);
        }
        if (nDowngradedToCM > 0) {
            Utils.addToFlash(flashMap, "success", messages.at("accounts.setToCM", new Object[]{nDowngradedToCM}));
        }
        return Accounts.redirect((Call)routes.Accounts.index()).flashing(flashMap);
    }

    public CompletionStage<Result> deleteSingleAccountQuestion(Http.Request request, Integer id) {
        return CompletableFuture.supplyAsync(() -> Accounts.deleteAccountsQuestion(request, id, this.messagesApi, this.formFactory));
    }

    public CompletionStage<Result> deleteQuestion(Http.Request request) {
        return CompletableFuture.supplyAsync(() -> Accounts.deleteAccountsQuestion(request, null, this.messagesApi, this.formFactory));
    }

    public static Result deleteAccountsQuestion(Http.Request request, Integer bankId, MessagesApi messagesApi, FormFactory formFactory) {
        boolean inDetails;
        String ids;
        Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        if (bankId != null) {
            ids = bankId.toString();
            inDetails = true;
        } else {
            ids = ((SimpleTextForm)formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            inDetails = false;
        }
        ArrayList<Account> banksToBeDeleted = new ArrayList<Account>();
        HashMap<String, String> flashMap = new HashMap<String, String>();
        for (Integer id : GeneralUtils.getSelectionIds(ids)) {
            Account account = (Account)DB.find(Account.class).where().eq("id", (Object)id).findOne();
            if (account == null || account.isHTDAccount()) continue;
            banksToBeDeleted.add(account);
        }
        if (banksToBeDeleted.isEmpty()) {
            Utils.addToFlash(flashMap, "warning", messages.at("bank.delete.error.nothingToDelete", new Object[0]));
            return Accounts.redirect((Call)routes.Banks.index()).flashing(flashMap);
        }
        HashMap<Account, List<String>> bankInfo = new HashMap<Account, List<String>>();
        for (Account b : banksToBeDeleted) {
            List<String> info = Accounts.prepareDeleteQuestion(b, messages.lang().toLocale());
            bankInfo.put(b, info);
        }
        return Accounts.ok((Content)deleteAccountQuestion.render(banksToBeDeleted, bankInfo, inDetails, flashMap, request, messages));
    }

    private static List<String> prepareDeleteQuestion(Account account, Locale locale) {
        ArrayList<String> result = new ArrayList<String>();
        int open = OpenPayment.countByAccount((Account)account);
        int periodic = PeriodicPayment.countByAccount((Account)account);
        int template = PaymentTemplate.countByAccount((Account)account);
        if (open > 0) {
            result.add(MessageFormat.format(BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.countOpenPayments", (Object[])new Object[0]), open));
        }
        if (periodic > 0) {
            result.add(MessageFormat.format(BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.countPeriodicPayments", (Object[])new Object[0]), periodic));
        }
        if (template > 0) {
            result.add(MessageFormat.format(BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.countPaymentTemplates", (Object[])new Object[0]), template));
        }
        return result;
    }

    public Result create(Http.Request request, String type) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return Accounts.ok((Content)newaccount.render((Form<AccountForm>)this.formFactory.form(AccountForm.class).fill((Object)AccountForm.getEmptyForm()), AccountType.valueOf(type), AccountForm.showUserPermissionsTab(user), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result calculateIban(Http.Request request, String type, boolean newAccount, int id, String context) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean showUserPermissionsTab = AccountForm.showUserPermissionsTab(user);
        EditContext editContext = EditContext.valueOf(context);
        String tab = AccountForm.getTabNameForEditContext(editContext);
        Form form = this.formFactory.form(AccountForm.class).bindFromRequest(request, new String[0]);
        String bankCode = form.field("bankCode").value().orElse(null);
        String accountNumber = form.field("accountNumber").value().orElse(null);
        if (bankCode == null || bankCode.isEmpty() || accountNumber == null || accountNumber.isEmpty()) {
            if (newAccount) {
                return Accounts.ok((Content)newaccount.render((Form<AccountForm>)form.withGlobalError(messages.at("accounts.calculateIban.missingValues", new Object[0])), AccountType.valueOf(type), showUserPermissionsTab, request, messages));
            }
            return Accounts.ok((Content)editaccount.render((Form<AccountForm>)form.withGlobalError(messages.at("accounts.calculateIban.missingValues", new Object[0])), AccountType.valueOf(type), editContext, id, showUserPermissionsTab, true, tab, request, messages));
        }
        SEPABankConnection sepaBankConnection = BLZCache.getSEPABankConnection((String)bankCode, (String)accountNumber);
        if (sepaBankConnection == null) {
            if (newAccount) {
                return Accounts.ok((Content)newaccount.render((Form<AccountForm>)form.withGlobalError(messages.at("accounts.calculateIban.failed", new Object[0])), AccountType.valueOf(type), showUserPermissionsTab, request, messages));
            }
            return Accounts.ok((Content)editaccount.render((Form<AccountForm>)form.withGlobalError(messages.at("accounts.calculateIban.failed", new Object[0])), AccountType.valueOf(type), editContext, id, showUserPermissionsTab, true, tab, request, messages));
        }
        if (form.hasErrors() && !form.hasGlobalErrors()) {
            form.withGlobalError(messages.at("general.formerror", new Object[0]));
        }
        HashMap<String, String> data = new HashMap<String, String>(form.rawData());
        data.put("bankCode", bankCode);
        data.put("accountNumber", accountNumber);
        data.put("iban", sepaBankConnection.getIban());
        data.put("bic", sepaBankConnection.getBic());
        form = form.bind(messages.lang(), null, data, new String[0]);
        if (newAccount) {
            return Accounts.ok((Content)newaccount.render((Form<AccountForm>)form, AccountType.valueOf(type), showUserPermissionsTab, request, messages));
        }
        return Accounts.ok((Content)editaccount.render((Form<AccountForm>)form, AccountType.valueOf(type), editContext, id, showUserPermissionsTab, true, tab, request, messages));
    }

    public Result calculateBic(Http.Request request, String type, boolean newAccount, int id, String context) {
        SEPABankConnection sepaBankConnection;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean showUserPermissionsTab = AccountForm.showUserPermissionsTab(user);
        EditContext editContext = EditContext.valueOf(context);
        String tab = AccountForm.getTabNameForEditContext(editContext);
        Form form = this.formFactory.form(AccountForm.class).bindFromRequest(request, new String[0]);
        String bankCode = form.field("bankCode").value().orElse(null);
        String accountNumber = form.field("accountNumber").value().orElse(null);
        String iban = form.field("iban").value().orElse(null);
        iban = StringUtils.removeAllWhitespace((String)iban);
        if (bankCode == null || bankCode.isEmpty() || accountNumber == null || accountNumber.isEmpty()) {
            if (iban != null && iban.length() == 22 && iban.startsWith("DE")) {
                accountNumber = iban.substring(12);
                bankCode = iban.substring(4, 12);
            } else {
                if (newAccount) {
                    return Accounts.ok((Content)newaccount.render((Form<AccountForm>)form.withGlobalError(messages.at("accounts.calculateBic.missingValues", new Object[0])), AccountType.valueOf(type), showUserPermissionsTab, request, messages));
                }
                return Accounts.ok((Content)editaccount.render((Form<AccountForm>)form.withGlobalError(messages.at("accounts.calculateBic.missingValues", new Object[0])), AccountType.valueOf(type), editContext, id, showUserPermissionsTab, true, tab, request, messages));
            }
        }
        if ((sepaBankConnection = BLZCache.getSEPABankConnection((String)bankCode, (String)accountNumber)) == null) {
            if (newAccount) {
                return Accounts.ok((Content)newaccount.render((Form<AccountForm>)form.withGlobalError(messages.at("accounts.calculateBic.failed", new Object[0])), AccountType.valueOf(type), showUserPermissionsTab, request, messages));
            }
            return Accounts.ok((Content)editaccount.render((Form<AccountForm>)form.withGlobalError(messages.at("accounts.calculateBic.failed", new Object[0])), AccountType.valueOf(type), editContext, id, showUserPermissionsTab, true, tab, request, messages));
        }
        if (form.hasErrors() && !form.hasGlobalErrors()) {
            form.withGlobalError(messages.at("general.formerror", new Object[0]));
        }
        HashMap<String, String> data = new HashMap<String, String>(form.rawData());
        data.put("bankCode", bankCode);
        data.put("accountNumber", accountNumber);
        data.put("iban", sepaBankConnection.getIban());
        data.put("bic", sepaBankConnection.getBic());
        form = form.bind(messages.lang(), null, data, new String[0]);
        if (newAccount) {
            return Accounts.ok((Content)newaccount.render((Form<AccountForm>)form, AccountType.valueOf(type), showUserPermissionsTab, request, messages));
        }
        return Accounts.ok((Content)editaccount.render((Form<AccountForm>)form, AccountType.valueOf(type), editContext, id, showUserPermissionsTab, true, tab, request, messages));
    }

    public Result saveNew(Http.Request request, String type) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean showUserPermissionsTab = AccountForm.showUserPermissionsTab(user);
        AccountType accountType = AccountType.valueOf(type);
        Form<AccountForm> form = this.formFactory.form(AccountForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors()) {
            form = ((AccountForm)form.get()).validate(form, null, accountType, user, messages, true);
        }
        if (form.hasErrors()) {
            if (!form.hasGlobalErrors()) {
                return Accounts.ok((Content)newaccount.render((Form<AccountForm>)form.withGlobalError(messages.at("general.formerror", new Object[0])), accountType, showUserPermissionsTab, request, messages));
            }
            return Accounts.ok((Content)newaccount.render(form, accountType, showUserPermissionsTab, request, messages));
        }
        ((AccountForm)form.get()).save(new Account(), accountType, true, user);
        return Accounts.redirect((Call)routes.Accounts.index()).flashing("success", messages.at("accounts.created", new Object[0]));
    }

    public static String loadJsParameters(Messages messages) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("selectedAccounts", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.countSelectedAccounts", (Object[])new Object[]{999}));
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public Result view(Http.Request request, Integer id, String context, String tab) {
        return this.editWithMode(request, id, context, tab, false);
    }

    public Result edit(Http.Request request, Integer id, String context, String tab) {
        return this.editWithMode(request, id, context, tab, true);
    }

    private Result editWithMode(Http.Request request, Integer id, String context, String tab, boolean inEditMode) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        EditContext editContext = EditContext.valueOf(context);
        boolean showUserPermissionsTab = AccountForm.showUserPermissionsTab(user);
        Account account = Account.findAccountByIdAndUser((int)id, (User)user, (!user.isAdmin() ? 1 : 0) != 0);
        if (tab == null) {
            tab = AccountForm.getTabNameForEditContext(editContext);
        }
        if (account == null) {
            return Accounts.redirect((Call)routes.Accounts.index()).flashing("error", messages.at("accounts.nopermission", new Object[0]));
        }
        AccountType type = account.getNationalAccountNumber() != null && !account.getNationalAccountNumber().isEmpty() ? AccountType.FOREIGN : AccountType.DOMESTIC;
        Form form = this.formFactory.form(AccountForm.class).fill((Object)new AccountForm(account, type));
        return Accounts.ok((Content)editaccount.render((Form<AccountForm>)form, type, editContext, id, showUserPermissionsTab, inEditMode, tab, request, messages));
    }

    public Result update(Http.Request request, Integer id, String type, String context) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Account account = Account.findAccountByIdAndUser((int)id, (User)user, (!user.isAdmin() ? 1 : 0) != 0);
        boolean showUserPermissionsTab = AccountForm.showUserPermissionsTab(user);
        EditContext editContext = EditContext.valueOf(context);
        String tab = AccountForm.getTabNameForEditContext(editContext);
        if (account == null || BankUser.findBankUser((BankSettings)account.getBank(), (User)user) == null) {
            return Accounts.redirect((Call)routes.Accounts.view(id, context, tab)).flashing("error", messages.at("accounts.notfound", new Object[0]));
        }
        AccountType accountType = AccountType.valueOf(type);
        Form<AccountForm> form = this.formFactory.form(AccountForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors()) {
            form = ((AccountForm)form.get()).validate(form, account, accountType, user, messages, false);
        }
        if (form.hasErrors()) {
            return Accounts.ok((Content)editaccount.render(form, accountType, editContext, id, showUserPermissionsTab, false, tab, request, messages)).flashing("error", messages.at("accounts.", new Object[]{form.errors().size()}));
        }
        ((AccountForm)form.get()).save(account, accountType, false, user);
        AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        logger.logAccountModified(user, account.getId().intValue());
        return Accounts.redirect((Call)routes.Accounts.view(id, context, tab)).flashing("success", messages.at("accounts.updated", new Object[0]));
    }

    private List<Account> getSelectedAccounts(String selection) {
        List<Integer> ids = GeneralUtils.getSelectionIds(selection);
        if (ids.isEmpty()) {
            return new ArrayList<Account>(0);
        }
        if (ids.size() == 1) {
            ArrayList<Account> result = new ArrayList<Account>(1);
            Account account = (Account)DB.find(Account.class, (Object)ids.getFirst());
            if (account != null) {
                result.add(account);
            }
            return result;
        }
        return DB.find(Account.class).where().in("id", ids).findList();
    }

    public static enum AccountType {
        DOMESTIC,
        FOREIGN;

    }

    public static enum EditContext {
        ACCOUNT_LIST,
        CM,
        CM_DETAILS;

    }
}

