/*
 * Decompiled with CFR 0.152.
 */
import com.typesafe.config.Config;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.Environment;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.routing.Router;
import play.http.DefaultHttpErrorHandler;
import play.i18n.MessagesApi;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;
import views.html.errorPages.badRequest;
import views.html.errorPages.internalServerError;
import views.html.errorPages.notFound;
import views.html.errorPages.unauthorized;

@Singleton
public class ErrorHandler
extends DefaultHttpErrorHandler {
    private final Environment environment;
    private final MessagesApi messagesApi;

    @Inject
    public ErrorHandler(Config configuration, Environment environment, OptionalSourceMapper sourceMapper, Provider<Router> routes2, MessagesApi messagesApi) {
        super(configuration, environment, sourceMapper, routes2);
        this.environment = environment;
        this.messagesApi = messagesApi;
    }

    protected CompletionStage<Result> onBadRequest(Http.RequestHeader request, String message) {
        return CompletableFuture.completedFuture(Results.badRequest((Content)badRequest.render(request.method(), request.withBody(null), this.messagesApi.preferred(request))));
    }

    protected CompletionStage<Result> onForbidden(Http.RequestHeader request, String message) {
        return CompletableFuture.completedFuture(Results.forbidden((Content)unauthorized.render(request.withBody(null), this.messagesApi.preferred(request))));
    }

    protected CompletionStage<Result> onNotFound(Http.RequestHeader request, String message) {
        if (this.environment.isProd()) {
            return CompletableFuture.completedFuture(Results.notFound((Content)notFound.render(request.method(), request.withBody(null), this.messagesApi.preferred(request))));
        }
        return super.onNotFound(request, message);
    }

    protected CompletionStage<Result> onOtherClientError(Http.RequestHeader request, int statusCode, String message) {
        return CompletableFuture.completedFuture(Results.status((int)statusCode, (Content)badRequest.render(request.method(), request.withBody(null), this.messagesApi.preferred(request))));
    }

    protected CompletionStage<Result> onProdServerError(Http.RequestHeader request, UsefulException exception) {
        return CompletableFuture.completedFuture(Results.internalServerError((Content)internalServerError.render(exception.id, request.withBody(null), this.messagesApi.preferred(request))));
    }
}

